/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class AttachedToLeavesDecorator
extends TreeDecorator {
    public static final MapCodec<AttachedToLeavesDecorator> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(var0 -> Float.valueOf(var0.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(var0 -> var0.exclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(var0 -> var0.exclusionRadiusY), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(var0 -> var0.blockProvider), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(var0 -> var0.requiredEmptyBlocks), (App)ExtraCodecs.nonEmptyList(Direction.CODEC.listOf()).fieldOf("directions").forGetter(var0 -> var0.directions)).apply((Applicative)var02, AttachedToLeavesDecorator::new));
    protected final float probability;
    protected final int exclusionRadiusXZ;
    protected final int exclusionRadiusY;
    protected final BlockStateProvider blockProvider;
    protected final int requiredEmptyBlocks;
    protected final List<Direction> directions;

    public AttachedToLeavesDecorator(float var0, int var1, int var2, BlockStateProvider var3, int var4, List<Direction> var5) {
        this.probability = var0;
        this.exclusionRadiusXZ = var1;
        this.exclusionRadiusY = var2;
        this.blockProvider = var3;
        this.requiredEmptyBlocks = var4;
        this.directions = var5;
    }

    @Override
    public void place(TreeDecorator.Context var0) {
        HashSet<BlockPos> var1 = new HashSet<BlockPos>();
        RandomSource var2 = var0.random();
        for (BlockPos var4 : Util.shuffledCopy(var0.leaves(), var2)) {
            Direction var5;
            BlockPos var6 = var4.relative(var5 = Util.getRandom(this.directions, var2));
            if (var1.contains(var6) || !(var2.nextFloat() < this.probability) || !this.hasRequiredEmptyBlocks(var0, var4, var5)) continue;
            BlockPos var7 = var6.offset(-this.exclusionRadiusXZ, -this.exclusionRadiusY, -this.exclusionRadiusXZ);
            BlockPos var8 = var6.offset(this.exclusionRadiusXZ, this.exclusionRadiusY, this.exclusionRadiusXZ);
            for (BlockPos var10 : BlockPos.betweenClosed(var7, var8)) {
                var1.add(var10.immutable());
            }
            var0.setBlock(var6, this.blockProvider.getState(var2, var6));
        }
    }

    private boolean hasRequiredEmptyBlocks(TreeDecorator.Context var0, BlockPos var1, Direction var2) {
        for (int var3 = 1; var3 <= this.requiredEmptyBlocks; ++var3) {
            BlockPos var4 = var1.relative(var2, var3);
            if (var0.isAir(var4)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.ATTACHED_TO_LEAVES;
    }
}

