/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CreakingHeartDecorator
extends TreeDecorator {
    public static final MapCodec<CreakingHeartDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CreakingHeartDecorator::new, var0 -> Float.valueOf(var0.probability));
    private final float probability;

    public CreakingHeartDecorator(float var0) {
        this.probability = var0;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.CREAKING_HEART;
    }

    @Override
    public void place(TreeDecorator.Context var0) {
        RandomSource var12 = var0.random();
        ObjectArrayList<BlockPos> var2 = var0.logs();
        if (var2.isEmpty()) {
            return;
        }
        if (var12.nextFloat() >= this.probability) {
            return;
        }
        ArrayList<BlockPos> var3 = new ArrayList<BlockPos>((Collection<BlockPos>)var2);
        Util.shuffle(var3, var12);
        Optional<BlockPos> var4 = var3.stream().filter(var1 -> {
            for (Direction var5 : Direction.values()) {
                if (var0.checkBlock(var1.relative(var5), var0 -> var0.is(BlockTags.LOGS))) continue;
                return false;
            }
            return true;
        }).findFirst();
        if (var4.isEmpty()) {
            return;
        }
        var0.setBlock(var4.get(), (BlockState)((BlockState)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.STATE, CreakingHeartState.DORMANT)).setValue(CreakingHeartBlock.NATURAL, true));
    }
}

