/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class UpwardsBranchingTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<UpwardsBranchingTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(var02 -> UpwardsBranchingTrunkPlacer.trunkPlacerParts(var02).and(var02.group((App)IntProvider.POSITIVE_CODEC.fieldOf("extra_branch_steps").forGetter(var0 -> var0.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(var0 -> Float.valueOf(var0.placeBranchPerLogProbability)), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("extra_branch_length").forGetter(var0 -> var0.extraBranchLength), (App)RegistryCodecs.homogeneousList(Registries.BLOCK).fieldOf("can_grow_through").forGetter(var0 -> var0.canGrowThrough))).apply((Applicative)var02, UpwardsBranchingTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;

    public UpwardsBranchingTrunkPlacer(int var0, int var1, int var2, IntProvider var3, float var4, IntProvider var5, HolderSet<Block> var6) {
        super(var0, var1, var2);
        this.extraBranchSteps = var3;
        this.placeBranchPerLogProbability = var4;
        this.extraBranchLength = var5;
        this.canGrowThrough = var6;
    }

    @Override
    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.UPWARDS_BRANCHING_TRUNK_PLACER;
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, int var3, BlockPos var4, TreeConfiguration var5) {
        ArrayList var6 = Lists.newArrayList();
        BlockPos.MutableBlockPos var7 = new BlockPos.MutableBlockPos();
        for (int var8 = 0; var8 < var3; ++var8) {
            int var9 = var4.getY() + var8;
            if (this.placeLog(var0, var1, var2, var7.set(var4.getX(), var9, var4.getZ()), var5) && var8 < var3 - 1 && var2.nextFloat() < this.placeBranchPerLogProbability) {
                Direction var10 = Direction.Plane.HORIZONTAL.getRandomDirection(var2);
                int var11 = this.extraBranchLength.sample(var2);
                int var12 = Math.max(0, var11 - this.extraBranchLength.sample(var2) - 1);
                int var13 = this.extraBranchSteps.sample(var2);
                this.placeBranch(var0, var1, var2, var3, var5, var6, var7, var9, var10, var12, var13);
            }
            if (var8 != var3 - 1) continue;
            var6.add(new FoliagePlacer.FoliageAttachment(var7.set(var4.getX(), var9 + 1, var4.getZ()), 0, false));
        }
        return var6;
    }

    private void placeBranch(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, int var3, TreeConfiguration var4, List<FoliagePlacer.FoliageAttachment> var5, BlockPos.MutableBlockPos var6, int var7, Direction var8, int var9, int var10) {
        int var11 = var7 + var9;
        int var12 = var6.getX();
        int var13 = var6.getZ();
        for (int var14 = var9; var14 < var3 && var10 > 0; ++var14, --var10) {
            if (var14 < 1) continue;
            int var15 = var7 + var14;
            var11 = var15;
            if (this.placeLog(var0, var1, var2, var6.set(var12 += var8.getStepX(), var15, var13 += var8.getStepZ()), var4)) {
                ++var11;
            }
            var5.add(new FoliagePlacer.FoliageAttachment(var6.immutable(), 0, false));
        }
        if (var11 - var7 > 1) {
            BlockPos var14 = new BlockPos(var12, var11, var13);
            var5.add(new FoliagePlacer.FoliageAttachment(var14, 0, false));
            var5.add(new FoliagePlacer.FoliageAttachment(var14.below(2), 0, false));
        }
    }

    @Override
    protected boolean validTreePos(LevelSimulatedReader var02, BlockPos var1) {
        return super.validTreePos(var02, var1) || var02.isStateAtPosition(var1, var0 -> var0.is(this.canGrowThrough));
    }
}

