/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.StructureFeatureIndexSavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jspecify.annotations.Nullable;

public class LegacyStructureDataHandler
implements LegacyTagFixer {
    public static final int LAST_MONOLYTH_STRUCTURE_DATA_VERSION = 1493;
    private static final Map<String, String> CURRENT_TO_LEGACY_MAP = Util.make(Maps.newHashMap(), hashmap -> {
        hashmap.put("Village", "Village");
        hashmap.put("Mineshaft", "Mineshaft");
        hashmap.put("Mansion", "Mansion");
        hashmap.put("Igloo", "Temple");
        hashmap.put("Desert_Pyramid", "Temple");
        hashmap.put("Jungle_Pyramid", "Temple");
        hashmap.put("Swamp_Hut", "Temple");
        hashmap.put("Stronghold", "Stronghold");
        hashmap.put("Monument", "Monument");
        hashmap.put("Fortress", "Fortress");
        hashmap.put("EndCity", "EndCity");
    });
    private static final Map<String, String> LEGACY_TO_CURRENT_MAP = Util.make(Maps.newHashMap(), hashmap -> {
        hashmap.put("Iglu", "Igloo");
        hashmap.put("TeDP", "Desert_Pyramid");
        hashmap.put("TeJP", "Jungle_Pyramid");
        hashmap.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> OLD_STRUCTURE_REGISTRY_KEYS = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean hasLegacyData;
    private final Map<String, Long2ObjectMap<CompoundTag>> dataMap = Maps.newHashMap();
    private final Map<String, StructureFeatureIndexSavedData> indexMap = Maps.newHashMap();
    private final @Nullable DimensionDataStorage dimensionDataStorage;
    private final List<String> legacyKeys;
    private final List<String> currentKeys;
    private final DataFixer dataFixer;
    private boolean cachesInitialized;

    public LegacyStructureDataHandler(@Nullable DimensionDataStorage worldpersistentdata, List<String> list, List<String> list1, DataFixer datafixer) {
        this.dimensionDataStorage = worldpersistentdata;
        this.legacyKeys = list;
        this.currentKeys = list1;
        this.dataFixer = datafixer;
        boolean flag = false;
        for (String s : this.currentKeys) {
            flag |= this.dataMap.get(s) != null;
        }
        this.hasLegacyData = flag;
    }

    @Override
    public void markChunkDone(ChunkPos chunkcoordintpair) {
        long i = chunkcoordintpair.toLong();
        for (String s : this.legacyKeys) {
            StructureFeatureIndexSavedData persistentindexed = this.indexMap.get(s);
            if (persistentindexed == null || !persistentindexed.hasUnhandledIndex(i)) continue;
            persistentindexed.removeIndex(i);
        }
    }

    @Override
    public int targetDataVersion() {
        return 1493;
    }

    @Override
    public CompoundTag applyFix(CompoundTag nbttagcompound) {
        int i;
        if (!this.cachesInitialized && this.dimensionDataStorage != null) {
            this.populateCaches(this.dimensionDataStorage);
        }
        if ((i = NbtUtils.getDataVersion(nbttagcompound)) < 1493 && (nbttagcompound = DataFixTypes.CHUNK.update(this.dataFixer, nbttagcompound, i, 1493)).getCompound("Level").flatMap(nbttagcompound1 -> nbttagcompound1.getBoolean("hasLegacyStructureData")).orElse(false).booleanValue()) {
            nbttagcompound = this.updateFromLegacy(nbttagcompound);
        }
        return nbttagcompound;
    }

    private CompoundTag updateFromLegacy(CompoundTag nbttagcompound) {
        CompoundTag nbttagcompound1 = nbttagcompound.getCompoundOrEmpty("Level");
        ChunkPos chunkcoordintpair = new ChunkPos(nbttagcompound1.getIntOr("xPos", 0), nbttagcompound1.getIntOr("zPos", 0));
        if (this.isUnhandledStructureStart(chunkcoordintpair.x, chunkcoordintpair.z)) {
            nbttagcompound = this.updateStructureStart(nbttagcompound, chunkcoordintpair);
        }
        CompoundTag nbttagcompound2 = nbttagcompound1.getCompoundOrEmpty("Structures");
        CompoundTag nbttagcompound3 = nbttagcompound2.getCompoundOrEmpty("References");
        for (String s : this.currentKeys) {
            boolean flag = OLD_STRUCTURE_REGISTRY_KEYS.contains(s.toLowerCase(Locale.ROOT));
            if (nbttagcompound3.getLongArray(s).isPresent() || !flag) continue;
            int i = 8;
            LongArrayList longlist = new LongArrayList();
            for (int j = chunkcoordintpair.x - 8; j <= chunkcoordintpair.x + 8; ++j) {
                for (int k = chunkcoordintpair.z - 8; k <= chunkcoordintpair.z + 8; ++k) {
                    if (!this.hasLegacyStart(j, k, s)) continue;
                    longlist.add(ChunkPos.asLong(j, k));
                }
            }
            nbttagcompound3.putLongArray(s, longlist.toLongArray());
        }
        nbttagcompound2.put("References", nbttagcompound3);
        nbttagcompound1.put("Structures", nbttagcompound2);
        nbttagcompound.put("Level", nbttagcompound1);
        return nbttagcompound;
    }

    private boolean hasLegacyStart(int i, int j, String s) {
        return !this.hasLegacyData ? false : this.dataMap.get(s) != null && this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(s)).hasStartIndex(ChunkPos.asLong(i, j));
    }

    private boolean isUnhandledStructureStart(int i, int j) {
        if (!this.hasLegacyData) {
            return false;
        }
        for (String s : this.currentKeys) {
            if (this.dataMap.get(s) == null || !this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(s)).hasUnhandledIndex(ChunkPos.asLong(i, j))) continue;
            return true;
        }
        return false;
    }

    private CompoundTag updateStructureStart(CompoundTag nbttagcompound, ChunkPos chunkcoordintpair) {
        CompoundTag nbttagcompound1 = nbttagcompound.getCompoundOrEmpty("Level");
        CompoundTag nbttagcompound2 = nbttagcompound1.getCompoundOrEmpty("Structures");
        CompoundTag nbttagcompound3 = nbttagcompound2.getCompoundOrEmpty("Starts");
        for (String s : this.currentKeys) {
            CompoundTag nbttagcompound4;
            Long2ObjectMap<CompoundTag> long2objectmap = this.dataMap.get(s);
            if (long2objectmap == null) continue;
            long i = chunkcoordintpair.toLong();
            if (!this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(s)).hasUnhandledIndex(i) || (nbttagcompound4 = (CompoundTag)long2objectmap.get(i)) == null) continue;
            nbttagcompound3.put(s, nbttagcompound4);
        }
        nbttagcompound2.put("Starts", nbttagcompound3);
        nbttagcompound1.put("Structures", nbttagcompound2);
        nbttagcompound.put("Level", nbttagcompound1);
        return nbttagcompound;
    }

    private synchronized void populateCaches(DimensionDataStorage worldpersistentdata) {
        if (!this.cachesInitialized) {
            for (String s : this.legacyKeys) {
                CompoundTag nbttagcompound = new CompoundTag();
                try {
                    nbttagcompound = worldpersistentdata.readTagFromDisk(s, DataFixTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES, 1493).getCompoundOrEmpty("data").getCompoundOrEmpty("Features");
                    if (nbttagcompound.isEmpty()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                nbttagcompound.forEach((s1, nbtbase) -> {
                    if (nbtbase instanceof CompoundTag) {
                        CompoundTag nbttagcompound1 = (CompoundTag)nbtbase;
                        long i = ChunkPos.asLong(nbttagcompound1.getIntOr("ChunkX", 0), nbttagcompound1.getIntOr("ChunkZ", 0));
                        ListTag nbttaglist = nbttagcompound1.getListOrEmpty("Children");
                        if (!nbttaglist.isEmpty()) {
                            Optional<String> optional = nbttaglist.getCompound(0).flatMap(nbttagcompound2 -> nbttagcompound2.getString("id"));
                            Map<String, String> map = LEGACY_TO_CURRENT_MAP;
                            Objects.requireNonNull(map);
                            optional.map(map::get).ifPresent(s2 -> nbttagcompound1.putString("id", (String)s2));
                        }
                        nbttagcompound1.getString("id").ifPresent(s2 -> this.dataMap.computeIfAbsent((String)s2, s3 -> new Long2ObjectOpenHashMap()).put(i, (Object)nbttagcompound1));
                    }
                });
                String s12 = s + "_index";
                StructureFeatureIndexSavedData persistentindexed = worldpersistentdata.computeIfAbsent(StructureFeatureIndexSavedData.type(s12));
                if (persistentindexed.getAll().isEmpty()) {
                    StructureFeatureIndexSavedData persistentindexed1 = new StructureFeatureIndexSavedData();
                    this.indexMap.put(s, persistentindexed1);
                    nbttagcompound.forEach((s2, nbtbase) -> {
                        if (nbtbase instanceof CompoundTag) {
                            CompoundTag nbttagcompound1 = (CompoundTag)nbtbase;
                            persistentindexed1.addIndex(ChunkPos.asLong(nbttagcompound1.getIntOr("ChunkX", 0), nbttagcompound1.getIntOr("ChunkZ", 0)));
                        }
                    });
                    continue;
                }
                this.indexMap.put(s, persistentindexed);
            }
            this.cachesInitialized = true;
        }
    }

    public static Supplier<LegacyTagFixer> getLegacyTagFixer(ResourceKey<LevelStem> resourcekey, Supplier<@Nullable DimensionDataStorage> supplier, DataFixer datafixer) {
        if (resourcekey == LevelStem.OVERWORLD) {
            return () -> new LegacyStructureDataHandler((DimensionDataStorage)supplier.get(), (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"), datafixer);
        }
        if (resourcekey == LevelStem.NETHER) {
            ImmutableList list = ImmutableList.of((Object)"Fortress");
            return () -> LegacyStructureDataHandler.lambda$getLegacyTagFixer$10(supplier, (List)list, datafixer);
        }
        if (resourcekey == LevelStem.END) {
            ImmutableList list1 = ImmutableList.of((Object)"EndCity");
            return () -> LegacyStructureDataHandler.lambda$getLegacyTagFixer$11(supplier, (List)list1, datafixer);
        }
        return LegacyTagFixer.EMPTY;
    }

    private static /* synthetic */ LegacyTagFixer lambda$getLegacyTagFixer$11(Supplier supplier, List list1, DataFixer datafixer) {
        return new LegacyStructureDataHandler((DimensionDataStorage)supplier.get(), list1, list1, datafixer);
    }

    private static /* synthetic */ LegacyTagFixer lambda$getLegacyTagFixer$10(Supplier supplier, List list, DataFixer datafixer) {
        return new LegacyStructureDataHandler((DimensionDataStorage)supplier.get(), list, list, datafixer);
    }
}

