/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class StructureFeatureIndexSavedData
extends SavedData {
    private final LongSet all;
    private final LongSet remaining;
    private static final Codec<LongSet> LONG_SET = Codec.LONG_STREAM.xmap(LongOpenHashSet::toSet, LongCollection::longStream);
    public static final Codec<StructureFeatureIndexSavedData> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)LONG_SET.fieldOf("All").forGetter(var0 -> var0.all), (App)LONG_SET.fieldOf("Remaining").forGetter(var0 -> var0.remaining)).apply((Applicative)var02, StructureFeatureIndexSavedData::new));

    public static SavedDataType<StructureFeatureIndexSavedData> type(String var0) {
        return new SavedDataType<StructureFeatureIndexSavedData>(var0, StructureFeatureIndexSavedData::new, CODEC, DataFixTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES);
    }

    private StructureFeatureIndexSavedData(LongSet var0, LongSet var1) {
        this.all = var0;
        this.remaining = var1;
    }

    public StructureFeatureIndexSavedData() {
        this((LongSet)new LongOpenHashSet(), (LongSet)new LongOpenHashSet());
    }

    public void addIndex(long var0) {
        this.all.add(var0);
        this.remaining.add(var0);
        this.setDirty();
    }

    public boolean hasStartIndex(long var0) {
        return this.all.contains(var0);
    }

    public boolean hasUnhandledIndex(long var0) {
        return this.remaining.contains(var0);
    }

    public void removeIndex(long var0) {
        if (this.remaining.remove(var0)) {
            this.setDirty();
        }
    }

    public LongSet getAll() {
        return this.all;
    }
}

