/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R7.persistence.DirtyCraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R7.util.TransformerGeneratorAccess;
import org.bukkit.event.world.AsyncStructureGenerateEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class StructureStart {
    public static final String INVALID_START_ID = "INVALID";
    public static final StructureStart INVALID_START = new StructureStart(null, new ChunkPos(0, 0), 0, new PiecesContainer(List.of()));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Structure structure;
    private final PiecesContainer pieceContainer;
    private final ChunkPos chunkPos;
    private int references;
    private volatile @Nullable BoundingBox cachedBoundingBox;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    public AsyncStructureGenerateEvent.Cause generationEventCause = AsyncStructureGenerateEvent.Cause.WORLD_GENERATION;

    public StructureStart(Structure structure, ChunkPos chunkcoordintpair, int i, PiecesContainer piecescontainer) {
        this.structure = structure;
        this.chunkPos = chunkcoordintpair;
        this.references = i;
        this.pieceContainer = piecescontainer;
    }

    public static @Nullable StructureStart loadStaticStart(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound, long i) {
        String s = nbttagcompound.getStringOr("id", "");
        if (INVALID_START_ID.equals(s)) {
            return INVALID_START;
        }
        HolderLookup.RegistryLookup iregistry = structurepieceserializationcontext.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        Structure structure = (Structure)iregistry.getValue(Identifier.parse(s));
        if (structure == null) {
            LOGGER.error("Unknown stucture id: {}", (Object)s);
            return null;
        }
        ChunkPos chunkcoordintpair = new ChunkPos(nbttagcompound.getIntOr("ChunkX", 0), nbttagcompound.getIntOr("ChunkZ", 0));
        int j = nbttagcompound.getIntOr("references", 0);
        ListTag nbttaglist = nbttagcompound.getListOrEmpty("Children");
        try {
            PiecesContainer piecescontainer = PiecesContainer.load(nbttaglist, structurepieceserializationcontext);
            if (structure instanceof OceanMonumentStructure) {
                piecescontainer = OceanMonumentStructure.regeneratePiecesAfterLoad(chunkcoordintpair, i, piecescontainer);
            }
            return new StructureStart(structure, chunkcoordintpair, j, piecescontainer);
        }
        catch (Exception exception) {
            LOGGER.error("Failed Start with id {}", (Object)s, (Object)exception);
            return null;
        }
    }

    public BoundingBox getBoundingBox() {
        BoundingBox structureboundingbox = this.cachedBoundingBox;
        if (structureboundingbox == null) {
            this.cachedBoundingBox = structureboundingbox = this.structure.adjustBoundingBox(this.pieceContainer.calculateBoundingBox());
        }
        return structureboundingbox;
    }

    public void placeInChunk(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair) {
        List<StructurePiece> list = this.pieceContainer.pieces();
        if (!list.isEmpty()) {
            BoundingBox structureboundingbox1 = list.get((int)0).boundingBox;
            BlockPos blockposition = structureboundingbox1.getCenter();
            BlockPos blockposition1 = new BlockPos(blockposition.getX(), structureboundingbox1.minY(), blockposition.getZ());
            List<StructurePiece> pieces = list.stream().filter(piece -> piece.getBoundingBox().intersects(structureboundingbox)).toList();
            if (!pieces.isEmpty()) {
                TransformerGeneratorAccess transformerAccess = new TransformerGeneratorAccess();
                transformerAccess.setHandle(generatoraccessseed);
                transformerAccess.setStructureTransformer(new CraftStructureTransformer(this.generationEventCause, generatoraccessseed, structuremanager, this.structure, structureboundingbox, chunkcoordintpair));
                for (StructurePiece piece2 : pieces) {
                    piece2.postProcess(transformerAccess, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition1);
                }
                transformerAccess.getStructureTransformer().discard();
            }
            this.structure.afterPlace(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, this.pieceContainer);
        }
    }

    public CompoundTag createTag(StructurePieceSerializationContext structurepieceserializationcontext, ChunkPos chunkcoordintpair) {
        CompoundTag nbttagcompound = new CompoundTag();
        if (!this.persistentDataContainer.isEmpty()) {
            nbttagcompound.put("StructureBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        if (this.isValid()) {
            nbttagcompound.putString("id", structurepieceserializationcontext.registryAccess().lookupOrThrow(Registries.STRUCTURE).getKey(this.structure).toString());
            nbttagcompound.putInt("ChunkX", chunkcoordintpair.x);
            nbttagcompound.putInt("ChunkZ", chunkcoordintpair.z);
            nbttagcompound.putInt("references", this.references);
            nbttagcompound.put("Children", this.pieceContainer.save(structurepieceserializationcontext));
            return nbttagcompound;
        }
        nbttagcompound.putString("id", INVALID_START_ID);
        return nbttagcompound;
    }

    public boolean isValid() {
        return !this.pieceContainer.isEmpty();
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public boolean canBeReferenced() {
        return this.references < this.getMaxReferences();
    }

    public void addReference() {
        ++this.references;
    }

    public int getReferences() {
        return this.references;
    }

    protected int getMaxReferences() {
        return 1;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public List<StructurePiece> getPieces() {
        return this.pieceContainer.pieces();
    }
}

