/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pieces;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.slf4j.Logger;

public record PiecesContainer(List<StructurePiece> pieces) {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Identifier JIGSAW_RENAME = Identifier.withDefaultNamespace("jigsaw");
    private static final Map<Identifier, Identifier> RENAMES = ImmutableMap.builder().put((Object)Identifier.withDefaultNamespace("nvi"), (Object)JIGSAW_RENAME).put((Object)Identifier.withDefaultNamespace("pcp"), (Object)JIGSAW_RENAME).put((Object)Identifier.withDefaultNamespace("bastionremnant"), (Object)JIGSAW_RENAME).put((Object)Identifier.withDefaultNamespace("runtime"), (Object)JIGSAW_RENAME).build();

    public PiecesContainer(List<StructurePiece> var0) {
        this.pieces = List.copyOf(var0);
    }

    public boolean isEmpty() {
        return this.pieces.isEmpty();
    }

    public boolean isInsidePiece(BlockPos var0) {
        for (StructurePiece var2 : this.pieces) {
            if (!var2.getBoundingBox().isInside(var0)) continue;
            return true;
        }
        return false;
    }

    public Tag save(StructurePieceSerializationContext var0) {
        ListTag var1 = new ListTag();
        for (StructurePiece var3 : this.pieces) {
            var1.add(var3.createTag(var0));
        }
        return var1;
    }

    public static PiecesContainer load(ListTag var0, StructurePieceSerializationContext var1) {
        ArrayList var2 = Lists.newArrayList();
        for (int var3 = 0; var3 < var0.size(); ++var3) {
            CompoundTag var4 = var0.getCompoundOrEmpty(var3);
            String var5 = var4.getStringOr("id", "").toLowerCase(Locale.ROOT);
            Identifier var6 = Identifier.parse(var5);
            Identifier var7 = RENAMES.getOrDefault(var6, var6);
            StructurePieceType var8 = BuiltInRegistries.STRUCTURE_PIECE.getValue(var7);
            if (var8 == null) {
                LOGGER.error("Unknown structure piece id: {}", (Object)var7);
                continue;
            }
            try {
                StructurePiece var9 = var8.load(var1, var4);
                var2.add(var9);
                continue;
            }
            catch (Exception var9) {
                LOGGER.error("Exception loading structure piece with id {}", (Object)var7, (Object)var9);
            }
        }
        return new PiecesContainer(var2);
    }

    public BoundingBox calculateBoundingBox() {
        return StructurePiece.createBoundingBox(this.pieces.stream());
    }
}

