/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public abstract class StructurePlacement {
    public static final Codec<StructurePlacement> CODEC = BuiltInRegistries.STRUCTURE_PLACEMENT.byNameCodec().dispatch(StructurePlacement::type, StructurePlacementType::codec);
    private static final int HIGHLY_ARBITRARY_RANDOM_SALT = 10387320;
    public final Vec3i locateOffset;
    public final FrequencyReductionMethod frequencyReductionMethod;
    public final float frequency;
    public final int salt;
    public final Optional<ExclusionZone> exclusionZone;

    protected static <S extends StructurePlacement> Products.P5<RecordCodecBuilder.Mu<S>, Vec3i, FrequencyReductionMethod, Float, Integer, Optional<ExclusionZone>> placementCodec(RecordCodecBuilder.Instance<S> var0) {
        return var0.group((App)Vec3i.offsetCodec(16).optionalFieldOf("locate_offset", (Object)Vec3i.ZERO).forGetter(StructurePlacement::locateOffset), (App)FrequencyReductionMethod.CODEC.optionalFieldOf("frequency_reduction_method", (Object)FrequencyReductionMethod.DEFAULT).forGetter(StructurePlacement::frequencyReductionMethod), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(StructurePlacement::frequency), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(StructurePlacement::salt), (App)ExclusionZone.CODEC.optionalFieldOf("exclusion_zone").forGetter(StructurePlacement::exclusionZone));
    }

    protected StructurePlacement(Vec3i var0, FrequencyReductionMethod var1, float var2, int var3, Optional<ExclusionZone> var4) {
        this.locateOffset = var0;
        this.frequencyReductionMethod = var1;
        this.frequency = var2;
        this.salt = var3;
        this.exclusionZone = var4;
    }

    protected Vec3i locateOffset() {
        return this.locateOffset;
    }

    protected FrequencyReductionMethod frequencyReductionMethod() {
        return this.frequencyReductionMethod;
    }

    protected float frequency() {
        return this.frequency;
    }

    protected int salt() {
        return this.salt;
    }

    protected Optional<ExclusionZone> exclusionZone() {
        return this.exclusionZone;
    }

    public boolean isStructureChunk(ChunkGeneratorStructureState var0, int var1, int var2) {
        return this.isPlacementChunk(var0, var1, var2) && this.applyAdditionalChunkRestrictions(var1, var2, var0.getLevelSeed()) && this.applyInteractionsWithOtherStructures(var0, var1, var2);
    }

    public boolean applyAdditionalChunkRestrictions(int var0, int var1, long var2) {
        return !(this.frequency < 1.0f) || this.frequencyReductionMethod.shouldGenerate(var2, this.salt, var0, var1, this.frequency);
    }

    public boolean applyInteractionsWithOtherStructures(ChunkGeneratorStructureState var0, int var1, int var2) {
        return !this.exclusionZone.isPresent() || !this.exclusionZone.get().isPlacementForbidden(var0, var1, var2);
    }

    protected abstract boolean isPlacementChunk(ChunkGeneratorStructureState var1, int var2, int var3);

    public BlockPos getLocatePos(ChunkPos var0) {
        return new BlockPos(var0.getMinBlockX(), 0, var0.getMinBlockZ()).offset(this.locateOffset());
    }

    public abstract StructurePlacementType<?> type();

    private static boolean probabilityReducer(long var0, int var2, int var3, int var4, float var5) {
        WorldgenRandom var6 = new WorldgenRandom(new LegacyRandomSource(0L));
        var6.setLargeFeatureWithSalt(var0, var2, var3, var4);
        return var6.nextFloat() < var5;
    }

    private static boolean legacyProbabilityReducerWithDouble(long var0, int var2, int var3, int var4, float var5) {
        WorldgenRandom var6 = new WorldgenRandom(new LegacyRandomSource(0L));
        var6.setLargeFeatureSeed(var0, var3, var4);
        return var6.nextDouble() < (double)var5;
    }

    private static boolean legacyArbitrarySaltProbabilityReducer(long var0, int var2, int var3, int var4, float var5) {
        WorldgenRandom var6 = new WorldgenRandom(new LegacyRandomSource(0L));
        var6.setLargeFeatureWithSalt(var0, var3, var4, 10387320);
        return var6.nextFloat() < var5;
    }

    private static boolean legacyPillagerOutpostReducer(long var0, int var2, int var3, int var4, float var5) {
        int var6 = var3 >> 4;
        int var7 = var4 >> 4;
        WorldgenRandom var8 = new WorldgenRandom(new LegacyRandomSource(0L));
        var8.setSeed((long)(var6 ^ var7 << 4) ^ var0);
        var8.nextInt();
        return var8.nextInt((int)(1.0f / var5)) == 0;
    }

    public static enum FrequencyReductionMethod implements StringRepresentable
    {
        DEFAULT("default", StructurePlacement::probabilityReducer),
        LEGACY_TYPE_1("legacy_type_1", StructurePlacement::legacyPillagerOutpostReducer),
        LEGACY_TYPE_2("legacy_type_2", StructurePlacement::legacyArbitrarySaltProbabilityReducer),
        LEGACY_TYPE_3("legacy_type_3", StructurePlacement::legacyProbabilityReducerWithDouble);

        public static final Codec<FrequencyReductionMethod> CODEC;
        private final String name;
        private final FrequencyReducer reducer;

        private FrequencyReductionMethod(String var2, FrequencyReducer var3) {
            this.name = var2;
            this.reducer = var3;
        }

        public boolean shouldGenerate(long var0, int var2, int var3, int var4, float var5) {
            return this.reducer.shouldGenerate(var0, var2, var3, var4, var5);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(FrequencyReductionMethod::values);
        }
    }

    @Deprecated
    public record ExclusionZone(Holder<StructureSet> otherSet, int chunkCount) {
        public static final Codec<ExclusionZone> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RegistryFileCodec.create(Registries.STRUCTURE_SET, StructureSet.DIRECT_CODEC, false).fieldOf("other_set").forGetter(ExclusionZone::otherSet), (App)Codec.intRange((int)1, (int)16).fieldOf("chunk_count").forGetter(ExclusionZone::chunkCount)).apply((Applicative)var0, ExclusionZone::new));

        boolean isPlacementForbidden(ChunkGeneratorStructureState var0, int var1, int var2) {
            return var0.hasStructureChunkInRange(this.otherSet, var1, var2, this.chunkCount);
        }
    }

    @FunctionalInterface
    public static interface FrequencyReducer {
        public boolean shouldGenerate(long var1, int var3, int var4, int var5, float var6);
    }
}

