/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.FeaturePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jspecify.annotations.Nullable;

public abstract class StructurePoolElement {
    public static final Codec<StructurePoolElement> CODEC = BuiltInRegistries.STRUCTURE_POOL_ELEMENT.byNameCodec().dispatch("element_type", StructurePoolElement::getType, StructurePoolElementType::codec);
    private static final Holder<StructureProcessorList> EMPTY = Holder.direct(new StructureProcessorList(List.of()));
    private volatile @Nullable StructureTemplatePool.Projection projection;

    protected static <E extends StructurePoolElement> RecordCodecBuilder<E, StructureTemplatePool.Projection> projectionCodec() {
        return StructureTemplatePool.Projection.CODEC.fieldOf("projection").forGetter(StructurePoolElement::getProjection);
    }

    protected StructurePoolElement(StructureTemplatePool.Projection var0) {
        this.projection = var0;
    }

    public abstract Vec3i getSize(StructureTemplateManager var1, Rotation var2);

    public abstract List<StructureTemplate.JigsawBlockInfo> getShuffledJigsawBlocks(StructureTemplateManager var1, BlockPos var2, Rotation var3, RandomSource var4);

    public abstract BoundingBox getBoundingBox(StructureTemplateManager var1, BlockPos var2, Rotation var3);

    public abstract boolean place(StructureTemplateManager var1, WorldGenLevel var2, StructureManager var3, ChunkGenerator var4, BlockPos var5, BlockPos var6, Rotation var7, BoundingBox var8, RandomSource var9, LiquidSettings var10, boolean var11);

    public abstract StructurePoolElementType<?> getType();

    public void handleDataMarker(LevelAccessor var0, StructureTemplate.StructureBlockInfo var1, BlockPos var2, Rotation var3, RandomSource var4, BoundingBox var5) {
    }

    public StructurePoolElement setProjection(StructureTemplatePool.Projection var0) {
        this.projection = var0;
        return this;
    }

    public StructureTemplatePool.Projection getProjection() {
        StructureTemplatePool.Projection var0 = this.projection;
        if (var0 == null) {
            throw new IllegalStateException();
        }
        return var0;
    }

    public int getGroundLevelDelta() {
        return 1;
    }

    public static Function<StructureTemplatePool.Projection, EmptyPoolElement> empty() {
        return var0 -> EmptyPoolElement.INSTANCE;
    }

    public static Function<StructureTemplatePool.Projection, LegacySinglePoolElement> legacy(String var0) {
        return var1 -> new LegacySinglePoolElement((Either<Identifier, StructureTemplate>)Either.left((Object)Identifier.parse(var0)), EMPTY, (StructureTemplatePool.Projection)var1, Optional.empty());
    }

    public static Function<StructureTemplatePool.Projection, LegacySinglePoolElement> legacy(String var0, Holder<StructureProcessorList> var1) {
        return var2 -> new LegacySinglePoolElement((Either<Identifier, StructureTemplate>)Either.left((Object)Identifier.parse(var0)), var1, (StructureTemplatePool.Projection)var2, Optional.empty());
    }

    public static Function<StructureTemplatePool.Projection, SinglePoolElement> single(String var0) {
        return var1 -> new SinglePoolElement((Either<Identifier, StructureTemplate>)Either.left((Object)Identifier.parse(var0)), EMPTY, (StructureTemplatePool.Projection)var1, Optional.empty());
    }

    public static Function<StructureTemplatePool.Projection, SinglePoolElement> single(String var0, Holder<StructureProcessorList> var1) {
        return var2 -> new SinglePoolElement((Either<Identifier, StructureTemplate>)Either.left((Object)Identifier.parse(var0)), var1, (StructureTemplatePool.Projection)var2, Optional.empty());
    }

    public static Function<StructureTemplatePool.Projection, SinglePoolElement> single(String var0, LiquidSettings var1) {
        return var2 -> new SinglePoolElement((Either<Identifier, StructureTemplate>)Either.left((Object)Identifier.parse(var0)), EMPTY, (StructureTemplatePool.Projection)var2, Optional.of(var1));
    }

    public static Function<StructureTemplatePool.Projection, SinglePoolElement> single(String var0, Holder<StructureProcessorList> var1, LiquidSettings var2) {
        return var3 -> new SinglePoolElement((Either<Identifier, StructureTemplate>)Either.left((Object)Identifier.parse(var0)), var1, (StructureTemplatePool.Projection)var3, Optional.of(var2));
    }

    public static Function<StructureTemplatePool.Projection, FeaturePoolElement> feature(Holder<PlacedFeature> var0) {
        return var1 -> new FeaturePoolElement(var0, (StructureTemplatePool.Projection)var1);
    }

    public static Function<StructureTemplatePool.Projection, ListPoolElement> list(List<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>> var0) {
        return var12 -> new ListPoolElement(var0.stream().map(var1 -> (StructurePoolElement)var1.apply(var12)).collect(Collectors.toList()), (StructureTemplatePool.Projection)var12);
    }
}

