/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class BuriedTreasurePieces {

    public static class BuriedTreasurePiece
    extends StructurePiece {
        public BuriedTreasurePiece(BlockPos var0) {
            super(StructurePieceType.BURIED_TREASURE_PIECE, 0, new BoundingBox(var0));
        }

        public BuriedTreasurePiece(CompoundTag var0) {
            super(StructurePieceType.BURIED_TREASURE_PIECE, var0);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, CompoundTag var1) {
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            int var7 = var0.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, this.boundingBox.minX(), this.boundingBox.minZ());
            BlockPos.MutableBlockPos var8 = new BlockPos.MutableBlockPos(this.boundingBox.minX(), var7, this.boundingBox.minZ());
            while (var8.getY() > var0.getMinY()) {
                BlockState var9 = var0.getBlockState(var8);
                BlockState var10 = var0.getBlockState((BlockPos)var8.below());
                if (var10 == Blocks.SANDSTONE.defaultBlockState() || var10 == Blocks.STONE.defaultBlockState() || var10 == Blocks.ANDESITE.defaultBlockState() || var10 == Blocks.GRANITE.defaultBlockState() || var10 == Blocks.DIORITE.defaultBlockState()) {
                    BlockState var11 = var9.isAir() || this.isLiquid(var9) ? Blocks.SAND.defaultBlockState() : var9;
                    for (Direction var15 : Direction.values()) {
                        Vec3i var16 = var8.relative(var15);
                        BlockState var17 = var0.getBlockState((BlockPos)var16);
                        if (!var17.isAir() && !this.isLiquid(var17)) continue;
                        BlockPos var18 = ((BlockPos)var16).below();
                        BlockState var19 = var0.getBlockState(var18);
                        if ((var19.isAir() || this.isLiquid(var19)) && var15 != Direction.UP) {
                            var0.setBlock((BlockPos)var16, var10, 3);
                            continue;
                        }
                        var0.setBlock((BlockPos)var16, var11, 3);
                    }
                    this.boundingBox = new BoundingBox(var8);
                    this.createChest(var0, var4, var3, var8, BuiltInLootTables.BURIED_TREASURE, null);
                    return;
                }
                var8.move(0, -1, 0);
            }
        }

        private boolean isLiquid(BlockState var0) {
            return var0 == Blocks.WATER.defaultBlockState() || var0 == Blocks.LAVA.defaultBlockState();
        }
    }
}

