/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.Util;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.bukkit.craftbukkit.v1_21_R7.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_21_R7.util.TransformerGeneratorAccess;

public class DesertPyramidStructure
extends SinglePieceStructure {
    public static final MapCodec<DesertPyramidStructure> CODEC = DesertPyramidStructure.simpleCodec(DesertPyramidStructure::new);

    public DesertPyramidStructure(Structure.StructureSettings structure_c) {
        super(DesertPyramidPiece::new, 21, 21, structure_c);
    }

    @Override
    public void afterPlace(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, PiecesContainer piecescontainer) {
        SortedArraySet set = SortedArraySet.create(Vec3i::compareTo);
        for (StructurePiece structurepiece : piecescontainer.pieces()) {
            if (!(structurepiece instanceof DesertPyramidPiece)) continue;
            DesertPyramidPiece desertpyramidpiece = (DesertPyramidPiece)structurepiece;
            set.addAll(desertpyramidpiece.getPotentialSuspiciousSandWorldPositions());
            DesertPyramidStructure.placeSuspiciousSand(structureboundingbox, generatoraccessseed, desertpyramidpiece.getRandomCollapsedRoofPos());
        }
        ObjectArrayList objectarraylist = new ObjectArrayList(set.stream().toList());
        RandomSource randomsource1 = RandomSource.create(generatoraccessseed.getSeed()).forkPositional().at(piecescontainer.calculateBoundingBox().getCenter());
        Util.shuffle(objectarraylist, randomsource1);
        int i = Math.min(set.size(), randomsource1.nextInt(5, 8));
        for (BlockPos blockposition : objectarraylist) {
            if (i > 0) {
                --i;
                DesertPyramidStructure.placeSuspiciousSand(structureboundingbox, generatoraccessseed, blockposition);
                continue;
            }
            if (!structureboundingbox.isInside(blockposition)) continue;
            generatoraccessseed.setBlock(blockposition, Blocks.SAND.defaultBlockState(), 2);
        }
    }

    private static void placeSuspiciousSand(BoundingBox structureboundingbox, WorldGenLevel generatoraccessseed, BlockPos blockposition) {
        if (structureboundingbox.isInside(blockposition)) {
            if (generatoraccessseed instanceof TransformerGeneratorAccess) {
                TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)generatoraccessseed;
                CraftBrushableBlock brushableState = (CraftBrushableBlock)CraftBlockStates.getBlockState((LevelReader)generatoraccessseed, blockposition, Blocks.SUSPICIOUS_SAND.defaultBlockState(), null);
                brushableState.setLootTable(CraftLootTable.minecraftToBukkit(BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY));
                brushableState.setSeed(blockposition.asLong());
                transformerAccess.setCraftBlock(blockposition, brushableState, 2);
                return;
            }
            generatoraccessseed.setBlock(blockposition, Blocks.SUSPICIOUS_SAND.defaultBlockState(), 2);
            generatoraccessseed.getBlockEntity(blockposition, BlockEntityType.BRUSHABLE_BLOCK).ifPresent(brushableblockentity -> brushableblockentity.setLootTable(BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY, blockposition.asLong()));
        }
    }

    @Override
    public StructureType<?> type() {
        return StructureType.DESERT_PYRAMID;
    }
}

