/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces;

public class MineshaftStructure
extends Structure {
    public static final MapCodec<MineshaftStructure> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group(MineshaftStructure.settingsCodec(var02), (App)Type.CODEC.fieldOf("mineshaft_type").forGetter(var0 -> var0.type)).apply((Applicative)var02, MineshaftStructure::new));
    private final Type type;

    public MineshaftStructure(Structure.StructureSettings var0, Type var1) {
        super(var0);
        this.type = var1;
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        var0.random().nextDouble();
        ChunkPos var1 = var0.chunkPos();
        BlockPos var2 = new BlockPos(var1.getMiddleBlockX(), 50, var1.getMinBlockZ());
        StructurePiecesBuilder var3 = new StructurePiecesBuilder();
        int var4 = this.generatePiecesAndAdjust(var3, var0);
        return Optional.of(new Structure.GenerationStub(var2.offset(0, var4, 0), (Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder>)Either.right((Object)var3)));
    }

    private int generatePiecesAndAdjust(StructurePiecesBuilder var0, Structure.GenerationContext var1) {
        ChunkPos var2 = var1.chunkPos();
        WorldgenRandom var3 = var1.random();
        ChunkGenerator var4 = var1.chunkGenerator();
        MineshaftPieces.MineShaftRoom var5 = new MineshaftPieces.MineShaftRoom(0, var3, var2.getBlockX(2), var2.getBlockZ(2), this.type);
        var0.addPiece(var5);
        var5.addChildren(var5, var0, var3);
        int var6 = var4.getSeaLevel();
        if (this.type == Type.MESA) {
            BlockPos var7 = var0.getBoundingBox().getCenter();
            int var8 = var4.getBaseHeight(var7.getX(), var7.getZ(), Heightmap.Types.WORLD_SURFACE_WG, var1.heightAccessor(), var1.randomState());
            int var9 = var8 <= var6 ? var6 : Mth.randomBetweenInclusive(var3, var6, var8);
            int var10 = var9 - var7.getY();
            var0.offsetPiecesVertically(var10);
            return var10;
        }
        return var0.moveBelowSeaLevel(var6, var4.getMinY(), var3, 10);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.MINESHAFT;
    }

    public static enum Type implements StringRepresentable
    {
        NORMAL("normal", Blocks.OAK_LOG, Blocks.OAK_PLANKS, Blocks.OAK_FENCE),
        MESA("mesa", Blocks.DARK_OAK_LOG, Blocks.DARK_OAK_PLANKS, Blocks.DARK_OAK_FENCE);

        public static final Codec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final String name;
        private final BlockState woodState;
        private final BlockState planksState;
        private final BlockState fenceState;

        private Type(String var2, Block var3, Block var4, Block var5) {
            this.name = var2;
            this.woodState = var3.defaultBlockState();
            this.planksState = var4.defaultBlockState();
            this.fenceState = var5.defaultBlockState();
        }

        public String getName() {
            return this.name;
        }

        public static Type byId(int var0) {
            return BY_ID.apply(var0);
        }

        public BlockState getWoodState() {
            return this.woodState;
        }

        public BlockState getPlanksState() {
            return this.planksState;
        }

        public BlockState getFenceState() {
            return this.fenceState;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, Type.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

