/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentPieces;

public class OceanMonumentStructure
extends Structure {
    public static final MapCodec<OceanMonumentStructure> CODEC = OceanMonumentStructure.simpleCodec(OceanMonumentStructure::new);

    public OceanMonumentStructure(Structure.StructureSettings var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        int var12 = var0.chunkPos().getBlockX(9);
        int var2 = var0.chunkPos().getBlockZ(9);
        Set<Holder<Biome>> var3 = var0.biomeSource().getBiomesWithin(var12, var0.chunkGenerator().getSeaLevel(), var2, 29, var0.randomState().sampler());
        for (Holder<Biome> var5 : var3) {
            if (var5.is(BiomeTags.REQUIRED_OCEAN_MONUMENT_SURROUNDING)) continue;
            return Optional.empty();
        }
        return OceanMonumentStructure.onTopOfChunkCenter(var0, Heightmap.Types.OCEAN_FLOOR_WG, var1 -> OceanMonumentStructure.generatePieces(var1, var0));
    }

    private static StructurePiece createTopPiece(ChunkPos var0, WorldgenRandom var1) {
        int var2 = var0.getMinBlockX() - 29;
        int var3 = var0.getMinBlockZ() - 29;
        Direction var4 = Direction.Plane.HORIZONTAL.getRandomDirection(var1);
        return new OceanMonumentPieces.MonumentBuilding(var1, var2, var3, var4);
    }

    private static void generatePieces(StructurePiecesBuilder var0, Structure.GenerationContext var1) {
        var0.addPiece(OceanMonumentStructure.createTopPiece(var1.chunkPos(), var1.random()));
    }

    public static PiecesContainer regeneratePiecesAfterLoad(ChunkPos var0, long var1, PiecesContainer var3) {
        if (var3.isEmpty()) {
            return var3;
        }
        WorldgenRandom var4 = new WorldgenRandom(new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
        var4.setLargeFeatureSeed(var1, var0.x, var0.z);
        StructurePiece var5 = var3.pieces().get(0);
        BoundingBox var6 = var5.getBoundingBox();
        int var7 = var6.minX();
        int var8 = var6.minZ();
        Direction var9 = Direction.Plane.HORIZONTAL.getRandomDirection(var4);
        Direction var10 = Objects.requireNonNullElse(var5.getOrientation(), var9);
        OceanMonumentPieces.MonumentBuilding var11 = new OceanMonumentPieces.MonumentBuilding(var4, var7, var8, var10);
        StructurePiecesBuilder var12 = new StructurePiecesBuilder();
        var12.addPiece(var11);
        return var12.build();
    }

    @Override
    public StructureType<?> type() {
        return StructureType.OCEAN_MONUMENT;
    }
}

