/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.zombie.Drowned;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import org.bukkit.craftbukkit.v1_21_R7.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftChest;

public class OceanRuinPieces {
    static final StructureProcessor WARM_SUSPICIOUS_BLOCK_PROCESSOR = OceanRuinPieces.archyRuleProcessor(Blocks.SAND, Blocks.SUSPICIOUS_SAND, BuiltInLootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY);
    static final StructureProcessor COLD_SUSPICIOUS_BLOCK_PROCESSOR = OceanRuinPieces.archyRuleProcessor(Blocks.GRAVEL, Blocks.SUSPICIOUS_GRAVEL, BuiltInLootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY);
    private static final Identifier[] WARM_RUINS = new Identifier[]{Identifier.withDefaultNamespace("underwater_ruin/warm_1"), Identifier.withDefaultNamespace("underwater_ruin/warm_2"), Identifier.withDefaultNamespace("underwater_ruin/warm_3"), Identifier.withDefaultNamespace("underwater_ruin/warm_4"), Identifier.withDefaultNamespace("underwater_ruin/warm_5"), Identifier.withDefaultNamespace("underwater_ruin/warm_6"), Identifier.withDefaultNamespace("underwater_ruin/warm_7"), Identifier.withDefaultNamespace("underwater_ruin/warm_8")};
    private static final Identifier[] RUINS_BRICK = new Identifier[]{Identifier.withDefaultNamespace("underwater_ruin/brick_1"), Identifier.withDefaultNamespace("underwater_ruin/brick_2"), Identifier.withDefaultNamespace("underwater_ruin/brick_3"), Identifier.withDefaultNamespace("underwater_ruin/brick_4"), Identifier.withDefaultNamespace("underwater_ruin/brick_5"), Identifier.withDefaultNamespace("underwater_ruin/brick_6"), Identifier.withDefaultNamespace("underwater_ruin/brick_7"), Identifier.withDefaultNamespace("underwater_ruin/brick_8")};
    private static final Identifier[] RUINS_CRACKED = new Identifier[]{Identifier.withDefaultNamespace("underwater_ruin/cracked_1"), Identifier.withDefaultNamespace("underwater_ruin/cracked_2"), Identifier.withDefaultNamespace("underwater_ruin/cracked_3"), Identifier.withDefaultNamespace("underwater_ruin/cracked_4"), Identifier.withDefaultNamespace("underwater_ruin/cracked_5"), Identifier.withDefaultNamespace("underwater_ruin/cracked_6"), Identifier.withDefaultNamespace("underwater_ruin/cracked_7"), Identifier.withDefaultNamespace("underwater_ruin/cracked_8")};
    private static final Identifier[] RUINS_MOSSY = new Identifier[]{Identifier.withDefaultNamespace("underwater_ruin/mossy_1"), Identifier.withDefaultNamespace("underwater_ruin/mossy_2"), Identifier.withDefaultNamespace("underwater_ruin/mossy_3"), Identifier.withDefaultNamespace("underwater_ruin/mossy_4"), Identifier.withDefaultNamespace("underwater_ruin/mossy_5"), Identifier.withDefaultNamespace("underwater_ruin/mossy_6"), Identifier.withDefaultNamespace("underwater_ruin/mossy_7"), Identifier.withDefaultNamespace("underwater_ruin/mossy_8")};
    private static final Identifier[] BIG_RUINS_BRICK = new Identifier[]{Identifier.withDefaultNamespace("underwater_ruin/big_brick_1"), Identifier.withDefaultNamespace("underwater_ruin/big_brick_2"), Identifier.withDefaultNamespace("underwater_ruin/big_brick_3"), Identifier.withDefaultNamespace("underwater_ruin/big_brick_8")};
    private static final Identifier[] BIG_RUINS_MOSSY = new Identifier[]{Identifier.withDefaultNamespace("underwater_ruin/big_mossy_1"), Identifier.withDefaultNamespace("underwater_ruin/big_mossy_2"), Identifier.withDefaultNamespace("underwater_ruin/big_mossy_3"), Identifier.withDefaultNamespace("underwater_ruin/big_mossy_8")};
    private static final Identifier[] BIG_RUINS_CRACKED = new Identifier[]{Identifier.withDefaultNamespace("underwater_ruin/big_cracked_1"), Identifier.withDefaultNamespace("underwater_ruin/big_cracked_2"), Identifier.withDefaultNamespace("underwater_ruin/big_cracked_3"), Identifier.withDefaultNamespace("underwater_ruin/big_cracked_8")};
    private static final Identifier[] BIG_WARM_RUINS = new Identifier[]{Identifier.withDefaultNamespace("underwater_ruin/big_warm_4"), Identifier.withDefaultNamespace("underwater_ruin/big_warm_5"), Identifier.withDefaultNamespace("underwater_ruin/big_warm_6"), Identifier.withDefaultNamespace("underwater_ruin/big_warm_7")};

    private static StructureProcessor archyRuleProcessor(Block block, Block block1, ResourceKey<LootTable> resourcekey) {
        return new CappedProcessor(new RuleProcessor(List.of(new ProcessorRule(new BlockMatchTest(block), AlwaysTrueTest.INSTANCE, PosAlwaysTrueTest.INSTANCE, block1.defaultBlockState(), new AppendLoot(resourcekey)))), ConstantInt.of(5));
    }

    private static Identifier getSmallWarmRuin(RandomSource randomsource) {
        return Util.getRandom(WARM_RUINS, randomsource);
    }

    private static Identifier getBigWarmRuin(RandomSource randomsource) {
        return Util.getRandom(BIG_WARM_RUINS, randomsource);
    }

    public static void addPieces(StructureTemplateManager structuretemplatemanager, BlockPos blockposition, Rotation enumblockrotation, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, OceanRuinStructure oceanruinstructure) {
        boolean flag = randomsource.nextFloat() <= oceanruinstructure.largeProbability;
        float f = flag ? 0.9f : 0.8f;
        OceanRuinPieces.addPiece(structuretemplatemanager, blockposition, enumblockrotation, structurepieceaccessor, randomsource, oceanruinstructure, flag, f);
        if (flag && randomsource.nextFloat() <= oceanruinstructure.clusterProbability) {
            OceanRuinPieces.addClusterRuins(structuretemplatemanager, randomsource, enumblockrotation, blockposition, oceanruinstructure, structurepieceaccessor);
        }
    }

    private static void addClusterRuins(StructureTemplateManager structuretemplatemanager, RandomSource randomsource, Rotation enumblockrotation, BlockPos blockposition, OceanRuinStructure oceanruinstructure, StructurePieceAccessor structurepieceaccessor) {
        BlockPos blockposition1 = new BlockPos(blockposition.getX(), 90, blockposition.getZ());
        BlockPos blockposition2 = StructureTemplate.transform(new BlockPos(15, 0, 15), Mirror.NONE, enumblockrotation, BlockPos.ZERO).offset(blockposition1);
        BoundingBox structureboundingbox = BoundingBox.fromCorners(blockposition1, blockposition2);
        BlockPos blockposition3 = new BlockPos(Math.min(blockposition1.getX(), blockposition2.getX()), blockposition1.getY(), Math.min(blockposition1.getZ(), blockposition2.getZ()));
        List<BlockPos> list = OceanRuinPieces.allPositions(randomsource, blockposition3);
        int i = Mth.nextInt(randomsource, 4, 8);
        for (int j = 0; j < i; ++j) {
            Rotation enumblockrotation1;
            BlockPos blockposition5;
            int k;
            BlockPos blockposition4;
            BoundingBox structureboundingbox1;
            if (list.isEmpty() || (structureboundingbox1 = BoundingBox.fromCorners(blockposition4 = list.remove(k = randomsource.nextInt(list.size())), blockposition5 = StructureTemplate.transform(new BlockPos(5, 0, 6), Mirror.NONE, enumblockrotation1 = Rotation.getRandom(randomsource), BlockPos.ZERO).offset(blockposition4))).intersects(structureboundingbox)) continue;
            OceanRuinPieces.addPiece(structuretemplatemanager, blockposition4, enumblockrotation1, structurepieceaccessor, randomsource, oceanruinstructure, false, 0.8f);
        }
    }

    private static List<BlockPos> allPositions(RandomSource randomsource, BlockPos blockposition) {
        ArrayList list = Lists.newArrayList();
        list.add(blockposition.offset(-16 + Mth.nextInt(randomsource, 1, 8), 0, 16 + Mth.nextInt(randomsource, 1, 7)));
        list.add(blockposition.offset(-16 + Mth.nextInt(randomsource, 1, 8), 0, Mth.nextInt(randomsource, 1, 7)));
        list.add(blockposition.offset(-16 + Mth.nextInt(randomsource, 1, 8), 0, -16 + Mth.nextInt(randomsource, 4, 8)));
        list.add(blockposition.offset(Mth.nextInt(randomsource, 1, 7), 0, 16 + Mth.nextInt(randomsource, 1, 7)));
        list.add(blockposition.offset(Mth.nextInt(randomsource, 1, 7), 0, -16 + Mth.nextInt(randomsource, 4, 6)));
        list.add(blockposition.offset(16 + Mth.nextInt(randomsource, 1, 7), 0, 16 + Mth.nextInt(randomsource, 3, 8)));
        list.add(blockposition.offset(16 + Mth.nextInt(randomsource, 1, 7), 0, Mth.nextInt(randomsource, 1, 7)));
        list.add(blockposition.offset(16 + Mth.nextInt(randomsource, 1, 7), 0, -16 + Mth.nextInt(randomsource, 4, 8)));
        return list;
    }

    private static void addPiece(StructureTemplateManager structuretemplatemanager, BlockPos blockposition, Rotation enumblockrotation, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, OceanRuinStructure oceanruinstructure, boolean flag, float f) {
        switch (oceanruinstructure.biomeTemp) {
            default: {
                Identifier minecraftkey = flag ? OceanRuinPieces.getBigWarmRuin(randomsource) : OceanRuinPieces.getSmallWarmRuin(randomsource);
                structurepieceaccessor.addPiece(new OceanRuinPiece(structuretemplatemanager, minecraftkey, blockposition, enumblockrotation, f, oceanruinstructure.biomeTemp, flag));
                break;
            }
            case COLD: {
                Identifier[] aminecraftkey = flag ? BIG_RUINS_BRICK : RUINS_BRICK;
                Identifier[] aminecraftkey1 = flag ? BIG_RUINS_CRACKED : RUINS_CRACKED;
                Identifier[] aminecraftkey2 = flag ? BIG_RUINS_MOSSY : RUINS_MOSSY;
                int i = randomsource.nextInt(aminecraftkey.length);
                structurepieceaccessor.addPiece(new OceanRuinPiece(structuretemplatemanager, aminecraftkey[i], blockposition, enumblockrotation, f, oceanruinstructure.biomeTemp, flag));
                structurepieceaccessor.addPiece(new OceanRuinPiece(structuretemplatemanager, aminecraftkey1[i], blockposition, enumblockrotation, 0.7f, oceanruinstructure.biomeTemp, flag));
                structurepieceaccessor.addPiece(new OceanRuinPiece(structuretemplatemanager, aminecraftkey2[i], blockposition, enumblockrotation, 0.5f, oceanruinstructure.biomeTemp, flag));
            }
        }
    }

    public static class OceanRuinPiece
    extends TemplateStructurePiece {
        private final OceanRuinStructure.Type biomeType;
        private final float integrity;
        private final boolean isLarge;

        public OceanRuinPiece(StructureTemplateManager structuretemplatemanager, Identifier minecraftkey, BlockPos blockposition, Rotation enumblockrotation, float f, OceanRuinStructure.Type oceanruinstructure_a, boolean flag) {
            super(StructurePieceType.OCEAN_RUIN, 0, structuretemplatemanager, minecraftkey, minecraftkey.toString(), OceanRuinPiece.makeSettings(enumblockrotation, f, oceanruinstructure_a), blockposition);
            this.integrity = f;
            this.biomeType = oceanruinstructure_a;
            this.isLarge = flag;
        }

        private OceanRuinPiece(StructureTemplateManager structuretemplatemanager, CompoundTag nbttagcompound, Rotation enumblockrotation, float f, OceanRuinStructure.Type oceanruinstructure_a, boolean flag) {
            super(StructurePieceType.OCEAN_RUIN, nbttagcompound, structuretemplatemanager, minecraftkey -> OceanRuinPiece.makeSettings(enumblockrotation, f, oceanruinstructure_a));
            this.integrity = f;
            this.biomeType = oceanruinstructure_a;
            this.isLarge = flag;
        }

        private static StructurePlaceSettings makeSettings(Rotation enumblockrotation, float f, OceanRuinStructure.Type oceanruinstructure_a) {
            StructureProcessor definedstructureprocessor = oceanruinstructure_a == OceanRuinStructure.Type.COLD ? COLD_SUSPICIOUS_BLOCK_PROCESSOR : WARM_SUSPICIOUS_BLOCK_PROCESSOR;
            return new StructurePlaceSettings().setRotation(enumblockrotation).setMirror(Mirror.NONE).addProcessor(new BlockRotProcessor(f)).addProcessor(BlockIgnoreProcessor.STRUCTURE_AND_AIR).addProcessor(definedstructureprocessor);
        }

        public static OceanRuinPiece create(StructureTemplateManager structuretemplatemanager, CompoundTag nbttagcompound) {
            Rotation enumblockrotation = nbttagcompound.read("Rot", Rotation.LEGACY_CODEC).orElseThrow();
            float f = nbttagcompound.getFloatOr("Integrity", 0.0f);
            OceanRuinStructure.Type oceanruinstructure_a = nbttagcompound.read("BiomeType", OceanRuinStructure.Type.LEGACY_CODEC).orElseThrow();
            boolean flag = nbttagcompound.getBooleanOr("IsLarge", false);
            return new OceanRuinPiece(structuretemplatemanager, nbttagcompound, enumblockrotation, f, oceanruinstructure_a, flag);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.store("Rot", Rotation.LEGACY_CODEC, this.placeSettings.getRotation());
            nbttagcompound.putFloat("Integrity", this.integrity);
            nbttagcompound.store("BiomeType", OceanRuinStructure.Type.LEGACY_CODEC, this.biomeType);
            nbttagcompound.putBoolean("IsLarge", this.isLarge);
        }

        @Override
        protected void handleDataMarker(String s, BlockPos blockposition, ServerLevelAccessor worldaccess, RandomSource randomsource, BoundingBox structureboundingbox) {
            Drowned entitydrowned;
            if ("chest".equals(s)) {
                CraftChest craftChest = (CraftChest)CraftBlockStates.getBlockState((LevelReader)worldaccess, blockposition, (BlockState)Blocks.CHEST.defaultBlockState().setValue(ChestBlock.WATERLOGGED, worldaccess.getFluidState(blockposition).is(FluidTags.WATER)), null);
                craftChest.setSeed(randomsource.nextLong());
                craftChest.setLootTable(CraftLootTable.minecraftToBukkit(this.isLarge ? BuiltInLootTables.UNDERWATER_RUIN_BIG : BuiltInLootTables.UNDERWATER_RUIN_SMALL));
                this.placeCraftBlockEntity(worldaccess, blockposition, craftChest, 2);
            } else if ("drowned".equals(s) && (entitydrowned = EntityType.DROWNED.create(worldaccess.getLevel(), EntitySpawnReason.STRUCTURE)) != null) {
                entitydrowned.setPersistenceRequired();
                entitydrowned.snapTo(blockposition, 0.0f, 0.0f);
                entitydrowned.finalizeSpawn(worldaccess, worldaccess.getCurrentDifficultyAt(blockposition), EntitySpawnReason.STRUCTURE, null);
                worldaccess.addFreshEntityWithPassengers(entitydrowned);
                if (blockposition.getY() > worldaccess.getSeaLevel()) {
                    worldaccess.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 2);
                } else {
                    worldaccess.setBlock(blockposition, Blocks.WATER.defaultBlockState(), 2);
                }
            }
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            int i = generatoraccessseed.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, this.templatePosition.getX(), this.templatePosition.getZ());
            this.templatePosition = new BlockPos(this.templatePosition.getX(), i, this.templatePosition.getZ());
            BlockPos blockposition1 = StructureTemplate.transform(new BlockPos(this.template.getSize().getX() - 1, 0, this.template.getSize().getZ() - 1), Mirror.NONE, this.placeSettings.getRotation(), BlockPos.ZERO).offset(this.templatePosition);
            this.templatePosition = new BlockPos(this.templatePosition.getX(), this.getHeight(this.templatePosition, generatoraccessseed, blockposition1), this.templatePosition.getZ());
            super.postProcess(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition);
        }

        private int getHeight(BlockPos blockposition, BlockGetter iblockaccess, BlockPos blockposition1) {
            int i = blockposition.getY();
            int j = 512;
            int k = i - 1;
            int l = 0;
            for (BlockPos blockposition2 : BlockPos.betweenClosed(blockposition, blockposition1)) {
                int i1 = blockposition2.getX();
                int j1 = blockposition2.getZ();
                int k1 = blockposition.getY() - 1;
                BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos(i1, k1, j1);
                BlockState iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
                FluidState fluid = iblockaccess.getFluidState(blockposition_mutableblockposition);
                while ((iblockdata.isAir() || fluid.is(FluidTags.WATER) || iblockdata.is(BlockTags.ICE)) && k1 > iblockaccess.getMinY() + 1) {
                    blockposition_mutableblockposition.set(i1, --k1, j1);
                    iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
                    fluid = iblockaccess.getFluidState(blockposition_mutableblockposition);
                }
                j = Math.min(j, k1);
                if (k1 >= k - 2) continue;
                ++l;
            }
            int l1 = Math.abs(blockposition.getX() - blockposition1.getX());
            if (k - j > 2 && l > l1 - 2) {
                i = j + 1;
            }
            return i;
        }
    }
}

