/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class ShipwreckPieces {
    private static final int NUMBER_OF_BLOCKS_ALLOWED_IN_WORLD_GEN_REGION = 32;
    static final BlockPos PIVOT = new BlockPos(4, 0, 15);
    private static final Identifier[] STRUCTURE_LOCATION_BEACHED = new Identifier[]{Identifier.withDefaultNamespace("shipwreck/with_mast"), Identifier.withDefaultNamespace("shipwreck/sideways_full"), Identifier.withDefaultNamespace("shipwreck/sideways_fronthalf"), Identifier.withDefaultNamespace("shipwreck/sideways_backhalf"), Identifier.withDefaultNamespace("shipwreck/rightsideup_full"), Identifier.withDefaultNamespace("shipwreck/rightsideup_fronthalf"), Identifier.withDefaultNamespace("shipwreck/rightsideup_backhalf"), Identifier.withDefaultNamespace("shipwreck/with_mast_degraded"), Identifier.withDefaultNamespace("shipwreck/rightsideup_full_degraded"), Identifier.withDefaultNamespace("shipwreck/rightsideup_fronthalf_degraded"), Identifier.withDefaultNamespace("shipwreck/rightsideup_backhalf_degraded")};
    private static final Identifier[] STRUCTURE_LOCATION_OCEAN = new Identifier[]{Identifier.withDefaultNamespace("shipwreck/with_mast"), Identifier.withDefaultNamespace("shipwreck/upsidedown_full"), Identifier.withDefaultNamespace("shipwreck/upsidedown_fronthalf"), Identifier.withDefaultNamespace("shipwreck/upsidedown_backhalf"), Identifier.withDefaultNamespace("shipwreck/sideways_full"), Identifier.withDefaultNamespace("shipwreck/sideways_fronthalf"), Identifier.withDefaultNamespace("shipwreck/sideways_backhalf"), Identifier.withDefaultNamespace("shipwreck/rightsideup_full"), Identifier.withDefaultNamespace("shipwreck/rightsideup_fronthalf"), Identifier.withDefaultNamespace("shipwreck/rightsideup_backhalf"), Identifier.withDefaultNamespace("shipwreck/with_mast_degraded"), Identifier.withDefaultNamespace("shipwreck/upsidedown_full_degraded"), Identifier.withDefaultNamespace("shipwreck/upsidedown_fronthalf_degraded"), Identifier.withDefaultNamespace("shipwreck/upsidedown_backhalf_degraded"), Identifier.withDefaultNamespace("shipwreck/sideways_full_degraded"), Identifier.withDefaultNamespace("shipwreck/sideways_fronthalf_degraded"), Identifier.withDefaultNamespace("shipwreck/sideways_backhalf_degraded"), Identifier.withDefaultNamespace("shipwreck/rightsideup_full_degraded"), Identifier.withDefaultNamespace("shipwreck/rightsideup_fronthalf_degraded"), Identifier.withDefaultNamespace("shipwreck/rightsideup_backhalf_degraded")};
    static final Map<String, ResourceKey<LootTable>> MARKERS_TO_LOOT = Map.of("map_chest", BuiltInLootTables.SHIPWRECK_MAP, "treasure_chest", BuiltInLootTables.SHIPWRECK_TREASURE, "supply_chest", BuiltInLootTables.SHIPWRECK_SUPPLY);

    public static ShipwreckPiece addRandomPiece(StructureTemplateManager structuretemplatemanager, BlockPos blockposition, Rotation enumblockrotation, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, boolean flag) {
        Identifier minecraftkey = Util.getRandom(flag ? STRUCTURE_LOCATION_BEACHED : STRUCTURE_LOCATION_OCEAN, randomsource);
        ShipwreckPiece shipwreckpieces_a = new ShipwreckPiece(structuretemplatemanager, minecraftkey, blockposition, enumblockrotation, flag);
        structurepieceaccessor.addPiece(shipwreckpieces_a);
        return shipwreckpieces_a;
    }

    public static class ShipwreckPiece
    extends TemplateStructurePiece {
        private final boolean isBeached;

        public ShipwreckPiece(StructureTemplateManager structuretemplatemanager, Identifier minecraftkey, BlockPos blockposition, Rotation enumblockrotation, boolean flag) {
            super(StructurePieceType.SHIPWRECK_PIECE, 0, structuretemplatemanager, minecraftkey, minecraftkey.toString(), ShipwreckPiece.makeSettings(enumblockrotation), blockposition);
            this.isBeached = flag;
        }

        public ShipwreckPiece(StructureTemplateManager structuretemplatemanager, CompoundTag nbttagcompound) {
            super(StructurePieceType.SHIPWRECK_PIECE, nbttagcompound, structuretemplatemanager, minecraftkey -> ShipwreckPiece.makeSettings(nbttagcompound.read("Rot", Rotation.LEGACY_CODEC).orElseThrow()));
            this.isBeached = nbttagcompound.getBooleanOr("isBeached", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("isBeached", this.isBeached);
            nbttagcompound.store("Rot", Rotation.LEGACY_CODEC, this.placeSettings.getRotation());
        }

        private static StructurePlaceSettings makeSettings(Rotation enumblockrotation) {
            return new StructurePlaceSettings().setRotation(enumblockrotation).setMirror(Mirror.NONE).setRotationPivot(PIVOT).addProcessor(BlockIgnoreProcessor.STRUCTURE_AND_AIR);
        }

        @Override
        protected void handleDataMarker(String s, BlockPos blockposition, ServerLevelAccessor worldaccess, RandomSource randomsource, BoundingBox structureboundingbox) {
            ResourceKey<LootTable> resourcekey = MARKERS_TO_LOOT.get(s);
            if (resourcekey != null) {
                this.setCraftLootTable(worldaccess, blockposition.below(), randomsource, resourcekey);
            }
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            if (this.isTooBigToFitInWorldGenRegion()) {
                super.postProcess(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition);
            } else {
                int i = generatoraccessseed.getMaxY() + 1;
                int j = 0;
                Vec3i baseblockposition = this.template.getSize();
                Heightmap.Types heightmap_type = this.isBeached ? Heightmap.Types.WORLD_SURFACE_WG : Heightmap.Types.OCEAN_FLOOR_WG;
                int k = baseblockposition.getX() * baseblockposition.getZ();
                if (k == 0) {
                    j = generatoraccessseed.getHeight(heightmap_type, this.templatePosition.getX(), this.templatePosition.getZ());
                } else {
                    BlockPos blockposition1 = this.templatePosition.offset(baseblockposition.getX() - 1, 0, baseblockposition.getZ() - 1);
                    for (BlockPos blockposition2 : BlockPos.betweenClosed(this.templatePosition, blockposition1)) {
                        int l = generatoraccessseed.getHeight(heightmap_type, blockposition2.getX(), blockposition2.getZ());
                        j += l;
                        i = Math.min(i, l);
                    }
                    j /= k;
                }
                this.adjustPositionHeight(this.isBeached ? this.calculateBeachedPosition(i, randomsource) : j);
                super.postProcess(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition);
            }
        }

        public boolean isTooBigToFitInWorldGenRegion() {
            Vec3i baseblockposition = this.template.getSize();
            return baseblockposition.getX() > 32 || baseblockposition.getY() > 32;
        }

        public int calculateBeachedPosition(int i, RandomSource randomsource) {
            return i - this.template.getSize().getY() / 2 - randomsource.nextInt(3);
        }

        public void adjustPositionHeight(int i) {
            this.templatePosition = new BlockPos(this.templatePosition.getX(), i, this.templatePosition.getZ());
        }
    }
}

