/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.bukkit.entity.EntityType;
import org.jspecify.annotations.Nullable;

public class StrongholdPieces {
    private static final int SMALL_DOOR_WIDTH = 3;
    private static final int SMALL_DOOR_HEIGHT = 3;
    private static final int MAX_DEPTH = 50;
    private static final int LOWEST_Y_POSITION = 10;
    private static final boolean CHECK_AIR = true;
    public static final int MAGIC_START_Y = 64;
    private static final PieceWeight[] STRONGHOLD_PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(PrisonHall.class, 5, 5), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(StraightStairsDown.class, 5, 5), new PieceWeight(StairsDown.class, 5, 5), new PieceWeight(FiveCrossing.class, 5, 4), new PieceWeight(ChestCorridor.class, 5, 4), new PieceWeight(Library.class, 10, 2){

        @Override
        public boolean doPlace(int i) {
            return super.doPlace(i) && i > 4;
        }
    }, new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean doPlace(int i) {
            return super.doPlace(i) && i > 5;
        }
    }};
    private static List<PieceWeight> currentPieces;
    static @Nullable Class<? extends StrongholdPiece> imposedPiece;
    private static int totalWeight;
    static final SmoothStoneSelector SMOOTH_STONE_SELECTOR;

    public static void resetPieces() {
        currentPieces = Lists.newArrayList();
        for (PieceWeight strongholdpieces_f : STRONGHOLD_PIECE_WEIGHTS) {
            strongholdpieces_f.placeCount = 0;
            currentPieces.add(strongholdpieces_f);
        }
        imposedPiece = null;
    }

    private static boolean updatePieceWeight() {
        boolean flag = false;
        totalWeight = 0;
        for (PieceWeight strongholdpieces_f : currentPieces) {
            if (strongholdpieces_f.maxPlaceCount > 0 && strongholdpieces_f.placeCount < strongholdpieces_f.maxPlaceCount) {
                flag = true;
            }
            totalWeight += strongholdpieces_f.weight;
        }
        return flag;
    }

    private static @Nullable StrongholdPiece findAndCreatePieceFactory(Class<? extends StrongholdPiece> oclass, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
        StrongholdPiece strongholdpieces_p = null;
        if (oclass == Straight.class) {
            strongholdpieces_p = Straight.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == PrisonHall.class) {
            strongholdpieces_p = PrisonHall.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == LeftTurn.class) {
            strongholdpieces_p = LeftTurn.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == RightTurn.class) {
            strongholdpieces_p = RightTurn.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == RoomCrossing.class) {
            strongholdpieces_p = RoomCrossing.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == StraightStairsDown.class) {
            strongholdpieces_p = StraightStairsDown.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == StairsDown.class) {
            strongholdpieces_p = StairsDown.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == FiveCrossing.class) {
            strongholdpieces_p = FiveCrossing.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == ChestCorridor.class) {
            strongholdpieces_p = ChestCorridor.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == Library.class) {
            strongholdpieces_p = Library.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == PortalRoom.class) {
            strongholdpieces_p = PortalRoom.createPiece(structurepieceaccessor, i, j, k, enumdirection, l);
        }
        return strongholdpieces_p;
    }

    private static @Nullable StrongholdPiece generatePieceFromSmallDoor(StartPiece strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
        if (!StrongholdPieces.updatePieceWeight()) {
            return null;
        }
        if (imposedPiece != null) {
            StrongholdPiece strongholdpieces_p = StrongholdPieces.findAndCreatePieceFactory(imposedPiece, structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
            imposedPiece = null;
            if (strongholdpieces_p != null) {
                return strongholdpieces_p;
            }
        }
        int i1 = 0;
        block0: while (i1 < 5) {
            ++i1;
            int j1 = randomsource.nextInt(totalWeight);
            for (PieceWeight strongholdpieces_f : currentPieces) {
                if ((j1 -= strongholdpieces_f.weight) >= 0) continue;
                if (!strongholdpieces_f.doPlace(l) || strongholdpieces_f == strongholdpieces_m.previousPiece) continue block0;
                StrongholdPiece strongholdpieces_p1 = StrongholdPieces.findAndCreatePieceFactory(strongholdpieces_f.pieceClass, structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
                if (strongholdpieces_p1 == null) continue;
                ++strongholdpieces_f.placeCount;
                strongholdpieces_m.previousPiece = strongholdpieces_f;
                if (!strongholdpieces_f.isValid()) {
                    currentPieces.remove(strongholdpieces_f);
                }
                return strongholdpieces_p1;
            }
        }
        BoundingBox structureboundingbox = FillerCorridor.findPieceBox(structurepieceaccessor, randomsource, i, j, k, enumdirection);
        if (structureboundingbox != null && structureboundingbox.minY() > 1) {
            return new FillerCorridor(l, structureboundingbox, enumdirection);
        }
        return null;
    }

    static @Nullable StructurePiece generateAndAddPiece(StartPiece strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
        if (l > 50) {
            return null;
        }
        if (Math.abs(i - strongholdpieces_m.getBoundingBox().minX()) <= 112 && Math.abs(k - strongholdpieces_m.getBoundingBox().minZ()) <= 112) {
            StrongholdPiece structurepiece = StrongholdPieces.generatePieceFromSmallDoor(strongholdpieces_m, structurepieceaccessor, randomsource, i, j, k, enumdirection, l + 1);
            if (structurepiece != null) {
                structurepieceaccessor.addPiece(structurepiece);
                strongholdpieces_m.pendingChildren.add(structurepiece);
            }
            return structurepiece;
        }
        return null;
    }

    static {
        SMOOTH_STONE_SELECTOR = new SmoothStoneSelector();
    }

    private static class PieceWeight {
        public final Class<? extends StrongholdPiece> pieceClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;

        public PieceWeight(Class<? extends StrongholdPiece> oclass, int i, int j) {
            this.pieceClass = oclass;
            this.weight = i;
            this.maxPlaceCount = j;
        }

        public boolean doPlace(int i) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    public static class Straight
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private final boolean leftChild;
        private final boolean rightChild;

        public Straight(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
            this.leftChild = randomsource.nextInt(2) == 0;
            this.rightChild = randomsource.nextInt(2) == 0;
        }

        public Straight(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT, nbttagcompound);
            this.leftChild = nbttagcompound.getBooleanOr("Left", false);
            this.rightChild = nbttagcompound.getBooleanOr("Right", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Left", this.leftChild);
            nbttagcompound.putBoolean("Right", this.rightChild);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            if (this.leftChild) {
                this.generateSmallDoorChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 2);
            }
            if (this.rightChild) {
                this.generateSmallDoorChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 2);
            }
        }

        public static @Nullable Straight createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -1, 0, 5, 5, 7, enumdirection);
            return Straight.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new Straight(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 4, 6, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 6);
            BlockState iblockdata = (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.EAST);
            BlockState iblockdata1 = (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.WEST);
            this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 1, 2, 1, iblockdata);
            this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 3, 2, 1, iblockdata1);
            this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 1, 2, 5, iblockdata);
            this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 3, 2, 5, iblockdata1);
            if (this.leftChild) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 2, 0, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightChild) {
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 2, 4, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class PrisonHall
    extends StrongholdPiece {
        protected static final int WIDTH = 9;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 11;

        public PrisonHall(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_PRISON_HALL, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public PrisonHall(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_PRISON_HALL, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 1);
        }

        public static @Nullable PrisonHall createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -1, 0, 9, 5, 11, enumdirection);
            return PrisonHall.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new PrisonHall(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 8, 4, 10, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, 10, 3, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 1, 4, 3, 1, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 3, 4, 3, 3, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 7, 4, 3, 7, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 9, 4, 3, 9, false, randomsource, SMOOTH_STONE_SELECTOR);
            for (int i = 1; i <= 3; ++i) {
                this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, i, 4, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)((BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)).setValue(IronBarsBlock.EAST, true), 4, i, 5, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, i, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true), 5, i, 5, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true), 6, i, 5, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true), 7, i, 5, structureboundingbox);
            }
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, 3, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true), 4, 3, 8, structureboundingbox);
            BlockState iblockdata = (BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue(DoorBlock.FACING, Direction.WEST);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue(DoorBlock.FACING, Direction.WEST)).setValue(DoorBlock.HALF, DoubleBlockHalf.UPPER);
            this.placeBlock(generatoraccessseed, iblockdata, 4, 1, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata1, 4, 2, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata, 4, 1, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata1, 4, 2, 8, structureboundingbox);
        }
    }

    public static class LeftTurn
    extends Turn {
        public LeftTurn(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_LEFT_TURN, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public LeftTurn(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_LEFT_TURN, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            Direction enumdirection = this.getOrientation();
            if (enumdirection != Direction.NORTH && enumdirection != Direction.EAST) {
                this.generateSmallDoorChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            } else {
                this.generateSmallDoorChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            }
        }

        public static @Nullable LeftTurn createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -1, 0, 5, 5, 5, enumdirection);
            return LeftTurn.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new LeftTurn(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 4, 4, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            Direction enumdirection = this.getOrientation();
            if (enumdirection != Direction.NORTH && enumdirection != Direction.EAST) {
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class RightTurn
    extends Turn {
        public RightTurn(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_RIGHT_TURN, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public RightTurn(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_RIGHT_TURN, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            Direction enumdirection = this.getOrientation();
            if (enumdirection != Direction.NORTH && enumdirection != Direction.EAST) {
                this.generateSmallDoorChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            } else {
                this.generateSmallDoorChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            }
        }

        public static @Nullable RightTurn createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -1, 0, 5, 5, 5, enumdirection);
            return RightTurn.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new RightTurn(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 4, 4, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            Direction enumdirection = this.getOrientation();
            if (enumdirection != Direction.NORTH && enumdirection != Direction.EAST) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class RoomCrossing
    extends StrongholdPiece {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 7;
        protected static final int DEPTH = 11;
        protected final int type;

        public RoomCrossing(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_ROOM_CROSSING, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
            this.type = randomsource.nextInt(5);
        }

        public RoomCrossing(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_ROOM_CROSSING, nbttagcompound);
            this.type = nbttagcompound.getIntOr("Type", 0);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putInt("Type", this.type);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 4, 1);
            this.generateSmallDoorChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 4);
            this.generateSmallDoorChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 4);
        }

        public static @Nullable RoomCrossing createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -4, -1, 0, 11, 7, 11, enumdirection);
            return RoomCrossing.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new RoomCrossing(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 10, 6, 10, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 4, 1, 0);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 10, 6, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 4, 0, 3, 6, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 10, 1, 4, 10, 3, 6, CAVE_AIR, CAVE_AIR, false);
            switch (this.type) {
                case 0: {
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.WEST), 4, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.EAST), 6, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.SOUTH), 5, 3, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.NORTH), 5, 3, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 6, structureboundingbox);
                    break;
                }
                case 1: {
                    for (int i = 0; i < 5; ++i) {
                        this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 1, 3 + i, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 7, 1, 3 + i, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3 + i, 1, 3, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3 + i, 1, 7, structureboundingbox);
                    }
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.WATER.defaultBlockState(), 5, 4, 5, structureboundingbox);
                    break;
                }
                case 2: {
                    for (int j = 1; j <= 9; ++j) {
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 1, 3, j, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 9, 3, j, structureboundingbox);
                    }
                    for (int k = 1; k <= 9; ++k) {
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), k, 3, 1, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), k, 3, 9, structureboundingbox);
                    }
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 4, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 6, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 4, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 6, 3, 5, structureboundingbox);
                    for (int l = 1; l <= 3; ++l) {
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 4, l, 4, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 6, l, 4, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 4, l, 6, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 6, l, 6, structureboundingbox);
                    }
                    this.placeBlock(generatoraccessseed, Blocks.WALL_TORCH.defaultBlockState(), 5, 3, 5, structureboundingbox);
                    for (int i1 = 2; i1 <= 8; ++i1) {
                        this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 2, 3, i1, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 3, 3, i1, structureboundingbox);
                        if (i1 <= 3 || i1 >= 7) {
                            this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 4, 3, i1, structureboundingbox);
                            this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 5, 3, i1, structureboundingbox);
                            this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 6, 3, i1, structureboundingbox);
                        }
                        this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 7, 3, i1, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 8, 3, i1, structureboundingbox);
                    }
                    BlockState iblockdata = (BlockState)Blocks.LADDER.defaultBlockState().setValue(LadderBlock.FACING, Direction.WEST);
                    this.placeBlock(generatoraccessseed, iblockdata, 9, 1, 3, structureboundingbox);
                    this.placeBlock(generatoraccessseed, iblockdata, 9, 2, 3, structureboundingbox);
                    this.placeBlock(generatoraccessseed, iblockdata, 9, 3, 3, structureboundingbox);
                    this.createChest(generatoraccessseed, structureboundingbox, randomsource, 3, 4, 8, BuiltInLootTables.STRONGHOLD_CROSSING);
                }
            }
        }
    }

    public static class StraightStairsDown
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 8;

        public StraightStairsDown(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public StraightStairsDown(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 1);
        }

        public static @Nullable StraightStairsDown createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -7, 0, 5, 11, 8, enumdirection);
            return StraightStairsDown.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new StraightStairsDown(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 10, 7, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 7);
            BlockState iblockdata = (BlockState)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.SOUTH);
            for (int i = 0; i < 6; ++i) {
                this.placeBlock(generatoraccessseed, iblockdata, 1, 6 - i, 1 + i, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata, 2, 6 - i, 1 + i, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata, 3, 6 - i, 1 + i, structureboundingbox);
                if (i >= 5) continue;
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5 - i, 1 + i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 5 - i, 1 + i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 5 - i, 1 + i, structureboundingbox);
            }
        }
    }

    public static class StairsDown
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 5;
        private final boolean isSource;

        public StairsDown(StructurePieceType worldgenfeaturestructurepiecetype, int i, int j, int k, Direction enumdirection) {
            super(worldgenfeaturestructurepiecetype, i, StairsDown.makeBoundingBox(j, 64, k, enumdirection, 5, 11, 5));
            this.isSource = true;
            this.setOrientation(enumdirection);
            this.entryDoor = StrongholdPiece.SmallDoorType.OPENING;
        }

        public StairsDown(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_STAIRS_DOWN, i, structureboundingbox);
            this.isSource = false;
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public StairsDown(StructurePieceType worldgenfeaturestructurepiecetype, CompoundTag nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
            this.isSource = nbttagcompound.getBooleanOr("Source", false);
        }

        public StairsDown(CompoundTag nbttagcompound) {
            this(StructurePieceType.STRONGHOLD_STAIRS_DOWN, nbttagcompound);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Source", this.isSource);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            if (this.isSource) {
                imposedPiece = FiveCrossing.class;
            }
            this.generateSmallDoorChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 1);
        }

        public static @Nullable StairsDown createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -7, 0, 5, 11, 5, enumdirection);
            return StairsDown.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new StairsDown(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 10, 4, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 4);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 6, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 6, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 5, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 4, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 2, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 3, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 2, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 2, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 1, 3, structureboundingbox);
        }
    }

    public static class FiveCrossing
    extends StrongholdPiece {
        protected static final int WIDTH = 10;
        protected static final int HEIGHT = 9;
        protected static final int DEPTH = 11;
        private final boolean leftLow;
        private final boolean leftHigh;
        private final boolean rightLow;
        private final boolean rightHigh;

        public FiveCrossing(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_FIVE_CROSSING, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
            this.leftLow = randomsource.nextBoolean();
            this.leftHigh = randomsource.nextBoolean();
            this.rightLow = randomsource.nextBoolean();
            this.rightHigh = randomsource.nextInt(3) > 0;
        }

        public FiveCrossing(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_FIVE_CROSSING, nbttagcompound);
            this.leftLow = nbttagcompound.getBooleanOr("leftLow", false);
            this.leftHigh = nbttagcompound.getBooleanOr("leftHigh", false);
            this.rightLow = nbttagcompound.getBooleanOr("rightLow", false);
            this.rightHigh = nbttagcompound.getBooleanOr("rightHigh", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("leftLow", this.leftLow);
            nbttagcompound.putBoolean("leftHigh", this.leftHigh);
            nbttagcompound.putBoolean("rightLow", this.rightLow);
            nbttagcompound.putBoolean("rightHigh", this.rightHigh);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            int i = 3;
            int j = 5;
            Direction enumdirection = this.getOrientation();
            if (enumdirection == Direction.WEST || enumdirection == Direction.NORTH) {
                i = 8 - i;
                j = 8 - j;
            }
            this.generateSmallDoorChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 5, 1);
            if (this.leftLow) {
                this.generateSmallDoorChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, i, 1);
            }
            if (this.leftHigh) {
                this.generateSmallDoorChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, j, 7);
            }
            if (this.rightLow) {
                this.generateSmallDoorChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, i, 1);
            }
            if (this.rightHigh) {
                this.generateSmallDoorChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, j, 7);
            }
        }

        public static @Nullable FiveCrossing createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -4, -3, 0, 10, 9, 11, enumdirection);
            return FiveCrossing.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new FiveCrossing(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 9, 8, 10, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 1, 0, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightLow) {
                this.generateBox(generatoraccessseed, structureboundingbox, 9, 3, 1, 9, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.leftHigh) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 7, 0, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightHigh) {
                this.generateBox(generatoraccessseed, structureboundingbox, 9, 5, 7, 9, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 1, 10, 7, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 1, 8, 2, 6, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 5, 4, 4, 9, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 1, 5, 8, 4, 9, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 4, 7, 3, 4, 9, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 5, 3, 3, 6, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 4, 3, 3, 4, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 4, 6, 3, 4, 6, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 1, 7, 7, 1, 8, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 1, 9, 7, 1, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 7, 7, 2, 7, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 7, 4, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 7, 8, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 5, 7, 7, 5, 9, (BlockState)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(SlabBlock.TYPE, SlabType.DOUBLE), (BlockState)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(SlabBlock.TYPE, SlabType.DOUBLE), false);
            this.placeBlock(generatoraccessseed, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.SOUTH), 6, 5, 6, structureboundingbox);
        }
    }

    public static class ChestCorridor
    extends StrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private boolean hasPlacedChest;

        public ChestCorridor(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_CHEST_CORRIDOR, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public ChestCorridor(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_CHEST_CORRIDOR, nbttagcompound);
            this.hasPlacedChest = nbttagcompound.getBooleanOr("Chest", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Chest", this.hasPlacedChest);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 1);
        }

        public static @Nullable ChestCorridor createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -1, 0, 5, 5, 7, enumdirection);
            return ChestCorridor.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new ChestCorridor(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 4, 6, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, StrongholdPiece.SmallDoorType.OPENING, 1, 1, 6);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 1, 2, 3, 1, 4, Blocks.STONE_BRICKS.defaultBlockState(), Blocks.STONE_BRICKS.defaultBlockState(), false);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 5, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 4, structureboundingbox);
            for (int i = 2; i <= 4; ++i) {
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 2, 1, i, structureboundingbox);
            }
            if (!this.hasPlacedChest && structureboundingbox.isInside(this.getWorldPos(3, 2, 3))) {
                this.hasPlacedChest = true;
                this.createChest(generatoraccessseed, structureboundingbox, randomsource, 3, 2, 3, BuiltInLootTables.STRONGHOLD_CORRIDOR);
            }
        }
    }

    public static class Library
    extends StrongholdPiece {
        protected static final int WIDTH = 14;
        protected static final int HEIGHT = 6;
        protected static final int TALL_HEIGHT = 11;
        protected static final int DEPTH = 15;
        private final boolean isTall;

        public Library(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_LIBRARY, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
            this.isTall = structureboundingbox.getYSpan() > 6;
        }

        public Library(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_LIBRARY, nbttagcompound);
            this.isTall = nbttagcompound.getBooleanOr("Tall", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Tall", this.isTall);
        }

        public static @Nullable Library createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -4, -1, 0, 14, 11, 15, enumdirection);
            if (!(Library.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null || Library.isOkBox(structureboundingbox = BoundingBox.orientBox(i, j, k, -4, -1, 0, 14, 6, 15, enumdirection)) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null)) {
                return null;
            }
            return new Library(l, randomsource, structureboundingbox, enumdirection);
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            int i = 11;
            if (!this.isTall) {
                i = 6;
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 13, i - 1, 14, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 4, 1, 0);
            this.generateMaybeBox(generatoraccessseed, structureboundingbox, randomsource, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.COBWEB.defaultBlockState(), Blocks.COBWEB.defaultBlockState(), false, false);
            boolean j = true;
            int k = 12;
            for (int l = 1; l <= 13; ++l) {
                if ((l - 1) % 4 == 0) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, l, 1, 4, l, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.generateBox(generatoraccessseed, structureboundingbox, 12, 1, l, 12, 4, l, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.EAST), 2, 3, l, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, Direction.WEST), 11, 3, l, structureboundingbox);
                    if (!this.isTall) continue;
                    this.generateBox(generatoraccessseed, structureboundingbox, 1, 6, l, 1, 9, l, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.generateBox(generatoraccessseed, structureboundingbox, 12, 6, l, 12, 9, l, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    continue;
                }
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, l, 1, 4, l, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 12, 1, l, 12, 4, l, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                if (!this.isTall) continue;
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 6, l, 1, 9, l, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 12, 6, l, 12, 9, l, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
            }
            for (int i1 = 3; i1 < 12; i1 += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, 3, 1, i1, 4, 3, i1, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 6, 1, i1, 7, 3, i1, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 9, 1, i1, 10, 3, i1, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
            }
            if (this.isTall) {
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 5, 1, 3, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 10, 5, 1, 12, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 1, 9, 5, 2, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 12, 9, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 11, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 8, 5, 11, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 10, structureboundingbox);
                BlockState iblockdata = (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
                BlockState iblockdata1 = (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
                this.generateBox(generatoraccessseed, structureboundingbox, 3, 6, 3, 3, 6, 11, iblockdata1, iblockdata1, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 10, 6, 3, 10, 6, 9, iblockdata1, iblockdata1, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 6, 2, 9, 6, 2, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 6, 12, 7, 6, 12, iblockdata, iblockdata, false);
                this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 3, 6, 2, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.EAST, true), 3, 6, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.WEST, true), 10, 6, 2, structureboundingbox);
                for (int j1 = 0; j1 <= 2; ++j1) {
                    this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.WEST, true), 8 + j1, 6, 12 - j1, structureboundingbox);
                    if (j1 == 2) continue;
                    this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 8 + j1, 6, 11 - j1, structureboundingbox);
                }
                BlockState iblockdata2 = (BlockState)Blocks.LADDER.defaultBlockState().setValue(LadderBlock.FACING, Direction.SOUTH);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 1, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 2, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 3, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 4, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 5, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 6, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 7, 13, structureboundingbox);
                int k1 = 7;
                int l1 = 7;
                BlockState iblockdata3 = (BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true);
                this.placeBlock(generatoraccessseed, iblockdata3, 6, 9, 7, structureboundingbox);
                BlockState iblockdata4 = (BlockState)Blocks.OAK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true);
                this.placeBlock(generatoraccessseed, iblockdata4, 7, 9, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata3, 6, 8, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata4, 7, 8, 7, structureboundingbox);
                BlockState iblockdata5 = (BlockState)((BlockState)iblockdata1.setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
                this.placeBlock(generatoraccessseed, iblockdata5, 6, 7, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata5, 7, 7, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata3, 5, 7, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata4, 8, 7, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)iblockdata3.setValue(FenceBlock.NORTH, true), 6, 7, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)iblockdata3.setValue(FenceBlock.SOUTH, true), 6, 7, 8, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)iblockdata4.setValue(FenceBlock.NORTH, true), 7, 7, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, (BlockState)iblockdata4.setValue(FenceBlock.SOUTH, true), 7, 7, 8, structureboundingbox);
                BlockState iblockdata6 = Blocks.TORCH.defaultBlockState();
                this.placeBlock(generatoraccessseed, iblockdata6, 5, 8, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 8, 8, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 6, 8, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 6, 8, 8, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 7, 8, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 7, 8, 8, structureboundingbox);
            }
            this.createChest(generatoraccessseed, structureboundingbox, randomsource, 3, 3, 5, BuiltInLootTables.STRONGHOLD_LIBRARY);
            if (this.isTall) {
                this.placeBlock(generatoraccessseed, CAVE_AIR, 12, 9, 1, structureboundingbox);
                this.createChest(generatoraccessseed, structureboundingbox, randomsource, 12, 8, 1, BuiltInLootTables.STRONGHOLD_LIBRARY);
            }
        }
    }

    public static class PortalRoom
    extends StrongholdPiece {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 8;
        protected static final int DEPTH = 16;
        private boolean hasPlacedSpawner;

        public PortalRoom(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_PORTAL_ROOM, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public PortalRoom(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_PORTAL_ROOM, nbttagcompound);
            this.hasPlacedSpawner = nbttagcompound.getBooleanOr("Mob", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Mob", this.hasPlacedSpawner);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            if (structurepiece != null) {
                ((StartPiece)structurepiece).portalRoomPiece = this;
            }
        }

        public static @Nullable PortalRoom createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -4, -1, 0, 11, 8, 16, enumdirection);
            return PortalRoom.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new PortalRoom(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            BlockPos.MutableBlockPos blockposition1;
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 10, 7, 15, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, StrongholdPiece.SmallDoorType.GRATES, 4, 1, 0);
            int i = 6;
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 6, 1, 1, 6, 14, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 6, 1, 9, 6, 14, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 1, 8, 6, 2, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 14, 8, 6, 14, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, 1, 2, 1, 4, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 1, 1, 9, 1, 4, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, 1, 1, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 1, 1, 9, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 1, 8, 7, 1, 12, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 9, 6, 1, 11, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            BlockState iblockdata = (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true)).setValue(IronBarsBlock.EAST, true);
            for (int j = 3; j < 14; j += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, j, 0, 4, j, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 10, 3, j, 10, 4, j, iblockdata, iblockdata, false);
            }
            for (int k = 2; k < 9; k += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, k, 3, 15, k, 4, 15, iblockdata1, iblockdata1, false);
            }
            BlockState iblockdata2 = (BlockState)Blocks.STONE_BRICK_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.NORTH);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 5, 6, 1, 7, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 6, 6, 2, 7, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 7, 6, 3, 7, false, randomsource, SMOOTH_STONE_SELECTOR);
            for (int l = 4; l <= 6; ++l) {
                this.placeBlock(generatoraccessseed, iblockdata2, l, 1, 4, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, l, 2, 5, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, l, 3, 6, structureboundingbox);
            }
            BlockState iblockdata3 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.NORTH);
            BlockState iblockdata4 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.SOUTH);
            BlockState iblockdata5 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.EAST);
            BlockState iblockdata6 = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(EndPortalFrameBlock.FACING, Direction.WEST);
            boolean flag = true;
            boolean[] aboolean = new boolean[12];
            for (int i1 = 0; i1 < aboolean.length; ++i1) {
                aboolean[i1] = randomsource.nextFloat() > 0.9f;
                flag &= aboolean[i1];
            }
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata3.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[0]), 4, 3, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata3.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[1]), 5, 3, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata3.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[2]), 6, 3, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata4.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[3]), 4, 3, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata4.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[4]), 5, 3, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata4.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[5]), 6, 3, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata5.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[6]), 3, 3, 9, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata5.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[7]), 3, 3, 10, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata5.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[8]), 3, 3, 11, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata6.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[9]), 7, 3, 9, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata6.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[10]), 7, 3, 10, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)iblockdata6.setValue(EndPortalFrameBlock.HAS_EYE, aboolean[11]), 7, 3, 11, structureboundingbox);
            if (flag) {
                BlockState iblockdata7 = Blocks.END_PORTAL.defaultBlockState();
                this.placeBlock(generatoraccessseed, iblockdata7, 4, 3, 9, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 5, 3, 9, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 6, 3, 9, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 4, 3, 10, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 5, 3, 10, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 6, 3, 10, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 4, 3, 11, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 5, 3, 11, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 6, 3, 11, structureboundingbox);
            }
            if (!this.hasPlacedSpawner && structureboundingbox.isInside(blockposition1 = this.getWorldPos(5, 3, 6))) {
                this.hasPlacedSpawner = true;
                this.placeCraftSpawner(generatoraccessseed, blockposition1, EntityType.SILVERFISH, 2);
            }
        }
    }

    private static abstract class StrongholdPiece
    extends StructurePiece {
        protected SmallDoorType entryDoor = SmallDoorType.OPENING;

        protected StrongholdPiece(StructurePieceType worldgenfeaturestructurepiecetype, int i, BoundingBox structureboundingbox) {
            super(worldgenfeaturestructurepiecetype, i, structureboundingbox);
        }

        public StrongholdPiece(StructurePieceType worldgenfeaturestructurepiecetype, CompoundTag nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
            this.entryDoor = nbttagcompound.read("EntryDoor", SmallDoorType.LEGACY_CODEC).orElseThrow();
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            nbttagcompound.store("EntryDoor", SmallDoorType.LEGACY_CODEC, this.entryDoor);
        }

        protected void generateSmallDoor(WorldGenLevel generatoraccessseed, RandomSource randomsource, BoundingBox structureboundingbox, SmallDoorType strongholdpieces_p_a, int i, int j, int k) {
            switch (strongholdpieces_p_a.ordinal()) {
                case 0: {
                    this.generateBox(generatoraccessseed, structureboundingbox, i, j, k, i + 3 - 1, j + 3 - 1, k, CAVE_AIR, CAVE_AIR, false);
                    break;
                }
                case 1: {
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i, j, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i, j + 1, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i, j + 2, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i + 1, j + 2, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i + 2, j + 2, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i + 2, j + 1, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i + 2, j, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.OAK_DOOR.defaultBlockState(), i + 1, j, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.OAK_DOOR.defaultBlockState().setValue(DoorBlock.HALF, DoubleBlockHalf.UPPER), i + 1, j + 1, k, structureboundingbox);
                    break;
                }
                case 2: {
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), i + 1, j, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), i + 1, j + 1, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true), i, j, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.WEST, true), i, j + 1, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true), i, j + 2, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true), i + 1, j + 2, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true), i + 2, j + 2, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true), i + 2, j + 1, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.IRON_BARS.defaultBlockState().setValue(IronBarsBlock.EAST, true), i + 2, j, k, structureboundingbox);
                    break;
                }
                case 3: {
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i, j, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i, j + 1, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i, j + 2, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i + 1, j + 2, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i + 2, j + 2, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i + 2, j + 1, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i + 2, j, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.IRON_DOOR.defaultBlockState(), i + 1, j, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.IRON_DOOR.defaultBlockState().setValue(DoorBlock.HALF, DoubleBlockHalf.UPPER), i + 1, j + 1, k, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.STONE_BUTTON.defaultBlockState().setValue(ButtonBlock.FACING, Direction.NORTH), i + 2, j + 1, k + 1, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (BlockState)Blocks.STONE_BUTTON.defaultBlockState().setValue(ButtonBlock.FACING, Direction.SOUTH), i + 2, j + 1, k - 1, structureboundingbox);
                }
            }
        }

        protected SmallDoorType randomSmallDoor(RandomSource randomsource) {
            int i = randomsource.nextInt(5);
            switch (i) {
                default: {
                    return SmallDoorType.OPENING;
                }
                case 2: {
                    return SmallDoorType.WOOD_DOOR;
                }
                case 3: {
                    return SmallDoorType.GRATES;
                }
                case 4: 
            }
            return SmallDoorType.IRON_DOOR;
        }

        protected @Nullable StructurePiece generateSmallDoorChildForward(StartPiece strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j) {
            Direction enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + i, this.boundingBox.minY() + j, this.boundingBox.minZ() - 1, enumdirection, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + i, this.boundingBox.minY() + j, this.boundingBox.maxZ() + 1, enumdirection, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + j, this.boundingBox.minZ() + i, enumdirection, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + j, this.boundingBox.minZ() + i, enumdirection, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        protected @Nullable StructurePiece generateSmallDoorChildLeft(StartPiece strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j) {
            Direction enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + i, this.boundingBox.minZ() + j, Direction.WEST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + i, this.boundingBox.minZ() + j, Direction.WEST, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + j, this.boundingBox.minY() + i, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + j, this.boundingBox.minY() + i, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        protected @Nullable StructurePiece generateSmallDoorChildRight(StartPiece strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j) {
            Direction enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + i, this.boundingBox.minZ() + j, Direction.EAST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + i, this.boundingBox.minZ() + j, Direction.EAST, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + j, this.boundingBox.minY() + i, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + j, this.boundingBox.minY() + i, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        protected static boolean isOkBox(BoundingBox structureboundingbox) {
            return structureboundingbox.minY() > 10;
        }

        protected static enum SmallDoorType {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

            @Deprecated
            public static final Codec<SmallDoorType> LEGACY_CODEC;

            static {
                LEGACY_CODEC = ExtraCodecs.legacyEnum(SmallDoorType::valueOf);
            }
        }
    }

    public static class StartPiece
    extends StairsDown {
        public @Nullable PieceWeight previousPiece;
        public @Nullable PortalRoom portalRoomPiece;
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public StartPiece(RandomSource randomsource, int i, int j) {
            super(StructurePieceType.STRONGHOLD_START, 0, i, j, StartPiece.getRandomHorizontalDirection(randomsource));
        }

        public StartPiece(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_START, nbttagcompound);
        }

        @Override
        public BlockPos getLocatorPosition() {
            return this.portalRoomPiece != null ? this.portalRoomPiece.getLocatorPosition() : super.getLocatorPosition();
        }
    }

    public static class FillerCorridor
    extends StrongholdPiece {
        private final int steps;

        public FillerCorridor(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.STRONGHOLD_FILLER_CORRIDOR, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.steps = enumdirection != Direction.NORTH && enumdirection != Direction.SOUTH ? structureboundingbox.getXSpan() : structureboundingbox.getZSpan();
        }

        public FillerCorridor(CompoundTag nbttagcompound) {
            super(StructurePieceType.STRONGHOLD_FILLER_CORRIDOR, nbttagcompound);
            this.steps = nbttagcompound.getIntOr("Steps", 0);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putInt("Steps", this.steps);
        }

        public static @Nullable BoundingBox findPieceBox(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection) {
            int l = 3;
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -1, 0, 5, 5, 4, enumdirection);
            StructurePiece structurepiece = structurepieceaccessor.findCollisionPiece(structureboundingbox);
            if (structurepiece == null) {
                return null;
            }
            if (structurepiece.getBoundingBox().minY() == structureboundingbox.minY()) {
                for (int i1 = 2; i1 >= 1; --i1) {
                    structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -1, 0, 5, 5, i1, enumdirection);
                    if (structurepiece.getBoundingBox().intersects(structureboundingbox)) continue;
                    return BoundingBox.orientBox(i, j, k, -1, -1, 0, 5, 5, i1 + 1, enumdirection);
                }
            }
            return null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            for (int i = 0; i < this.steps; ++i) {
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 0, 0, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 0, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 0, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 0, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 4, 0, i, structureboundingbox);
                for (int j = 1; j <= 3; ++j) {
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 0, j, i, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), 1, j, i, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), 2, j, i, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), 3, j, i, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 4, j, i, structureboundingbox);
                }
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 0, 4, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 4, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 4, 4, i, structureboundingbox);
            }
        }
    }

    private static class SmoothStoneSelector
    extends StructurePiece.BlockSelector {
        SmoothStoneSelector() {
        }

        @Override
        public void next(RandomSource randomsource, int i, int j, int k, boolean flag) {
            float f;
            this.next = flag ? ((f = randomsource.nextFloat()) < 0.2f ? Blocks.CRACKED_STONE_BRICKS.defaultBlockState() : (f < 0.5f ? Blocks.MOSSY_STONE_BRICKS.defaultBlockState() : (f < 0.55f ? Blocks.INFESTED_STONE_BRICKS.defaultBlockState() : Blocks.STONE_BRICKS.defaultBlockState()))) : Blocks.CAVE_AIR.defaultBlockState();
        }
    }

    public static abstract class Turn
    extends StrongholdPiece {
        protected static final int WIDTH = 5;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 5;

        protected Turn(StructurePieceType worldgenfeaturestructurepiecetype, int i, BoundingBox structureboundingbox) {
            super(worldgenfeaturestructurepiecetype, i, structureboundingbox);
        }

        public Turn(StructurePieceType worldgenfeaturestructurepiecetype, CompoundTag nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
        }
    }
}

