/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkSkyLightSources {
    private static final int SIZE = 16;
    public static final int NEGATIVE_INFINITY = Integer.MIN_VALUE;
    private final int minY;
    private final BitStorage heightmap;
    private final BlockPos.MutableBlockPos mutablePos1 = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos mutablePos2 = new BlockPos.MutableBlockPos();

    public ChunkSkyLightSources(LevelHeightAccessor var0) {
        this.minY = var0.getMinY() - 1;
        int var1 = var0.getMaxY() + 1;
        int var2 = Mth.ceillog2(var1 - this.minY + 1);
        this.heightmap = new SimpleBitStorage(var2, 256);
    }

    public void fillFrom(ChunkAccess var0) {
        int var1 = var0.getHighestFilledSectionIndex();
        if (var1 == -1) {
            this.fill(this.minY);
            return;
        }
        for (int var2 = 0; var2 < 16; ++var2) {
            for (int var3 = 0; var3 < 16; ++var3) {
                int var4 = Math.max(this.findLowestSourceY(var0, var1, var3, var2), this.minY);
                this.set(ChunkSkyLightSources.index(var3, var2), var4);
            }
        }
    }

    private int findLowestSourceY(ChunkAccess var0, int var1, int var2, int var3) {
        int var4 = SectionPos.sectionToBlockCoord(var0.getSectionYFromSectionIndex(var1) + 1);
        BlockPos.MutableBlockPos var5 = this.mutablePos1.set(var2, var4, var3);
        BlockPos.MutableBlockPos var6 = this.mutablePos2.setWithOffset((Vec3i)var5, Direction.DOWN);
        BlockState var7 = Blocks.AIR.defaultBlockState();
        for (int var8 = var1; var8 >= 0; --var8) {
            int var10;
            LevelChunkSection var9 = var0.getSection(var8);
            if (var9.hasOnlyAir()) {
                var7 = Blocks.AIR.defaultBlockState();
                var10 = var0.getSectionYFromSectionIndex(var8);
                var5.setY(SectionPos.sectionToBlockCoord(var10));
                var6.setY(var5.getY() - 1);
                continue;
            }
            for (var10 = 15; var10 >= 0; --var10) {
                BlockState var11 = var9.getBlockState(var2, var10, var3);
                if (ChunkSkyLightSources.isEdgeOccluded(var7, var11)) {
                    return var5.getY();
                }
                var7 = var11;
                var5.set(var6);
                var6.move(Direction.DOWN);
            }
        }
        return this.minY;
    }

    public boolean update(BlockGetter var0, int var1, int var2, int var3) {
        BlockState var10;
        BlockPos.MutableBlockPos var9;
        BlockState var8;
        int var4 = var2 + 1;
        int var5 = ChunkSkyLightSources.index(var1, var3);
        int var6 = this.get(var5);
        if (var4 < var6) {
            return false;
        }
        BlockPos.MutableBlockPos var7 = this.mutablePos1.set(var1, var2 + 1, var3);
        if (this.updateEdge(var0, var5, var6, var7, var8 = var0.getBlockState(var7), var9 = this.mutablePos2.set(var1, var2, var3), var10 = var0.getBlockState(var9))) {
            return true;
        }
        BlockPos.MutableBlockPos var11 = this.mutablePos1.set(var1, var2 - 1, var3);
        BlockState var12 = var0.getBlockState(var11);
        return this.updateEdge(var0, var5, var6, var9, var10, var11, var12);
    }

    private boolean updateEdge(BlockGetter var0, int var1, int var2, BlockPos var3, BlockState var4, BlockPos var5, BlockState var6) {
        int var7 = var3.getY();
        if (ChunkSkyLightSources.isEdgeOccluded(var4, var6)) {
            if (var7 > var2) {
                this.set(var1, var7);
                return true;
            }
        } else if (var7 == var2) {
            this.set(var1, this.findLowestSourceBelow(var0, var5, var6));
            return true;
        }
        return false;
    }

    private int findLowestSourceBelow(BlockGetter var0, BlockPos var1, BlockState var2) {
        BlockPos.MutableBlockPos var3 = this.mutablePos1.set(var1);
        BlockPos.MutableBlockPos var4 = this.mutablePos2.setWithOffset((Vec3i)var1, Direction.DOWN);
        BlockState var5 = var2;
        while (var4.getY() >= this.minY) {
            BlockState var6 = var0.getBlockState(var4);
            if (ChunkSkyLightSources.isEdgeOccluded(var5, var6)) {
                return var3.getY();
            }
            var5 = var6;
            var3.set(var4);
            var4.move(Direction.DOWN);
        }
        return this.minY;
    }

    private static boolean isEdgeOccluded(BlockState var0, BlockState var1) {
        if (var1.getLightBlock() != 0) {
            return true;
        }
        VoxelShape var2 = LightEngine.getOcclusionShape(var0, Direction.DOWN);
        VoxelShape var3 = LightEngine.getOcclusionShape(var1, Direction.UP);
        return Shapes.faceShapeOccludes(var2, var3);
    }

    public int getLowestSourceY(int var0, int var1) {
        int var2 = this.get(ChunkSkyLightSources.index(var0, var1));
        return this.extendSourcesBelowWorld(var2);
    }

    public int getHighestLowestSourceY() {
        int var0 = Integer.MIN_VALUE;
        for (int var1 = 0; var1 < this.heightmap.getSize(); ++var1) {
            int var2 = this.heightmap.get(var1);
            if (var2 <= var0) continue;
            var0 = var2;
        }
        return this.extendSourcesBelowWorld(var0 + this.minY);
    }

    private void fill(int var0) {
        int var1 = var0 - this.minY;
        for (int var2 = 0; var2 < this.heightmap.getSize(); ++var2) {
            this.heightmap.set(var2, var1);
        }
    }

    private void set(int var0, int var1) {
        this.heightmap.set(var0, var1 - this.minY);
    }

    private int get(int var0) {
        return this.heightmap.get(var0) + this.minY;
    }

    private int extendSourcesBelowWorld(int var0) {
        if (var0 == this.minY) {
            return Integer.MIN_VALUE;
        }
        return var0;
    }

    private static int index(int var0, int var1) {
        return var0 + var1 * 16;
    }
}

