/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.util.Mth;
import net.minecraft.world.level.lighting.LeveledPriorityQueue;

public abstract class DynamicGraphMinFixedPoint {
    public static final long SOURCE = Long.MAX_VALUE;
    private static final int NO_COMPUTED_LEVEL = 255;
    protected final int levelCount;
    private final LeveledPriorityQueue priorityQueue;
    private final Long2ByteMap computedLevels;
    private volatile boolean hasWork;

    protected DynamicGraphMinFixedPoint(int var0, int var1, final int var2) {
        if (var0 >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.levelCount = var0;
        this.priorityQueue = new LeveledPriorityQueue(var0, var1);
        this.computedLevels = new Long2ByteOpenHashMap(var2, 0.5f){

            protected void rehash(int var0) {
                if (var0 > var2) {
                    super.rehash(var0);
                }
            }
        };
        this.computedLevels.defaultReturnValue((byte)-1);
    }

    protected void removeFromQueue(long var0) {
        int var2 = this.computedLevels.remove(var0) & 0xFF;
        if (var2 == 255) {
            return;
        }
        int var3 = this.getLevel(var0);
        int var4 = this.calculatePriority(var3, var2);
        this.priorityQueue.dequeue(var0, var4, this.levelCount);
        this.hasWork = !this.priorityQueue.isEmpty();
    }

    public void removeIf(LongPredicate var0) {
        LongArrayList var1 = new LongArrayList();
        this.computedLevels.keySet().forEach(arg_0 -> DynamicGraphMinFixedPoint.lambda$removeIf$0(var0, (LongList)var1, arg_0));
        var1.forEach(this::removeFromQueue);
    }

    private int calculatePriority(int var0, int var1) {
        return Math.min(Math.min(var0, var1), this.levelCount - 1);
    }

    protected void checkNode(long var0) {
        this.checkEdge(var0, var0, this.levelCount - 1, false);
    }

    protected void checkEdge(long var0, long var2, int var4, boolean var5) {
        this.checkEdge(var0, var2, var4, this.getLevel(var2), this.computedLevels.get(var2) & 0xFF, var5);
        this.hasWork = !this.priorityQueue.isEmpty();
    }

    private void checkEdge(long var0, long var2, int var4, int var5, int var6, boolean var7) {
        boolean var8;
        if (this.isSource(var2)) {
            return;
        }
        var4 = Mth.clamp(var4, 0, this.levelCount - 1);
        var5 = Mth.clamp(var5, 0, this.levelCount - 1);
        boolean bl = var8 = var6 == 255;
        if (var8) {
            var6 = var5;
        }
        int var9 = var7 ? Math.min(var6, var4) : Mth.clamp(this.getComputedLevel(var2, var0, var4), 0, this.levelCount - 1);
        int var10 = this.calculatePriority(var5, var6);
        if (var5 != var9) {
            int var11 = this.calculatePriority(var5, var9);
            if (var10 != var11 && !var8) {
                this.priorityQueue.dequeue(var2, var10, var11);
            }
            this.priorityQueue.enqueue(var2, var11);
            this.computedLevels.put(var2, (byte)var9);
        } else if (!var8) {
            this.priorityQueue.dequeue(var2, var10, this.levelCount);
            this.computedLevels.remove(var2);
        }
    }

    protected final void checkNeighbor(long var0, long var2, int var4, boolean var5) {
        int var6 = this.computedLevels.get(var2) & 0xFF;
        int var7 = Mth.clamp(this.computeLevelFromNeighbor(var0, var2, var4), 0, this.levelCount - 1);
        if (var5) {
            this.checkEdge(var0, var2, var7, this.getLevel(var2), var6, var5);
        } else {
            boolean var9 = var6 == 255;
            int var8 = var9 ? Mth.clamp(this.getLevel(var2), 0, this.levelCount - 1) : var6;
            if (var7 == var8) {
                this.checkEdge(var0, var2, this.levelCount - 1, var9 ? var8 : this.getLevel(var2), var6, var5);
            }
        }
    }

    protected final boolean hasWork() {
        return this.hasWork;
    }

    protected final int runUpdates(int var0) {
        if (this.priorityQueue.isEmpty()) {
            return var0;
        }
        while (!this.priorityQueue.isEmpty() && var0 > 0) {
            --var0;
            long var1 = this.priorityQueue.removeFirstLong();
            int var3 = Mth.clamp(this.getLevel(var1), 0, this.levelCount - 1);
            int var4 = this.computedLevels.remove(var1) & 0xFF;
            if (var4 < var3) {
                this.setLevel(var1, var4);
                this.checkNeighborsAfterUpdate(var1, var4, true);
                continue;
            }
            if (var4 <= var3) continue;
            this.setLevel(var1, this.levelCount - 1);
            if (var4 != this.levelCount - 1) {
                this.priorityQueue.enqueue(var1, this.calculatePriority(this.levelCount - 1, var4));
                this.computedLevels.put(var1, (byte)var4);
            }
            this.checkNeighborsAfterUpdate(var1, var3, false);
        }
        this.hasWork = !this.priorityQueue.isEmpty();
        return var0;
    }

    public int getQueueSize() {
        return this.computedLevels.size();
    }

    protected boolean isSource(long var0) {
        return var0 == Long.MAX_VALUE;
    }

    protected abstract int getComputedLevel(long var1, long var3, int var5);

    protected abstract void checkNeighborsAfterUpdate(long var1, int var3, boolean var4);

    protected abstract int getLevel(long var1);

    protected abstract void setLevel(long var1, int var3);

    protected abstract int computeLevelFromNeighbor(long var1, long var3, int var5);

    private static /* synthetic */ void lambda$removeIf$0(LongPredicate var0, LongList var1, long var2) {
        if (var0.test(var2)) {
            var1.add(var2);
        }
    }
}

