/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEventListener;
import net.minecraft.world.level.lighting.SkyLightEngine;
import org.jspecify.annotations.Nullable;

public class LevelLightEngine
implements LightEventListener {
    public static final int LIGHT_SECTION_PADDING = 1;
    public static final LevelLightEngine EMPTY = new LevelLightEngine();
    protected final LevelHeightAccessor levelHeightAccessor;
    private final @Nullable LightEngine<?, ?> blockEngine;
    private final @Nullable LightEngine<?, ?> skyEngine;

    public LevelLightEngine(LightChunkGetter var0, boolean var1, boolean var2) {
        this.levelHeightAccessor = var0.getLevel();
        this.blockEngine = var1 ? new BlockLightEngine(var0) : null;
        this.skyEngine = var2 ? new SkyLightEngine(var0) : null;
    }

    private LevelLightEngine() {
        this.levelHeightAccessor = LevelHeightAccessor.create(0, 0);
        this.blockEngine = null;
        this.skyEngine = null;
    }

    @Override
    public void checkBlock(BlockPos var0) {
        if (this.blockEngine != null) {
            this.blockEngine.checkBlock(var0);
        }
        if (this.skyEngine != null) {
            this.skyEngine.checkBlock(var0);
        }
    }

    @Override
    public boolean hasLightWork() {
        if (this.skyEngine != null && this.skyEngine.hasLightWork()) {
            return true;
        }
        return this.blockEngine != null && this.blockEngine.hasLightWork();
    }

    @Override
    public int runLightUpdates() {
        int var0 = 0;
        if (this.blockEngine != null) {
            var0 += this.blockEngine.runLightUpdates();
        }
        if (this.skyEngine != null) {
            var0 += this.skyEngine.runLightUpdates();
        }
        return var0;
    }

    @Override
    public void updateSectionStatus(SectionPos var0, boolean var1) {
        if (this.blockEngine != null) {
            this.blockEngine.updateSectionStatus(var0, var1);
        }
        if (this.skyEngine != null) {
            this.skyEngine.updateSectionStatus(var0, var1);
        }
    }

    @Override
    public void setLightEnabled(ChunkPos var0, boolean var1) {
        if (this.blockEngine != null) {
            this.blockEngine.setLightEnabled(var0, var1);
        }
        if (this.skyEngine != null) {
            this.skyEngine.setLightEnabled(var0, var1);
        }
    }

    @Override
    public void propagateLightSources(ChunkPos var0) {
        if (this.blockEngine != null) {
            this.blockEngine.propagateLightSources(var0);
        }
        if (this.skyEngine != null) {
            this.skyEngine.propagateLightSources(var0);
        }
    }

    public LayerLightEventListener getLayerListener(LightLayer var0) {
        if (var0 == LightLayer.BLOCK) {
            if (this.blockEngine == null) {
                return LayerLightEventListener.DummyLightLayerEventListener.INSTANCE;
            }
            return this.blockEngine;
        }
        if (this.skyEngine == null) {
            return LayerLightEventListener.DummyLightLayerEventListener.INSTANCE;
        }
        return this.skyEngine;
    }

    public String getDebugData(LightLayer var0, SectionPos var1) {
        if (var0 == LightLayer.BLOCK) {
            if (this.blockEngine != null) {
                return this.blockEngine.getDebugData(var1.asLong());
            }
        } else if (this.skyEngine != null) {
            return this.skyEngine.getDebugData(var1.asLong());
        }
        return "n/a";
    }

    public LayerLightSectionStorage.SectionType getDebugSectionType(LightLayer var0, SectionPos var1) {
        if (var0 == LightLayer.BLOCK) {
            if (this.blockEngine != null) {
                return this.blockEngine.getDebugSectionType(var1.asLong());
            }
        } else if (this.skyEngine != null) {
            return this.skyEngine.getDebugSectionType(var1.asLong());
        }
        return LayerLightSectionStorage.SectionType.EMPTY;
    }

    public void queueSectionData(LightLayer var0, SectionPos var1, @Nullable DataLayer var2) {
        if (var0 == LightLayer.BLOCK) {
            if (this.blockEngine != null) {
                this.blockEngine.queueSectionData(var1.asLong(), var2);
            }
        } else if (this.skyEngine != null) {
            this.skyEngine.queueSectionData(var1.asLong(), var2);
        }
    }

    public void retainData(ChunkPos var0, boolean var1) {
        if (this.blockEngine != null) {
            this.blockEngine.retainData(var0, var1);
        }
        if (this.skyEngine != null) {
            this.skyEngine.retainData(var0, var1);
        }
    }

    public int getRawBrightness(BlockPos var0, int var1) {
        int var2 = this.skyEngine == null ? 0 : this.skyEngine.getLightValue(var0) - var1;
        int var3 = this.blockEngine == null ? 0 : this.blockEngine.getLightValue(var0);
        return Math.max(var3, var2);
    }

    public boolean lightOnInColumn(long var0) {
        return this.blockEngine == null || ((LayerLightSectionStorage)this.blockEngine.storage).lightOnInColumn(var0) && (this.skyEngine == null || ((LayerLightSectionStorage)this.skyEngine.storage).lightOnInColumn(var0));
    }

    public int getLightSectionCount() {
        return this.levelHeightAccessor.getSectionsCount() + 2;
    }

    public int getMinLightSection() {
        return this.levelHeightAccessor.getMinSectionY() - 1;
    }

    public int getMaxLightSection() {
        return this.getMinLightSection() + this.getLightSectionCount();
    }
}

