/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;

public class SkyLightSectionStorage
extends LayerLightSectionStorage<SkyDataLayerStorageMap> {
    protected SkyLightSectionStorage(LightChunkGetter var0) {
        super(LightLayer.SKY, var0, new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)new Long2ObjectOpenHashMap(), new Long2IntOpenHashMap(), Integer.MAX_VALUE));
    }

    @Override
    protected int getLightValue(long var0) {
        return this.getLightValue(var0, false);
    }

    protected int getLightValue(long var0, boolean var2) {
        long var3 = SectionPos.blockToSection(var0);
        int var5 = SectionPos.y(var3);
        SkyDataLayerStorageMap var6 = var2 ? (SkyDataLayerStorageMap)this.updatingSectionData : (SkyDataLayerStorageMap)this.visibleSectionData;
        int var7 = var6.topSections.get(SectionPos.getZeroNode(var3));
        if (var7 == var6.currentLowestY || var5 >= var7) {
            if (var2 && !this.lightOnInSection(var3)) {
                return 0;
            }
            return 15;
        }
        DataLayer var8 = this.getDataLayer(var6, var3);
        if (var8 == null) {
            var0 = BlockPos.getFlatIndex(var0);
            while (var8 == null) {
                if (++var5 >= var7) {
                    return 15;
                }
                var3 = SectionPos.offset(var3, Direction.UP);
                var8 = this.getDataLayer(var6, var3);
            }
        }
        return var8.get(SectionPos.sectionRelative(BlockPos.getX(var0)), SectionPos.sectionRelative(BlockPos.getY(var0)), SectionPos.sectionRelative(BlockPos.getZ(var0)));
    }

    @Override
    protected void onNodeAdded(long var0) {
        long var3;
        int var5;
        int var2 = SectionPos.y(var0);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY > var2) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY = var2;
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.defaultReturnValue(((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY);
        }
        if ((var5 = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(var3 = SectionPos.getZeroNode(var0))) < var2 + 1) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(var3, var2 + 1);
        }
    }

    @Override
    protected void onNodeRemoved(long var0) {
        long var2 = SectionPos.getZeroNode(var0);
        int var4 = SectionPos.y(var0);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(var2) == var4 + 1) {
            long var5 = var0;
            while (!this.storingLightForSection(var5) && this.hasLightDataAtOrBelow(var4)) {
                --var4;
                var5 = SectionPos.offset(var5, Direction.DOWN);
            }
            if (this.storingLightForSection(var5)) {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(var2, var4 + 1);
            } else {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.remove(var2);
            }
        }
    }

    @Override
    protected DataLayer createDataLayer(long var0) {
        DataLayer var6;
        DataLayer var2 = (DataLayer)this.queuedSections.get(var0);
        if (var2 != null) {
            return var2;
        }
        int var3 = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(SectionPos.getZeroNode(var0));
        if (var3 == ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY || SectionPos.y(var0) >= var3) {
            if (this.lightOnInSection(var0)) {
                return new DataLayer(15);
            }
            return new DataLayer();
        }
        long var4 = SectionPos.offset(var0, Direction.UP);
        while ((var6 = this.getDataLayer(var4, true)) == null) {
            var4 = SectionPos.offset(var4, Direction.UP);
        }
        return SkyLightSectionStorage.repeatFirstLayer(var6);
    }

    private static DataLayer repeatFirstLayer(DataLayer var0) {
        if (var0.isDefinitelyHomogenous()) {
            return var0.copy();
        }
        byte[] var1 = var0.getData();
        byte[] var2 = new byte[2048];
        for (int var3 = 0; var3 < 16; ++var3) {
            System.arraycopy(var1, 0, var2, var3 * 128, 128);
        }
        return new DataLayer(var2);
    }

    protected boolean hasLightDataAtOrBelow(int var0) {
        return var0 >= ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY;
    }

    protected boolean isAboveData(long var0) {
        long var2 = SectionPos.getZeroNode(var0);
        int var4 = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(var2);
        return var4 == ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY || SectionPos.y(var0) >= var4;
    }

    protected int getTopSectionY(long var0) {
        return ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(var0);
    }

    protected int getBottomSectionY() {
        return ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY;
    }

    protected static final class SkyDataLayerStorageMap
    extends DataLayerStorageMap<SkyDataLayerStorageMap> {
        int currentLowestY;
        final Long2IntOpenHashMap topSections;

        public SkyDataLayerStorageMap(Long2ObjectOpenHashMap<DataLayer> var0, Long2IntOpenHashMap var1, int var2) {
            super(var0);
            this.topSections = var1;
            var1.defaultReturnValue(var2);
            this.currentLowestY = var2;
        }

        @Override
        public SkyDataLayerStorageMap copy() {
            return new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)this.map.clone(), this.topSections.clone(), this.currentLowestY);
        }

        @Override
        public /* synthetic */ DataLayerStorageMap copy() {
            return this.copy();
        }
    }
}

