/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public abstract class LavaFluid
extends FlowingFluid {
    public static final float MIN_LEVEL_CUTOFF = 0.44444445f;

    @Override
    public Fluid getFlowing() {
        return Fluids.FLOWING_LAVA;
    }

    @Override
    public Fluid getSource() {
        return Fluids.LAVA;
    }

    @Override
    public Item getBucket() {
        return Items.LAVA_BUCKET;
    }

    @Override
    public void animateTick(Level world, BlockPos blockposition, FluidState fluid, RandomSource randomsource) {
        BlockPos blockposition1 = blockposition.above();
        if (world.getBlockState(blockposition1).isAir() && !world.getBlockState(blockposition1).isSolidRender()) {
            if (randomsource.nextInt(100) == 0) {
                double d0 = (double)blockposition.getX() + randomsource.nextDouble();
                double d1 = (double)blockposition.getY() + 1.0;
                double d2 = (double)blockposition.getZ() + randomsource.nextDouble();
                world.addParticle(ParticleTypes.LAVA, d0, d1, d2, 0.0, 0.0, 0.0);
                world.playLocalSound(d0, d1, d2, SoundEvents.LAVA_POP, SoundSource.AMBIENT, 0.2f + randomsource.nextFloat() * 0.2f, 0.9f + randomsource.nextFloat() * 0.15f, false);
            }
            if (randomsource.nextInt(200) == 0) {
                world.playLocalSound(blockposition.getX(), blockposition.getY(), blockposition.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.AMBIENT, 0.2f + randomsource.nextFloat() * 0.2f, 0.9f + randomsource.nextFloat() * 0.15f, false);
            }
        }
    }

    @Override
    public void randomTick(ServerLevel worldserver, BlockPos blockposition, FluidState fluid, RandomSource randomsource) {
        block7: {
            if (!worldserver.canSpreadFireAround(blockposition)) break block7;
            int i = randomsource.nextInt(3);
            if (i > 0) {
                BlockPos blockposition1 = blockposition;
                for (int j = 0; j < i; ++j) {
                    if (!worldserver.isLoaded(blockposition1 = blockposition1.offset(randomsource.nextInt(3) - 1, 1, randomsource.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState iblockdata = worldserver.getBlockState(blockposition1);
                    if (iblockdata.isAir()) {
                        if (!this.hasFlammableNeighbours(worldserver, blockposition1) || worldserver.getBlockState(blockposition1).getBlock() != Blocks.FIRE && CraftEventFactory.callBlockIgniteEvent((Level)worldserver, blockposition1, blockposition).isCancelled()) continue;
                        worldserver.setBlockAndUpdate(blockposition1, BaseFireBlock.getState(worldserver, blockposition1));
                        return;
                    }
                    if (!iblockdata.blocksMotion()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos up;
                    BlockPos blockposition2 = blockposition.offset(randomsource.nextInt(3) - 1, 0, randomsource.nextInt(3) - 1);
                    if (!worldserver.isLoaded(blockposition2)) {
                        return;
                    }
                    if (!worldserver.isEmptyBlock(blockposition2.above()) || !this.isFlammable(worldserver, blockposition2) || worldserver.getBlockState(up = blockposition2.above()).getBlock() != Blocks.FIRE && CraftEventFactory.callBlockIgniteEvent((Level)worldserver, up, blockposition).isCancelled()) continue;
                    worldserver.setBlockAndUpdate(blockposition2.above(), BaseFireBlock.getState(worldserver, blockposition2));
                }
            }
        }
    }

    @Override
    protected void entityInside(Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        insideblockeffectapplier.apply(InsideBlockEffectType.CLEAR_FREEZE);
        insideblockeffectapplier.apply(InsideBlockEffectType.LAVA_IGNITE);
        insideblockeffectapplier.runAfter(InsideBlockEffectType.LAVA_IGNITE, Entity::lavaHurt);
    }

    private boolean hasFlammableNeighbours(LevelReader iworldreader, BlockPos blockposition) {
        for (Direction enumdirection : Direction.values()) {
            if (!this.isFlammable(iworldreader, blockposition.relative(enumdirection))) continue;
            return true;
        }
        return false;
    }

    private boolean isFlammable(LevelReader iworldreader, BlockPos blockposition) {
        return iworldreader.isInsideBuildHeight(blockposition.getY()) && !iworldreader.hasChunkAt(blockposition) ? false : iworldreader.getBlockState(blockposition).ignitedByLava();
    }

    @Override
    public @Nullable ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_LAVA;
    }

    @Override
    protected void beforeDestroyingBlock(LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata) {
        this.fizz(generatoraccess, blockposition);
    }

    @Override
    public int getSlopeFindDistance(LevelReader iworldreader) {
        return LavaFluid.isFastLava(iworldreader) ? 4 : 2;
    }

    @Override
    public BlockState createLegacyBlock(FluidState fluid) {
        return (BlockState)Blocks.LAVA.defaultBlockState().setValue(LiquidBlock.LEVEL, LavaFluid.getLegacyLevel(fluid));
    }

    @Override
    public boolean isSame(Fluid fluidtype) {
        return fluidtype == Fluids.LAVA || fluidtype == Fluids.FLOWING_LAVA;
    }

    @Override
    public int getDropOff(LevelReader iworldreader) {
        return LavaFluid.isFastLava(iworldreader) ? 1 : 2;
    }

    @Override
    public boolean canBeReplacedWith(FluidState fluid, BlockGetter iblockaccess, BlockPos blockposition, Fluid fluidtype, Direction enumdirection) {
        return fluid.getHeight(iblockaccess, blockposition) >= 0.44444445f && fluidtype.is(FluidTags.WATER);
    }

    @Override
    public int getTickDelay(LevelReader iworldreader) {
        return LavaFluid.isFastLava(iworldreader) ? 10 : 30;
    }

    @Override
    public int getSpreadDelay(Level world, BlockPos blockposition, FluidState fluid, FluidState fluid1) {
        int i = this.getTickDelay(world);
        if (!(fluid.isEmpty() || fluid1.isEmpty() || fluid.getValue(FALLING).booleanValue() || fluid1.getValue(FALLING).booleanValue() || !(fluid1.getHeight(world, blockposition) > fluid.getHeight(world, blockposition)) || world.getRandom().nextInt(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    private void fizz(LevelAccessor generatoraccess, BlockPos blockposition) {
        generatoraccess.levelEvent(1501, blockposition, 0);
    }

    @Override
    protected boolean canConvertToSource(ServerLevel worldserver) {
        return worldserver.getGameRules().get(GameRules.LAVA_SOURCE_CONVERSION);
    }

    @Override
    protected void spreadTo(LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata, Direction enumdirection, FluidState fluid) {
        if (enumdirection == Direction.DOWN) {
            FluidState fluid1 = generatoraccess.getFluidState(blockposition);
            if (this.is(FluidTags.LAVA) && fluid1.is(FluidTags.WATER)) {
                if (iblockdata.getBlock() instanceof LiquidBlock && !CraftEventFactory.handleBlockFormEvent((Level)generatoraccess.getMinecraftWorld(), blockposition, Blocks.STONE.defaultBlockState(), 3)) {
                    return;
                }
                this.fizz(generatoraccess, blockposition);
                return;
            }
        }
        super.spreadTo(generatoraccess, blockposition, iblockdata, enumdirection, fluid);
    }

    @Override
    protected boolean isRandomlyTicking() {
        return true;
    }

    @Override
    protected float getExplosionResistance() {
        return 100.0f;
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL_LAVA);
    }

    private static boolean isFastLava(LevelReader iworldreader) {
        return iworldreader.environmentAttributes().getDimensionValue(EnvironmentAttributes.FAST_LAVA);
    }

    public static class Flowing
    extends LavaFluid {
        @Override
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> blockstatelist_a) {
            super.createFluidStateDefinition(blockstatelist_a);
            blockstatelist_a.add(LEVEL);
        }

        @Override
        public int getAmount(FluidState fluid) {
            return fluid.getValue(LEVEL);
        }

        @Override
        public boolean isSource(FluidState fluid) {
            return false;
        }
    }

    public static class Source
    extends LavaFluid {
        @Override
        public int getAmount(FluidState fluid) {
            return 8;
        }

        @Override
        public boolean isSource(FluidState fluid) {
            return true;
        }
    }
}

