/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jspecify.annotations.Nullable;

public abstract class WaterFluid
extends FlowingFluid {
    @Override
    public Fluid getFlowing() {
        return Fluids.FLOWING_WATER;
    }

    @Override
    public Fluid getSource() {
        return Fluids.WATER;
    }

    @Override
    public Item getBucket() {
        return Items.WATER_BUCKET;
    }

    @Override
    public void animateTick(Level var0, BlockPos var1, FluidState var2, RandomSource var3) {
        if (!var2.isSource() && !var2.getValue(FALLING).booleanValue()) {
            if (var3.nextInt(64) == 0) {
                var0.playLocalSound((double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.AMBIENT, var3.nextFloat() * 0.25f + 0.75f, var3.nextFloat() + 0.5f, false);
            }
        } else if (var3.nextInt(10) == 0) {
            var0.addParticle(ParticleTypes.UNDERWATER, (double)var1.getX() + var3.nextDouble(), (double)var1.getY() + var3.nextDouble(), (double)var1.getZ() + var3.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public @Nullable ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    @Override
    protected boolean canConvertToSource(ServerLevel var0) {
        return var0.getGameRules().get(GameRules.WATER_SOURCE_CONVERSION);
    }

    @Override
    protected void beforeDestroyingBlock(LevelAccessor var0, BlockPos var1, BlockState var2) {
        BlockEntity var3 = var2.hasBlockEntity() ? var0.getBlockEntity(var1) : null;
        Block.dropResources(var2, var0, var1, var3);
    }

    @Override
    protected void entityInside(Level var0, BlockPos var1, Entity var2, InsideBlockEffectApplier var3) {
        var3.apply(InsideBlockEffectType.EXTINGUISH);
    }

    @Override
    public int getSlopeFindDistance(LevelReader var0) {
        return 4;
    }

    @Override
    public BlockState createLegacyBlock(FluidState var0) {
        return (BlockState)Blocks.WATER.defaultBlockState().setValue(LiquidBlock.LEVEL, WaterFluid.getLegacyLevel(var0));
    }

    @Override
    public boolean isSame(Fluid var0) {
        return var0 == Fluids.WATER || var0 == Fluids.FLOWING_WATER;
    }

    @Override
    public int getDropOff(LevelReader var0) {
        return 1;
    }

    @Override
    public int getTickDelay(LevelReader var0) {
        return 5;
    }

    @Override
    public boolean canBeReplacedWith(FluidState var0, BlockGetter var1, BlockPos var2, Fluid var3, Direction var4) {
        return var4 == Direction.DOWN && !var3.is(FluidTags.WATER);
    }

    @Override
    protected float getExplosionResistance() {
        return 100.0f;
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }

    public static class Flowing
    extends WaterFluid {
        @Override
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> var0) {
            super.createFluidStateDefinition(var0);
            var0.add(LEVEL);
        }

        @Override
        public int getAmount(FluidState var0) {
            return var0.getValue(LEVEL);
        }

        @Override
        public boolean isSource(FluidState var0) {
            return false;
        }
    }

    public static class Source
    extends WaterFluid {
        @Override
        public int getAmount(FluidState var0) {
            return 8;
        }

        @Override
        public boolean isSource(FluidState var0) {
            return true;
        }
    }
}

