/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jspecify.annotations.Nullable;

public class PathfindingContext {
    private final CollisionGetter level;
    private final @Nullable PathTypeCache cache;
    private final BlockPos mobPosition;
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public PathfindingContext(CollisionGetter var0, Mob var1) {
        this.level = var0;
        Level level = var1.level();
        if (level instanceof ServerLevel) {
            ServerLevel var2 = (ServerLevel)level;
            this.cache = var2.getPathTypeCache();
        } else {
            this.cache = null;
        }
        this.mobPosition = var1.blockPosition();
    }

    public PathType getPathTypeFromState(int var0, int var1, int var2) {
        BlockPos.MutableBlockPos var3 = this.mutablePos.set(var0, var1, var2);
        if (this.cache == null) {
            return WalkNodeEvaluator.getPathTypeFromState(this.level, var3);
        }
        return this.cache.getOrCompute(this.level, var3);
    }

    public BlockState getBlockState(BlockPos var0) {
        return this.level.getBlockState(var0);
    }

    public CollisionGetter level() {
        return this.level;
    }

    public BlockPos mobPosition() {
        return this.mobPosition;
    }
}

