/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.mojang.logging.LogUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class CollectingNeighborUpdater
implements NeighborUpdater {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Level level;
    private final int maxChainedNeighborUpdates;
    private final ArrayDeque<NeighborUpdates> stack = new ArrayDeque();
    private final List<NeighborUpdates> addedThisLayer = new ArrayList<NeighborUpdates>();
    private int count = 0;
    private @Nullable Consumer<BlockPos> debugListener;

    public CollectingNeighborUpdater(Level var0, int var1) {
        this.level = var0;
        this.maxChainedNeighborUpdates = var1;
    }

    public void setDebugListener(@Nullable Consumer<BlockPos> var0) {
        this.debugListener = var0;
    }

    @Override
    public void shapeUpdate(Direction var0, BlockState var1, BlockPos var2, BlockPos var3, @Block.UpdateFlags int var4, int var5) {
        this.addAndRun(var2, new ShapeUpdate(var0, var1, var2.immutable(), var3.immutable(), var4, var5));
    }

    @Override
    public void neighborChanged(BlockPos var0, Block var1, @Nullable Orientation var2) {
        this.addAndRun(var0, new SimpleNeighborUpdate(var0, var1, var2));
    }

    @Override
    public void neighborChanged(BlockState var0, BlockPos var1, Block var2, @Nullable Orientation var3, boolean var4) {
        this.addAndRun(var1, new FullNeighborUpdate(var0, var1.immutable(), var2, var3, var4));
    }

    @Override
    public void updateNeighborsAtExceptFromFacing(BlockPos var0, Block var1, @Nullable Direction var2, @Nullable Orientation var3) {
        this.addAndRun(var0, new MultiNeighborUpdate(var0.immutable(), var1, var3, var2));
    }

    private void addAndRun(BlockPos var0, NeighborUpdates var1) {
        boolean var2 = this.count > 0;
        boolean var3 = this.maxChainedNeighborUpdates >= 0 && this.count >= this.maxChainedNeighborUpdates;
        ++this.count;
        if (!var3) {
            if (var2) {
                this.addedThisLayer.add(var1);
            } else {
                this.stack.push(var1);
            }
        } else if (this.count - 1 == this.maxChainedNeighborUpdates) {
            LOGGER.error("Too many chained neighbor updates. Skipping the rest. First skipped position: {}", (Object)var0.toShortString());
        }
        if (!var2) {
            this.runUpdates();
        }
    }

    private void runUpdates() {
        try {
            block3: while (!this.stack.isEmpty() || !this.addedThisLayer.isEmpty()) {
                for (int var0 = this.addedThisLayer.size() - 1; var0 >= 0; --var0) {
                    this.stack.push(this.addedThisLayer.get(var0));
                }
                this.addedThisLayer.clear();
                NeighborUpdates var0 = this.stack.peek();
                if (this.debugListener != null) {
                    var0.forEachUpdatedPos(this.debugListener);
                }
                while (this.addedThisLayer.isEmpty()) {
                    if (var0.runNext(this.level)) continue;
                    this.stack.pop();
                    continue block3;
                }
            }
        }
        finally {
            this.stack.clear();
            this.addedThisLayer.clear();
            this.count = 0;
        }
    }

    record ShapeUpdate(Direction direction, BlockState neighborState, BlockPos pos, BlockPos neighborPos, @Block.UpdateFlags int updateFlags, int updateLimit) implements NeighborUpdates
    {
        @Override
        public boolean runNext(Level var0) {
            NeighborUpdater.executeShapeUpdate(var0, this.direction, this.pos, this.neighborPos, this.neighborState, this.updateFlags, this.updateLimit);
            return false;
        }

        @Override
        public void forEachUpdatedPos(Consumer<BlockPos> var0) {
            var0.accept(this.pos);
        }
    }

    static interface NeighborUpdates {
        public boolean runNext(Level var1);

        public void forEachUpdatedPos(Consumer<BlockPos> var1);
    }

    record SimpleNeighborUpdate(BlockPos pos, Block block, @Nullable Orientation orientation) implements NeighborUpdates
    {
        @Override
        public boolean runNext(Level var0) {
            BlockState var1 = var0.getBlockState(this.pos);
            NeighborUpdater.executeUpdate(var0, var1, this.pos, this.block, this.orientation, false);
            return false;
        }

        @Override
        public void forEachUpdatedPos(Consumer<BlockPos> var0) {
            var0.accept(this.pos);
        }
    }

    record FullNeighborUpdate(BlockState state, BlockPos pos, Block block, @Nullable Orientation orientation, boolean movedByPiston) implements NeighborUpdates
    {
        @Override
        public boolean runNext(Level var0) {
            NeighborUpdater.executeUpdate(var0, this.state, this.pos, this.block, this.orientation, this.movedByPiston);
            return false;
        }

        @Override
        public void forEachUpdatedPos(Consumer<BlockPos> var0) {
            var0.accept(this.pos);
        }
    }

    static final class MultiNeighborUpdate
    implements NeighborUpdates {
        private final BlockPos sourcePos;
        private final Block sourceBlock;
        private @Nullable Orientation orientation;
        private final @Nullable Direction skipDirection;
        private int idx = 0;

        MultiNeighborUpdate(BlockPos var0, Block var1, @Nullable Orientation var2, @Nullable Direction var3) {
            this.sourcePos = var0;
            this.sourceBlock = var1;
            this.orientation = var2;
            this.skipDirection = var3;
            if (NeighborUpdater.UPDATE_ORDER[this.idx] == var3) {
                ++this.idx;
            }
        }

        @Override
        public boolean runNext(Level var0) {
            Direction var1 = NeighborUpdater.UPDATE_ORDER[this.idx++];
            BlockPos var2 = this.sourcePos.relative(var1);
            BlockState var3 = var0.getBlockState(var2);
            Orientation var4 = null;
            if (var0.enabledFeatures().contains(FeatureFlags.REDSTONE_EXPERIMENTS)) {
                if (this.orientation == null) {
                    this.orientation = ExperimentalRedstoneUtils.initialOrientation(var0, this.skipDirection == null ? null : this.skipDirection.getOpposite(), null);
                }
                var4 = this.orientation.withFront(var1);
            }
            NeighborUpdater.executeUpdate(var0, var3, var2, this.sourceBlock, var4, false);
            if (this.idx < NeighborUpdater.UPDATE_ORDER.length && NeighborUpdater.UPDATE_ORDER[this.idx] == this.skipDirection) {
                ++this.idx;
            }
            return this.idx < NeighborUpdater.UPDATE_ORDER.length;
        }

        @Override
        public void forEachUpdatedPos(Consumer<BlockPos> var0) {
            for (Direction var4 : NeighborUpdater.UPDATE_ORDER) {
                if (var4 == this.skipDirection) continue;
                BlockPos var5 = this.sourcePos.relative(var4);
                var0.accept(var5);
            }
        }
    }
}

