/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class DefaultRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    public DefaultRedstoneWireEvaluator(RedStoneWireBlock blockredstonewire) {
        super(blockredstonewire);
    }

    @Override
    public void updatePowerStrength(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable Orientation orientation, boolean flag) {
        int i = this.calculateTargetStrength(world, blockposition);
        int oldPower = iblockdata.getValue(RedStoneWireBlock.POWER);
        if (oldPower != i) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(world, blockposition), oldPower, i);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            i = event.getNewCurrent();
        }
        if (oldPower != i) {
            if (world.getBlockState(blockposition) == iblockdata) {
                world.setBlock(blockposition, (BlockState)iblockdata.setValue(RedStoneWireBlock.POWER, i), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(blockposition);
            for (Direction enumdirection : Direction.values()) {
                set.add(blockposition.relative(enumdirection));
            }
            for (BlockPos blockposition1 : set) {
                world.updateNeighborsAt(blockposition1, this.wireBlock);
            }
        }
    }

    private int calculateTargetStrength(Level world, BlockPos blockposition) {
        int i = this.getBlockSignal(world, blockposition);
        return i == 15 ? i : Math.max(i, this.getIncomingWireSignal(world, blockposition));
    }
}

