/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;

public class Orientation {
    public static final StreamCodec<ByteBuf, Orientation> STREAM_CODEC = ByteBufCodecs.idMapper(Orientation::fromIndex, Orientation::getIndex);
    private static final Orientation[] ORIENTATIONS = Util.make(() -> {
        Orientation[] var0 = new Orientation[48];
        Orientation.generateContext(new Orientation(Direction.UP, Direction.NORTH, SideBias.LEFT), var0);
        return var0;
    });
    private final Direction up;
    private final Direction front;
    private final Direction side;
    private final SideBias sideBias;
    private final int index;
    private final List<Direction> neighbors;
    private final List<Direction> horizontalNeighbors;
    private final List<Direction> verticalNeighbors;
    private final Map<Direction, Orientation> withFront = new EnumMap<Direction, Orientation>(Direction.class);
    private final Map<Direction, Orientation> withUp = new EnumMap<Direction, Orientation>(Direction.class);
    private final Map<SideBias, Orientation> withSideBias = new EnumMap<SideBias, Orientation>(SideBias.class);

    private Orientation(Direction var02, Direction var1, SideBias var2) {
        this.up = var02;
        this.front = var1;
        this.sideBias = var2;
        this.index = Orientation.generateIndex(var02, var1, var2);
        Vec3i var3 = var1.getUnitVec3i().cross(var02.getUnitVec3i());
        Direction var4 = Direction.getNearest(var3, null);
        Objects.requireNonNull(var4);
        this.side = this.sideBias == SideBias.RIGHT ? var4 : var4.getOpposite();
        this.neighbors = List.of(this.front.getOpposite(), this.front, this.side, this.side.getOpposite(), this.up.getOpposite(), this.up);
        this.horizontalNeighbors = this.neighbors.stream().filter(var0 -> var0.getAxis() != this.up.getAxis()).toList();
        this.verticalNeighbors = this.neighbors.stream().filter(var0 -> var0.getAxis() == this.up.getAxis()).toList();
    }

    public static Orientation of(Direction var0, Direction var1, SideBias var2) {
        return ORIENTATIONS[Orientation.generateIndex(var0, var1, var2)];
    }

    public Orientation withUp(Direction var0) {
        return this.withUp.get(var0);
    }

    public Orientation withFront(Direction var0) {
        return this.withFront.get(var0);
    }

    public Orientation withFrontPreserveUp(Direction var0) {
        if (var0.getAxis() == this.up.getAxis()) {
            return this;
        }
        return this.withFront.get(var0);
    }

    public Orientation withFrontAdjustSideBias(Direction var0) {
        Orientation var1 = this.withFront(var0);
        if (this.front == var1.side) {
            return var1.withMirror();
        }
        return var1;
    }

    public Orientation withSideBias(SideBias var0) {
        return this.withSideBias.get((Object)var0);
    }

    public Orientation withMirror() {
        return this.withSideBias(this.sideBias.getOpposite());
    }

    public Direction getFront() {
        return this.front;
    }

    public Direction getUp() {
        return this.up;
    }

    public Direction getSide() {
        return this.side;
    }

    public SideBias getSideBias() {
        return this.sideBias;
    }

    public List<Direction> getDirections() {
        return this.neighbors;
    }

    public List<Direction> getHorizontalDirections() {
        return this.horizontalNeighbors;
    }

    public List<Direction> getVerticalDirections() {
        return this.verticalNeighbors;
    }

    public String toString() {
        return "[up=" + String.valueOf(this.up) + ",front=" + String.valueOf(this.front) + ",sideBias=" + String.valueOf((Object)this.sideBias) + "]";
    }

    public int getIndex() {
        return this.index;
    }

    public static Orientation fromIndex(int var0) {
        return ORIENTATIONS[var0];
    }

    public static Orientation random(RandomSource var0) {
        return Util.getRandom(ORIENTATIONS, var0);
    }

    private static Orientation generateContext(Orientation var0, Orientation[] var1) {
        Direction var6;
        if (var1[var0.getIndex()] != null) {
            return var1[var0.getIndex()];
        }
        var1[var0.getIndex()] = var0;
        for (SideBias sideBias : SideBias.values()) {
            var0.withSideBias.put(sideBias, Orientation.generateContext(new Orientation(var0.up, var0.front, sideBias), var1));
        }
        for (Enum enum_ : Direction.values()) {
            var6 = var0.up;
            if (enum_ == var0.up) {
                var6 = var0.front.getOpposite();
            }
            if (enum_ == var0.up.getOpposite()) {
                var6 = var0.front;
            }
            var0.withFront.put((Direction)enum_, Orientation.generateContext(new Orientation(var6, (Direction)enum_, var0.sideBias), var1));
        }
        for (Enum enum_ : Direction.values()) {
            var6 = var0.front;
            if (enum_ == var0.front) {
                var6 = var0.up.getOpposite();
            }
            if (enum_ == var0.front.getOpposite()) {
                var6 = var0.up;
            }
            var0.withUp.put((Direction)enum_, Orientation.generateContext(new Orientation((Direction)enum_, var6, var0.sideBias), var1));
        }
        return var0;
    }

    @VisibleForTesting
    protected static int generateIndex(Direction var0, Direction var1, SideBias var2) {
        if (var0.getAxis() == var1.getAxis()) {
            throw new IllegalStateException("Up-vector and front-vector can not be on the same axis");
        }
        int var3 = var0.getAxis() == Direction.Axis.Y ? (var1.getAxis() == Direction.Axis.X ? 1 : 0) : (var1.getAxis() == Direction.Axis.Y ? 1 : 0);
        int var4 = var3 << 1 | var1.getAxisDirection().ordinal();
        return ((var0.ordinal() << 2) + var4 << 1) + var2.ordinal();
    }

    public static enum SideBias {
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private SideBias(String var2) {
            this.name = var2;
        }

        public SideBias getOpposite() {
            return this == LEFT ? RIGHT : LEFT;
        }

        public String toString() {
            return this.name;
        }
    }
}

