/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.FileUtil;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_DATA = "Data";
    private static final PathMatcher NO_SYMLINKS_ALLOWED = path -> false;
    public static final String ALLOWED_SYMLINKS_CONFIG_NAME = "allowed_symlinks.txt";
    private static final int DISK_SPACE_WARNING_THRESHOLD = 0x4000000;
    public final Path baseDir;
    private final Path backupDir;
    final DataFixer fixerUpper;
    private final DirectoryValidator worldDirValidator;

    public LevelStorageSource(Path path, Path path1, DirectoryValidator directoryvalidator, DataFixer datafixer) {
        this.fixerUpper = datafixer;
        try {
            FileUtil.createDirectoriesSafe(path);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
        this.baseDir = path;
        this.backupDir = path1;
        this.worldDirValidator = directoryvalidator;
    }

    public static DirectoryValidator parseValidator(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            DirectoryValidator directoryValidator;
            block9: {
                BufferedReader bufferedreader = Files.newBufferedReader(path);
                try {
                    directoryValidator = new DirectoryValidator(PathAllowList.readPlain(bufferedreader));
                    if (bufferedreader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedreader != null) {
                            try {
                                bufferedreader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to parse {}, disallowing all symbolic links", (Object)ALLOWED_SYMLINKS_CONFIG_NAME, (Object)exception);
                    }
                }
                bufferedreader.close();
            }
            return directoryValidator;
        }
        return new DirectoryValidator(NO_SYMLINKS_ALLOWED);
    }

    public static LevelStorageSource createDefault(Path path) {
        DirectoryValidator directoryvalidator = LevelStorageSource.parseValidator(path.resolve(ALLOWED_SYMLINKS_CONFIG_NAME));
        return new LevelStorageSource(path, path.resolve("../backups"), directoryvalidator, DataFixers.getDataFixer());
    }

    public static WorldDataConfiguration readDataConfig(Dynamic<?> dynamic) {
        DataResult dataresult = WorldDataConfiguration.CODEC.parse(dynamic);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(WorldDataConfiguration.DEFAULT);
    }

    public static WorldLoader.PackConfig getPackConfig(Dynamic<?> dynamic, PackRepository resourcepackrepository, boolean flag) {
        return new WorldLoader.PackConfig(resourcepackrepository, LevelStorageSource.readDataConfig(dynamic), flag, false);
    }

    public static LevelDataAndDimensions getLevelDataAndDimensions(Dynamic<?> dynamic, WorldDataConfiguration worlddataconfiguration, Registry<LevelStem> iregistry, HolderLookup.Provider holderlookup_a) {
        Dynamic<?> dynamic1 = RegistryOps.injectRegistryContext(dynamic, holderlookup_a);
        Dynamic dynamic2 = dynamic1.get("WorldGenSettings").orElseEmptyMap();
        WorldGenSettings generatorsettings = (WorldGenSettings)WorldGenSettings.CODEC.parse(dynamic2).getOrThrow();
        LevelSettings worldsettings = LevelSettings.parse(dynamic1, worlddataconfiguration);
        WorldDimensions.Complete worlddimensions_b = generatorsettings.dimensions().bake(iregistry);
        Lifecycle lifecycle = worlddimensions_b.lifecycle().add(holderlookup_a.allRegistriesLifecycle());
        PrimaryLevelData worlddataserver = PrimaryLevelData.parse(dynamic1, worldsettings, worlddimensions_b.specialWorldProperty(), generatorsettings.options(), lifecycle);
        worlddataserver.pdc = (Tag)dynamic1.getElement("BukkitValues", null);
        return new LevelDataAndDimensions(worlddataserver, worlddimensions_b);
    }

    public String getName() {
        return "Anvil";
    }

    public LevelCandidates findLevelCandidates() throws LevelStorageException {
        LevelCandidates levelCandidates;
        block9: {
            if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
                throw new LevelStorageException(Component.translatable("selectWorld.load_folder_access"));
            }
            Stream<Path> stream = Files.list(this.baseDir);
            try {
                List<LevelDirectory> list = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(LevelDirectory::new).filter(convertable_b -> Files.isRegularFile(convertable_b.dataFile(), new LinkOption[0]) || Files.isRegularFile(convertable_b.oldDataFile(), new LinkOption[0])).toList();
                levelCandidates = new LevelCandidates(list);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioexception) {
                    throw new LevelStorageException(Component.translatable("selectWorld.load_folder_access"));
                }
            }
            stream.close();
        }
        return levelCandidates;
    }

    public CompletableFuture<List<LevelSummary>> loadLevelSummaries(LevelCandidates convertable_a) {
        ArrayList<CompletableFuture<LevelSummary>> list = new ArrayList<CompletableFuture<LevelSummary>>(convertable_a.levels.size());
        for (LevelDirectory convertable_b : convertable_a.levels) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean flag;
                try {
                    flag = DirectoryLock.isLocked(convertable_b.path());
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to read {} lock", (Object)convertable_b.path(), (Object)exception);
                    return null;
                }
                try {
                    return this.readLevelSummary(convertable_b, flag);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    MemoryReserve.release();
                    String s = "Ran out of memory trying to read summary of world folder \"" + convertable_b.directoryName() + "\"";
                    LOGGER.error(LogUtils.FATAL_MARKER, s);
                    OutOfMemoryError outofmemoryerror1 = new OutOfMemoryError("Ran out of memory reading level data");
                    outofmemoryerror1.initCause(outofmemoryerror);
                    CrashReport crashreport = CrashReport.forThrowable(outofmemoryerror1, s);
                    CrashReportCategory crashreportsystemdetails = crashreport.addCategory("World details");
                    crashreportsystemdetails.setDetail("Folder Name", convertable_b.directoryName());
                    try {
                        long i = Files.size(convertable_b.dataFile());
                        crashreportsystemdetails.setDetail("level.dat size", i);
                    }
                    catch (IOException ioexception) {
                        crashreportsystemdetails.setDetailError("level.dat size", ioexception);
                    }
                    throw new ReportedException(crashreport);
                }
            }, Util.backgroundExecutor().forName("loadLevelSummaries")));
        }
        return Util.sequenceFailFastAndCancel(list).thenApply(list1 -> list1.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int getStorageVersion() {
        return 19133;
    }

    static CompoundTag readLevelDataTagRaw(Path path) throws IOException {
        return NbtIo.readCompressed(path, NbtAccounter.uncompressedQuota());
    }

    static Dynamic<?> readLevelDataTagFixed(Path path, DataFixer datafixer) throws IOException {
        CompoundTag nbttagcompound = LevelStorageSource.readLevelDataTagRaw(path);
        CompoundTag nbttagcompound1 = nbttagcompound.getCompoundOrEmpty(TAG_DATA);
        int i = NbtUtils.getDataVersion(nbttagcompound1);
        Dynamic dynamic = DataFixTypes.LEVEL.updateToCurrentVersion(datafixer, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbttagcompound1), i);
        dynamic = dynamic.update("Player", dynamic1 -> DataFixTypes.PLAYER.updateToCurrentVersion(datafixer, dynamic1, i));
        dynamic = dynamic.update("WorldGenSettings", dynamic1 -> DataFixTypes.WORLD_GEN_SETTINGS.updateToCurrentVersion(datafixer, dynamic1, i));
        return dynamic;
    }

    private LevelSummary readLevelSummary(LevelDirectory convertable_b, boolean flag) {
        Path path = convertable_b.dataFile();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> list;
                if (Files.isSymbolicLink(path) && !(list = this.worldDirValidator.validateSymlink(path)).isEmpty()) {
                    LOGGER.warn("{}", (Object)ContentValidationException.getMessage(path, list));
                    return new LevelSummary.SymlinkLevelSummary(convertable_b.directoryName(), convertable_b.iconFile());
                }
                Tag nbtbase = LevelStorageSource.readLightweightData(path);
                if (nbtbase instanceof CompoundTag) {
                    CompoundTag nbttagcompound = (CompoundTag)nbtbase;
                    CompoundTag nbttagcompound1 = nbttagcompound.getCompoundOrEmpty(TAG_DATA);
                    int i = NbtUtils.getDataVersion(nbttagcompound1);
                    Dynamic dynamic = DataFixTypes.LEVEL_SUMMARY.updateToCurrentVersion(this.fixerUpper, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbttagcompound1), i);
                    return this.makeLevelSummary(dynamic, convertable_b, flag);
                }
                LOGGER.warn("Invalid root tag in {}", (Object)path);
            }
            catch (Exception exception) {
                LOGGER.error("Exception reading {}", (Object)path, (Object)exception);
            }
        }
        return new LevelSummary.CorruptedLevelSummary(convertable_b.directoryName(), convertable_b.iconFile(), LevelStorageSource.getFileModificationTime(convertable_b));
    }

    private static long getFileModificationTime(LevelDirectory convertable_b) {
        Instant instant = LevelStorageSource.getFileModificationTime(convertable_b.dataFile());
        if (instant == null) {
            instant = LevelStorageSource.getFileModificationTime(convertable_b.oldDataFile());
        }
        return instant == null ? -1L : instant.toEpochMilli();
    }

    static @Nullable Instant getFileModificationTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        }
        catch (IOException ioexception) {
            return null;
        }
    }

    LevelSummary makeLevelSummary(Dynamic<?> dynamic, LevelDirectory convertable_b, boolean flag) {
        LevelVersion levelversion = LevelVersion.parse(dynamic);
        int i = levelversion.levelDataVersion();
        if (i != 19132 && i != 19133) {
            throw new NbtFormatException("Unknown data version: " + Integer.toHexString(i));
        }
        boolean flag1 = i != this.getStorageVersion();
        Path path = convertable_b.iconFile();
        WorldDataConfiguration worlddataconfiguration = LevelStorageSource.readDataConfig(dynamic);
        LevelSettings worldsettings = LevelSettings.parse(dynamic, worlddataconfiguration);
        FeatureFlagSet featureflagset = LevelStorageSource.parseFeatureFlagsFromSummary(dynamic);
        boolean flag2 = FeatureFlags.isExperimental(featureflagset);
        return new LevelSummary(worldsettings, levelversion, convertable_b.directoryName(), flag1, flag, flag2, path);
    }

    private static FeatureFlagSet parseFeatureFlagsFromSummary(Dynamic<?> dynamic) {
        Set<Identifier> set = dynamic.get("enabled_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().map(Identifier::tryParse).stream()).collect(Collectors.toSet());
        return FeatureFlags.REGISTRY.fromNames(set, minecraftkey -> {});
    }

    private static @Nullable Tag readLightweightData(Path path) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector(TAG_DATA, CompoundTag.TYPE, "Player"), new FieldSelector(TAG_DATA, CompoundTag.TYPE, "WorldGenSettings"));
        NbtIo.parseCompressed(path, (StreamTagVisitor)skipfields, NbtAccounter.uncompressedQuota());
        return skipfields.getResult();
    }

    public boolean isNewLevelIdAcceptable(String s) {
        try {
            Path path = this.getLevelPath(s);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean levelExists(String s) {
        try {
            return Files.isDirectory(this.getLevelPath(s), new LinkOption[0]);
        }
        catch (InvalidPathException invalidpathexception) {
            return false;
        }
    }

    public Path getLevelPath(String s) {
        return this.baseDir.resolve(s);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBackupPath() {
        return this.backupDir;
    }

    public LevelStorageAccess validateAndCreateAccess(String s, ResourceKey<LevelStem> dimensionType) throws IOException, ContentValidationException {
        Path path = this.getLevelPath(s);
        List<ForbiddenSymlinkInfo> list = this.worldDirValidator.validateDirectory(path, true);
        if (!list.isEmpty()) {
            throw new ContentValidationException(path, list);
        }
        return new LevelStorageAccess(s, path, dimensionType);
    }

    public LevelStorageAccess createAccess(String s, ResourceKey<LevelStem> dimensionType) throws IOException {
        Path path = this.getLevelPath(s);
        return new LevelStorageAccess(s, path, dimensionType);
    }

    public DirectoryValidator getWorldDirValidator() {
        return this.worldDirValidator;
    }

    public static Path getStorageFolder(Path path, ResourceKey<LevelStem> dimensionType) {
        if (dimensionType == LevelStem.OVERWORLD) {
            return path;
        }
        if (dimensionType == LevelStem.NETHER) {
            return path.resolve("DIM-1");
        }
        if (dimensionType == LevelStem.END) {
            return path.resolve("DIM1");
        }
        return path.resolve("dimensions").resolve(dimensionType.identifier().getNamespace()).resolve(dimensionType.identifier().getPath());
    }

    public record LevelCandidates(List<LevelDirectory> levels) implements Iterable<LevelDirectory>
    {
        public boolean isEmpty() {
            return this.levels.isEmpty();
        }

        @Override
        public Iterator<LevelDirectory> iterator() {
            return this.levels.iterator();
        }
    }

    public record LevelDirectory(Path path) {
        public String directoryName() {
            return this.path.getFileName().toString();
        }

        public Path dataFile() {
            return this.resourcePath(LevelResource.LEVEL_DATA_FILE);
        }

        public Path oldDataFile() {
            return this.resourcePath(LevelResource.OLD_LEVEL_DATA_FILE);
        }

        public Path corruptedDataFile(ZonedDateTime zoneddatetime) {
            Path path = this.path;
            String s = LevelResource.LEVEL_DATA_FILE.getId();
            return path.resolve(s + "_corrupted_" + zoneddatetime.format(FileNameDateFormatter.FORMATTER));
        }

        public Path rawDataFile(ZonedDateTime zoneddatetime) {
            Path path = this.path;
            String s = LevelResource.LEVEL_DATA_FILE.getId();
            return path.resolve(s + "_raw_" + zoneddatetime.format(FileNameDateFormatter.FORMATTER));
        }

        public Path iconFile() {
            return this.resourcePath(LevelResource.ICON_FILE);
        }

        public Path lockFile() {
            return this.resourcePath(LevelResource.LOCK_FILE);
        }

        public Path resourcePath(LevelResource savedfile) {
            return this.path.resolve(savedfile.getId());
        }
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock lock;
        public final LevelDirectory levelDirectory;
        private final String levelId;
        private final Map<LevelResource, Path> resources = Maps.newHashMap();
        public final ResourceKey<LevelStem> dimensionType;

        LevelStorageAccess(String s, Path path, ResourceKey<LevelStem> dimensionType) throws IOException {
            this.dimensionType = dimensionType;
            this.levelId = s;
            this.levelDirectory = new LevelDirectory(path);
            this.lock = DirectoryLock.create(path);
        }

        public long estimateDiskSpace() {
            try {
                return Files.getFileStore(this.levelDirectory.path).getUsableSpace();
            }
            catch (Exception exception) {
                return Long.MAX_VALUE;
            }
        }

        public boolean checkForLowDiskSpace() {
            return this.estimateDiskSpace() < 0x4000000L;
        }

        public void safeClose() {
            try {
                this.close();
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to unlock access to level {}", (Object)this.getLevelId(), (Object)ioexception);
            }
        }

        public LevelStorageSource parent() {
            return LevelStorageSource.this;
        }

        public LevelDirectory getLevelDirectory() {
            return this.levelDirectory;
        }

        public String getLevelId() {
            return this.levelId;
        }

        public Path getLevelPath(LevelResource savedfile) {
            Map<LevelResource, Path> map = this.resources;
            LevelDirectory convertable_b = this.levelDirectory;
            Objects.requireNonNull(this.levelDirectory);
            return map.computeIfAbsent(savedfile, convertable_b::resourcePath);
        }

        public Path getDimensionPath(ResourceKey<Level> resourcekey) {
            return LevelStorageSource.getStorageFolder(this.levelDirectory.path(), this.dimensionType);
        }

        private void checkLock() {
            if (!this.lock.isValid()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage createPlayerStorage() {
            this.checkLock();
            return new PlayerDataStorage(this, LevelStorageSource.this.fixerUpper);
        }

        public LevelSummary getSummary(Dynamic<?> dynamic) {
            this.checkLock();
            return LevelStorageSource.this.makeLevelSummary(dynamic, this.levelDirectory, false);
        }

        public Dynamic<?> getDataTag() throws IOException {
            return this.getDataTag(false);
        }

        public Dynamic<?> getDataTagFallback() throws IOException {
            return this.getDataTag(true);
        }

        private Dynamic<?> getDataTag(boolean flag) throws IOException {
            this.checkLock();
            return LevelStorageSource.readLevelDataTagFixed(flag ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile(), LevelStorageSource.this.fixerUpper);
        }

        public void saveDataTag(RegistryAccess iregistrycustom, WorldData savedata) {
            this.saveDataTag(iregistrycustom, savedata, null);
        }

        public void saveDataTag(RegistryAccess iregistrycustom, WorldData savedata, @Nullable CompoundTag nbttagcompound) {
            CompoundTag nbttagcompound1 = savedata.createTag(iregistrycustom, nbttagcompound);
            CompoundTag nbttagcompound2 = new CompoundTag();
            nbttagcompound2.put(LevelStorageSource.TAG_DATA, nbttagcompound1);
            this.saveLevelData(nbttagcompound2);
        }

        private void saveLevelData(CompoundTag nbttagcompound) {
            Path path = this.levelDirectory.path();
            try {
                Path path1 = Files.createTempFile(path, "level", ".dat", new FileAttribute[0]);
                NbtIo.writeCompressed(nbttagcompound, path1);
                Path path2 = this.levelDirectory.oldDataFile();
                Path path3 = this.levelDirectory.dataFile();
                Util.safeReplaceFile(path3, path1, path2);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to save level {}", (Object)path, (Object)exception);
            }
        }

        public Optional<Path> getIconFile() {
            return !this.lock.isValid() ? Optional.empty() : Optional.of(this.levelDirectory.iconFile());
        }

        public void deleteLevel() throws IOException {
            this.checkLock();
            final Path path = this.levelDirectory.lockFile();
            LOGGER.info("Deleting level {}", (Object)this.levelId);
            for (int i = 1; i <= 5; ++i) {
                LOGGER.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path1, BasicFileAttributes basicfileattributes) throws IOException {
                            if (!path1.equals(path)) {
                                LOGGER.debug("Deleting {}", (Object)path1);
                                Files.delete(path1);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path path1, @Nullable IOException ioexception) throws IOException {
                            if (ioexception != null) {
                                throw ioexception;
                            }
                            if (path1.equals(LevelStorageAccess.this.levelDirectory.path())) {
                                LevelStorageAccess.this.lock.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(path1);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i >= 5) {
                        throw ioexception;
                    }
                    LOGGER.warn("Failed to delete {}", (Object)this.levelDirectory.path(), (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void renameLevel(String s) throws IOException {
            this.modifyLevelDataWithoutDatafix(nbttagcompound -> nbttagcompound.putString("LevelName", s.trim()));
        }

        public void renameAndDropPlayer(String s) throws IOException {
            this.modifyLevelDataWithoutDatafix(nbttagcompound -> {
                nbttagcompound.putString("LevelName", s.trim());
                nbttagcompound.remove("Player");
            });
        }

        private void modifyLevelDataWithoutDatafix(Consumer<CompoundTag> consumer) throws IOException {
            this.checkLock();
            CompoundTag nbttagcompound = LevelStorageSource.readLevelDataTagRaw(this.levelDirectory.dataFile());
            consumer.accept(nbttagcompound.getCompoundOrEmpty(LevelStorageSource.TAG_DATA));
            this.saveLevelData(nbttagcompound);
        }

        public long makeWorldBackup() throws IOException {
            this.checkLock();
            String s = FileNameDateFormatter.FORMATTER.format(ZonedDateTime.now());
            String s1 = s + "_" + this.levelId;
            Path path = LevelStorageSource.this.getBackupPath();
            try {
                FileUtil.createDirectoriesSafe(path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtil.findAvailableName(path, s1, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.levelId, new String[0]);
                Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path3, BasicFileAttributes basicfileattributes) throws IOException {
                        if (path3.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s2 = path2.resolve(LevelStorageAccess.this.levelDirectory.path().relativize(path3)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s2);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)path3.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        public boolean hasWorldData() {
            return Files.exists(this.levelDirectory.dataFile(), new LinkOption[0]) || Files.exists(this.levelDirectory.oldDataFile(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.lock.close();
        }

        public boolean restoreLevelDataFromOld() {
            return Util.safeReplaceOrMoveFile(this.levelDirectory.dataFile(), this.levelDirectory.oldDataFile(), this.levelDirectory.corruptedDataFile(ZonedDateTime.now()), true);
        }

        public @Nullable Instant getFileModificationTime(boolean flag) {
            return LevelStorageSource.getFileModificationTime(flag ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile());
        }
    }
}

