/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContextArg;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jspecify.annotations.Nullable;

public class LootContext {
    private final LootParams params;
    private final RandomSource random;
    private final HolderGetter.Provider lootDataResolver;
    private final Set<VisitedEntry<?>> visitedElements = Sets.newLinkedHashSet();

    LootContext(LootParams var0, RandomSource var1, HolderGetter.Provider var2) {
        this.params = var0;
        this.random = var1;
        this.lootDataResolver = var2;
    }

    public boolean hasParameter(ContextKey<?> var0) {
        return this.params.contextMap().has(var0);
    }

    public <T> T getParameter(ContextKey<T> var0) {
        return this.params.contextMap().getOrThrow(var0);
    }

    public <T> @Nullable T getOptionalParameter(ContextKey<T> var0) {
        return this.params.contextMap().getOptional(var0);
    }

    public void addDynamicDrops(Identifier var0, Consumer<ItemStack> var1) {
        this.params.addDynamicDrops(var0, var1);
    }

    public boolean hasVisitedElement(VisitedEntry<?> var0) {
        return this.visitedElements.contains(var0);
    }

    public boolean pushVisitedElement(VisitedEntry<?> var0) {
        return this.visitedElements.add(var0);
    }

    public void popVisitedElement(VisitedEntry<?> var0) {
        this.visitedElements.remove(var0);
    }

    public HolderGetter.Provider getResolver() {
        return this.lootDataResolver;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public float getLuck() {
        return this.params.getLuck();
    }

    public ServerLevel getLevel() {
        return this.params.getLevel();
    }

    public static VisitedEntry<LootTable> createVisitedEntry(LootTable var0) {
        return new VisitedEntry<LootTable>(LootDataType.TABLE, var0);
    }

    public static VisitedEntry<LootItemCondition> createVisitedEntry(LootItemCondition var0) {
        return new VisitedEntry<LootItemCondition>(LootDataType.PREDICATE, var0);
    }

    public static VisitedEntry<LootItemFunction> createVisitedEntry(LootItemFunction var0) {
        return new VisitedEntry<LootItemFunction>(LootDataType.MODIFIER, var0);
    }

    public record VisitedEntry<T>(LootDataType<T> type, T value) {
    }

    public static enum ItemStackTarget implements StringRepresentable,
    LootContextArg.SimpleGetter<ItemStack>
    {
        TOOL("tool", LootContextParams.TOOL);

        private final String name;
        private final ContextKey<? extends ItemStack> param;

        private ItemStackTarget(String var2, ContextKey var3) {
            this.name = var2;
            this.param = var3;
        }

        @Override
        public ContextKey<? extends ItemStack> contextParam() {
            return this.param;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum BlockEntityTarget implements StringRepresentable,
    LootContextArg.SimpleGetter<BlockEntity>
    {
        BLOCK_ENTITY("block_entity", LootContextParams.BLOCK_ENTITY);

        private final String name;
        private final ContextKey<? extends BlockEntity> param;

        private BlockEntityTarget(String var2, ContextKey var3) {
            this.name = var2;
            this.param = var3;
        }

        @Override
        public ContextKey<? extends BlockEntity> contextParam() {
            return this.param;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum EntityTarget implements StringRepresentable,
    LootContextArg.SimpleGetter<Entity>
    {
        THIS("this", LootContextParams.THIS_ENTITY),
        ATTACKER("attacker", LootContextParams.ATTACKING_ENTITY),
        DIRECT_ATTACKER("direct_attacker", LootContextParams.DIRECT_ATTACKING_ENTITY),
        ATTACKING_PLAYER("attacking_player", LootContextParams.LAST_DAMAGE_PLAYER),
        TARGET_ENTITY("target_entity", LootContextParams.TARGET_ENTITY),
        INTERACTING_ENTITY("interacting_entity", LootContextParams.INTERACTING_ENTITY);

        public static final StringRepresentable.EnumCodec<EntityTarget> CODEC;
        private final String name;
        private final ContextKey<? extends Entity> param;

        private EntityTarget(String var2, ContextKey var3) {
            this.name = var2;
            this.param = var3;
        }

        @Override
        public ContextKey<? extends Entity> contextParam() {
            return this.param;
        }

        public static EntityTarget getByName(String var0) {
            EntityTarget var1 = CODEC.byName(var0);
            if (var1 != null) {
                return var1;
            }
            throw new IllegalArgumentException("Invalid entity target " + var0);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(EntityTarget::values);
        }
    }

    public static class Builder {
        private final LootParams params;
        private @Nullable RandomSource random;

        public Builder(LootParams var0) {
            this.params = var0;
        }

        public Builder withOptionalRandomSeed(long var0) {
            if (var0 != 0L) {
                this.random = RandomSource.create(var0);
            }
            return this;
        }

        public Builder withOptionalRandomSource(RandomSource var0) {
            this.random = var0;
            return this;
        }

        public ServerLevel getLevel() {
            return this.params.getLevel();
        }

        public LootContext create(Optional<Identifier> var0) {
            ServerLevel var1 = this.getLevel();
            MinecraftServer var2 = var1.getServer();
            RandomSource var3 = Optional.ofNullable(this.random).or(() -> var0.map(var1::getRandomSequence)).orElseGet(var1::getRandom);
            return new LootContext(this.params, var3, var2.reloadableRegistries().lookup());
        }
    }
}

