/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jspecify.annotations.Nullable;

public interface LootContextArg<R> {
    public static final Codec<LootContextArg<Object>> ENTITY_OR_BLOCK = LootContextArg.createArgCodec(var0 -> var0.anyOf(LootContext.EntityTarget.values()).anyOf(LootContext.BlockEntityTarget.values()));

    public @Nullable R get(LootContext var1);

    public ContextKey<?> contextParam();

    public static <U> LootContextArg<U> cast(LootContextArg<? extends U> var0) {
        return var0;
    }

    public static <R> Codec<LootContextArg<R>> createArgCodec(UnaryOperator<ArgCodecBuilder<R>> var0) {
        return ((ArgCodecBuilder)var0.apply(new ArgCodecBuilder())).build();
    }

    public static final class ArgCodecBuilder<R> {
        private final ExtraCodecs.LateBoundIdMapper<String, LootContextArg<R>> sources = new ExtraCodecs.LateBoundIdMapper();

        ArgCodecBuilder() {
        }

        public <T> ArgCodecBuilder<R> anyOf(T[] var0, Function<T, String> var1, Function<T, ? extends LootContextArg<R>> var2) {
            for (T var6 : var0) {
                this.sources.put(var1.apply(var6), var2.apply(var6));
            }
            return this;
        }

        public <T extends StringRepresentable> ArgCodecBuilder<R> anyOf(T[] var0, Function<T, ? extends LootContextArg<R>> var1) {
            return this.anyOf(var0, StringRepresentable::getSerializedName, var1);
        }

        public <T extends StringRepresentable & LootContextArg<? extends R>> ArgCodecBuilder<R> anyOf(T[] var02) {
            return this.anyOf((StringRepresentable[])var02, var0 -> LootContextArg.cast((LootContextArg)var0));
        }

        public ArgCodecBuilder<R> anyEntity(Function<? super ContextKey<? extends Entity>, ? extends LootContextArg<R>> var0) {
            return this.anyOf(LootContext.EntityTarget.values(), var1 -> (LootContextArg)var0.apply(var1.contextParam()));
        }

        public ArgCodecBuilder<R> anyBlockEntity(Function<? super ContextKey<? extends BlockEntity>, ? extends LootContextArg<R>> var0) {
            return this.anyOf(LootContext.BlockEntityTarget.values(), var1 -> (LootContextArg)var0.apply(var1.contextParam()));
        }

        public ArgCodecBuilder<R> anyItemStack(Function<? super ContextKey<? extends ItemStack>, ? extends LootContextArg<R>> var0) {
            return this.anyOf(LootContext.ItemStackTarget.values(), var1 -> (LootContextArg)var0.apply(var1.contextParam()));
        }

        Codec<LootContextArg<R>> build() {
            return this.sources.codec((Codec<String>)Codec.STRING);
        }
    }

    public static interface SimpleGetter<T>
    extends LootContextArg<T> {
        @Override
        public ContextKey<? extends T> contextParam();

        @Override
        default public @Nullable T get(LootContext var0) {
            return var0.getOptionalParameter(this.contextParam());
        }
    }

    public static interface Getter<T, R>
    extends LootContextArg<R> {
        public @Nullable R get(T var1);

        @Override
        public ContextKey<? extends T> contextParam();

        @Override
        default public @Nullable R get(LootContext var0) {
            T var1 = var0.getOptionalParameter(this.contextParam());
            return var1 != null ? (R)this.get(var1) : null;
        }
    }
}

