/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SequentialEntry
extends CompositeEntryBase {
    public static final MapCodec<SequentialEntry> CODEC = SequentialEntry.createCodec(SequentialEntry::new);

    SequentialEntry(List<LootPoolEntryContainer> var0, List<LootItemCondition> var1) {
        super(var0, var1);
    }

    @Override
    public LootPoolEntryType getType() {
        return LootPoolEntries.SEQUENCE;
    }

    @Override
    protected ComposableEntryContainer compose(List<? extends ComposableEntryContainer> var0) {
        return switch (var0.size()) {
            case 0 -> ALWAYS_TRUE;
            case 1 -> var0.get(0);
            case 2 -> var0.get(0).and(var0.get(1));
            default -> (var1, var2) -> {
                for (ComposableEntryContainer var4 : var0) {
                    if (var4.expand(var1, var2)) continue;
                    return false;
                }
                return true;
            };
        };
    }

    public static Builder sequential(LootPoolEntryContainer.Builder<?> ... var0) {
        return new Builder(var0);
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();

        public Builder(LootPoolEntryContainer.Builder<?> ... var0) {
            for (LootPoolEntryContainer.Builder<?> var4 : var0) {
                this.entries.add((Object)var4.build());
            }
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder then(LootPoolEntryContainer.Builder<?> var0) {
            this.entries.add((Object)var0.build());
            return this;
        }

        @Override
        public LootPoolEntryContainer build() {
            return new SequentialEntry((List<LootPoolEntryContainer>)this.entries.build(), this.getConditions());
        }

        @Override
        protected /* synthetic */ LootPoolEntryContainer.Builder getThis() {
            return this.getThis();
        }
    }
}

