/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyBlockState
extends LootItemConditionalFunction {
    public static final MapCodec<CopyBlockState> CODEC = RecordCodecBuilder.mapCodec(var02 -> CopyBlockState.commonFields(var02).and(var02.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").forGetter(var0 -> var0.block), (App)Codec.STRING.listOf().fieldOf("properties").forGetter(var0 -> var0.properties.stream().map(Property::getName).toList()))).apply((Applicative)var02, CopyBlockState::new));
    private final Holder<Block> block;
    private final Set<Property<?>> properties;

    CopyBlockState(List<LootItemCondition> var0, Holder<Block> var1, Set<Property<?>> var2) {
        super(var0);
        this.block = var1;
        this.properties = var2;
    }

    private CopyBlockState(List<LootItemCondition> var0, Holder<Block> var1, List<String> var2) {
        this(var0, var1, var2.stream().map(var1.value().getStateDefinition()::getProperty).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public LootItemFunctionType<CopyBlockState> getType() {
        return LootItemFunctions.COPY_STATE;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.BLOCK_STATE);
    }

    @Override
    protected ItemStack run(ItemStack var0, LootContext var12) {
        BlockState var2 = var12.getOptionalParameter(LootContextParams.BLOCK_STATE);
        if (var2 != null) {
            var0.update(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY, var1 -> {
                for (Property<?> var3 : this.properties) {
                    if (!var2.hasProperty(var3)) continue;
                    var1 = var1.with(var3, var2);
                }
                return var1;
            });
        }
        return var0;
    }

    public static Builder copyState(Block var0) {
        return new Builder(var0);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Holder<Block> block;
        private final ImmutableSet.Builder<Property<?>> properties = ImmutableSet.builder();

        Builder(Block var0) {
            this.block = var0.builtInRegistryHolder();
        }

        public Builder copy(Property<?> var0) {
            if (!this.block.value().getStateDefinition().getProperties().contains(var0)) {
                throw new IllegalStateException("Property " + String.valueOf(var0) + " is not present on block " + String.valueOf(this.block));
            }
            this.properties.add(var0);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyBlockState(this.getConditions(), this.block, (Set<Property<?>>)this.properties.build());
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

