/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jspecify.annotations.Nullable;

public class CopyCustomDataFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CopyCustomDataFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> CopyCustomDataFunction.commonFields(var02).and(var02.group((App)NbtProviders.CODEC.fieldOf("source").forGetter(var0 -> var0.source), (App)CopyOperation.CODEC.listOf().fieldOf("ops").forGetter(var0 -> var0.operations))).apply((Applicative)var02, CopyCustomDataFunction::new));
    private final NbtProvider source;
    private final List<CopyOperation> operations;

    CopyCustomDataFunction(List<LootItemCondition> var0, NbtProvider var1, List<CopyOperation> var2) {
        super(var0);
        this.source = var1;
        this.operations = List.copyOf(var2);
    }

    public LootItemFunctionType<CopyCustomDataFunction> getType() {
        return LootItemFunctions.COPY_CUSTOM_DATA;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        Tag var22 = this.source.get(var1);
        if (var22 == null) {
            return var0;
        }
        @Nullable MutableObject var3 = new MutableObject();
        Supplier<Tag> var4 = () -> {
            if (var3.get() == null) {
                var3.setValue((Object)var0.getOrDefault(DataComponents.CUSTOM_DATA, CustomData.EMPTY).copyTag());
            }
            return (Tag)var3.get();
        };
        this.operations.forEach(var2 -> var2.apply(var4, var22));
        CompoundTag var5 = (CompoundTag)var3.get();
        if (var5 != null) {
            CustomData.set(DataComponents.CUSTOM_DATA, var0, var5);
        }
        return var0;
    }

    @Deprecated
    public static Builder copyData(NbtProvider var0) {
        return new Builder(var0);
    }

    public static Builder copyData(LootContext.EntityTarget var0) {
        return new Builder(ContextNbtProvider.forContextEntity(var0));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NbtProvider source;
        private final List<CopyOperation> ops = Lists.newArrayList();

        Builder(NbtProvider var0) {
            this.source = var0;
        }

        public Builder copy(String var0, String var1, MergeStrategy var2) {
            try {
                this.ops.add(new CopyOperation(NbtPathArgument.NbtPath.of(var0), NbtPathArgument.NbtPath.of(var1), var2));
            }
            catch (CommandSyntaxException var3) {
                throw new IllegalArgumentException(var3);
            }
            return this;
        }

        public Builder copy(String var0, String var1) {
            return this.copy(var0, var1, MergeStrategy.REPLACE);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyCustomDataFunction(this.getConditions(), this.source, this.ops);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }

    record CopyOperation(NbtPathArgument.NbtPath sourcePath, NbtPathArgument.NbtPath targetPath, MergeStrategy op) {
        public static final Codec<CopyOperation> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)NbtPathArgument.NbtPath.CODEC.fieldOf("source").forGetter(CopyOperation::sourcePath), (App)NbtPathArgument.NbtPath.CODEC.fieldOf("target").forGetter(CopyOperation::targetPath), (App)MergeStrategy.CODEC.fieldOf("op").forGetter(CopyOperation::op)).apply((Applicative)var0, CopyOperation::new));

        public void apply(Supplier<Tag> var0, Tag var1) {
            try {
                List<Tag> var2 = this.sourcePath.get(var1);
                if (!var2.isEmpty()) {
                    this.op.merge(var0.get(), this.targetPath, var2);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    public static enum MergeStrategy implements StringRepresentable
    {
        REPLACE("replace"){

            @Override
            public void merge(Tag var0, NbtPathArgument.NbtPath var1, List<Tag> var2) throws CommandSyntaxException {
                var1.set(var0, (Tag)Iterables.getLast(var2));
            }
        }
        ,
        APPEND("append"){

            @Override
            public void merge(Tag var0, NbtPathArgument.NbtPath var1, List<Tag> var2) throws CommandSyntaxException {
                List<Tag> var3 = var1.getOrCreate(var0, ListTag::new);
                var3.forEach(var12 -> {
                    if (var12 instanceof ListTag) {
                        var2.forEach(var1 -> ((ListTag)var12).add(var1.copy()));
                    }
                });
            }
        }
        ,
        MERGE("merge"){

            @Override
            public void merge(Tag var0, NbtPathArgument.NbtPath var1, List<Tag> var2) throws CommandSyntaxException {
                List<Tag> var3 = var1.getOrCreate(var0, CompoundTag::new);
                var3.forEach(var12 -> {
                    if (var12 instanceof CompoundTag) {
                        var2.forEach(var1 -> {
                            if (var1 instanceof CompoundTag) {
                                ((CompoundTag)var12).merge((CompoundTag)var1);
                            }
                        });
                    }
                });
            }
        };

        public static final Codec<MergeStrategy> CODEC;
        private final String name;

        public abstract void merge(Tag var1, NbtPathArgument.NbtPath var2, List<Tag> var3) throws CommandSyntaxException;

        MergeStrategy(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(MergeStrategy::values);
        }
    }
}

