/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class EnchantRandomlyFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<EnchantRandomlyFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> EnchantRandomlyFunction.commonFields(var02).and(var02.group((App)RegistryCodecs.homogeneousList(Registries.ENCHANTMENT).optionalFieldOf("options").forGetter(var0 -> var0.options), (App)Codec.BOOL.optionalFieldOf("only_compatible", (Object)true).forGetter(var0 -> var0.onlyCompatible))).apply((Applicative)var02, EnchantRandomlyFunction::new));
    private final Optional<HolderSet<Enchantment>> options;
    private final boolean onlyCompatible;

    EnchantRandomlyFunction(List<LootItemCondition> var0, Optional<HolderSet<Enchantment>> var1, boolean var2) {
        super(var0);
        this.options = var1;
        this.onlyCompatible = var2;
    }

    public LootItemFunctionType<EnchantRandomlyFunction> getType() {
        return LootItemFunctions.ENCHANT_RANDOMLY;
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        RandomSource var22 = var1.getRandom();
        boolean var3 = var0.is(Items.BOOK);
        boolean var4 = !var3 && this.onlyCompatible;
        Stream<Holder> var5 = this.options.map(HolderSet::stream).orElseGet(() -> var1.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).listElements().map(Function.identity())).filter(var2 -> !var4 || ((Enchantment)var2.value()).canEnchant(var0));
        List<Holder> var6 = var5.toList();
        Optional<Holder> var7 = Util.getRandomSafe(var6, var22);
        if (var7.isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)var0);
            return var0;
        }
        return EnchantRandomlyFunction.enchantItem(var0, var7.get(), var22);
    }

    private static ItemStack enchantItem(ItemStack var0, Holder<Enchantment> var1, RandomSource var2) {
        int var3 = Mth.nextInt(var2, var1.value().getMinLevel(), var1.value().getMaxLevel());
        if (var0.is(Items.BOOK)) {
            var0 = new ItemStack(Items.ENCHANTED_BOOK);
        }
        var0.enchant(var1, var3);
        return var0;
    }

    public static Builder randomEnchantment() {
        return new Builder();
    }

    public static Builder randomApplicableEnchantment(HolderLookup.Provider var0) {
        return EnchantRandomlyFunction.randomEnchantment().withOneOf(var0.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.ON_RANDOM_LOOT));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private Optional<HolderSet<Enchantment>> options = Optional.empty();
        private boolean onlyCompatible = true;

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEnchantment(Holder<Enchantment> var0) {
            this.options = Optional.of(HolderSet.direct(var0));
            return this;
        }

        public Builder withOneOf(HolderSet<Enchantment> var0) {
            this.options = Optional.of(var0);
            return this;
        }

        public Builder allowingIncompatibleEnchantments() {
            this.onlyCompatible = false;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new EnchantRandomlyFunction(this.getConditions(), this.options, this.onlyCompatible);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

