/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LimitCount
extends LootItemConditionalFunction {
    public static final MapCodec<LimitCount> CODEC = RecordCodecBuilder.mapCodec(var02 -> LimitCount.commonFields(var02).and((App)IntRange.CODEC.fieldOf("limit").forGetter(var0 -> var0.limiter)).apply((Applicative)var02, LimitCount::new));
    private final IntRange limiter;

    private LimitCount(List<LootItemCondition> var0, IntRange var1) {
        super(var0);
        this.limiter = var1;
    }

    public LootItemFunctionType<LimitCount> getType() {
        return LootItemFunctions.LIMIT_COUNT;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.limiter.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        int var2 = this.limiter.clamp(var1, var0.getCount());
        var0.setCount(var2);
        return var0;
    }

    public static LootItemConditionalFunction.Builder<?> limitCount(IntRange var0) {
        return LimitCount.simpleBuilder(var1 -> new LimitCount((List<LootItemCondition>)var1, var0));
    }
}

