/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class SetAttributesFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetAttributesFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetAttributesFunction.commonFields(var02).and(var02.group((App)Modifier.CODEC.listOf().fieldOf("modifiers").forGetter(var0 -> var0.modifiers), (App)Codec.BOOL.optionalFieldOf("replace", (Object)true).forGetter(var0 -> var0.replace))).apply((Applicative)var02, SetAttributesFunction::new));
    private final List<Modifier> modifiers;
    private final boolean replace;

    SetAttributesFunction(List<LootItemCondition> var0, List<Modifier> var1, boolean var2) {
        super(var0);
        this.modifiers = List.copyOf(var1);
        this.replace = var2;
    }

    public LootItemFunctionType<SetAttributesFunction> getType() {
        return LootItemFunctions.SET_ATTRIBUTES;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return (Set)this.modifiers.stream().flatMap(var0 -> var0.amount.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var12) {
        if (this.replace) {
            var0.set(DataComponents.ATTRIBUTE_MODIFIERS, this.updateModifiers(var12, ItemAttributeModifiers.EMPTY));
        } else {
            var0.update(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY, var1 -> this.updateModifiers(var12, (ItemAttributeModifiers)var1));
        }
        return var0;
    }

    private ItemAttributeModifiers updateModifiers(LootContext var0, ItemAttributeModifiers var1) {
        RandomSource var2 = var0.getRandom();
        for (Modifier var4 : this.modifiers) {
            EquipmentSlotGroup var5 = Util.getRandom(var4.slots, var2);
            var1 = var1.withModifierAdded(var4.attribute, new AttributeModifier(var4.id, var4.amount.getFloat(var0), var4.operation), var5);
        }
        return var1;
    }

    public static ModifierBuilder modifier(Identifier var0, Holder<Attribute> var1, AttributeModifier.Operation var2, NumberProvider var3) {
        return new ModifierBuilder(var0, var1, var2, var3);
    }

    public static Builder setAttributes() {
        return new Builder();
    }

    static final class Modifier
    extends Record {
        final Identifier id;
        final Holder<Attribute> attribute;
        final AttributeModifier.Operation operation;
        final NumberProvider amount;
        final List<EquipmentSlotGroup> slots;
        private static final Codec<List<EquipmentSlotGroup>> SLOTS_CODEC = ExtraCodecs.nonEmptyList(ExtraCodecs.compactListCodec(EquipmentSlotGroup.CODEC));
        public static final Codec<Modifier> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Identifier.CODEC.fieldOf("id").forGetter(Modifier::id), (App)Attribute.CODEC.fieldOf("attribute").forGetter(Modifier::attribute), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(Modifier::operation), (App)NumberProviders.CODEC.fieldOf("amount").forGetter(Modifier::amount), (App)SLOTS_CODEC.fieldOf("slot").forGetter(Modifier::slots)).apply((Applicative)var0, Modifier::new));

        Modifier(Identifier var0, Holder<Attribute> var1, AttributeModifier.Operation var2, NumberProvider var3, List<EquipmentSlotGroup> var4) {
            this.id = var0;
            this.attribute = var1;
            this.operation = var2;
            this.amount = var3;
            this.slots = var4;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Modifier.class, "id;attribute;operation;amount;slots", "id", "attribute", "operation", "amount", "slots"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Modifier.class, "id;attribute;operation;amount;slots", "id", "attribute", "operation", "amount", "slots"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Modifier.class, "id;attribute;operation;amount;slots", "id", "attribute", "operation", "amount", "slots"}, this, var0);
        }

        public Identifier id() {
            return this.id;
        }

        public Holder<Attribute> attribute() {
            return this.attribute;
        }

        public AttributeModifier.Operation operation() {
            return this.operation;
        }

        public NumberProvider amount() {
            return this.amount;
        }

        public List<EquipmentSlotGroup> slots() {
            return this.slots;
        }
    }

    public static class ModifierBuilder {
        private final Identifier id;
        private final Holder<Attribute> attribute;
        private final AttributeModifier.Operation operation;
        private final NumberProvider amount;
        private final Set<EquipmentSlotGroup> slots = EnumSet.noneOf(EquipmentSlotGroup.class);

        public ModifierBuilder(Identifier var0, Holder<Attribute> var1, AttributeModifier.Operation var2, NumberProvider var3) {
            this.id = var0;
            this.attribute = var1;
            this.operation = var2;
            this.amount = var3;
        }

        public ModifierBuilder forSlot(EquipmentSlotGroup var0) {
            this.slots.add(var0);
            return this;
        }

        public Modifier build() {
            return new Modifier(this.id, this.attribute, this.operation, this.amount, List.copyOf(this.slots));
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final boolean replace;
        private final List<Modifier> modifiers = Lists.newArrayList();

        public Builder(boolean var0) {
            this.replace = var0;
        }

        public Builder() {
            this(false);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withModifier(ModifierBuilder var0) {
            this.modifiers.add(var0.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetAttributesFunction(this.getConditions(), this.modifiers, this.replace);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

