/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetComponentsFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetComponentsFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetComponentsFunction.commonFields(var02).and((App)DataComponentPatch.CODEC.fieldOf("components").forGetter(var0 -> var0.components)).apply((Applicative)var02, SetComponentsFunction::new));
    private final DataComponentPatch components;

    private SetComponentsFunction(List<LootItemCondition> var0, DataComponentPatch var1) {
        super(var0);
        this.components = var1;
    }

    public LootItemFunctionType<SetComponentsFunction> getType() {
        return LootItemFunctions.SET_COMPONENTS;
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        var0.applyComponentsAndValidate(this.components);
        return var0;
    }

    public static <T> LootItemConditionalFunction.Builder<?> setComponent(DataComponentType<T> var0, T var1) {
        return SetComponentsFunction.simpleBuilder(var2 -> new SetComponentsFunction((List<LootItemCondition>)var2, DataComponentPatch.builder().set(var0, var1).build()));
    }
}

