/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulator;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulators;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetContainerContents
extends LootItemConditionalFunction {
    public static final MapCodec<SetContainerContents> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetContainerContents.commonFields(var02).and(var02.group((App)ContainerComponentManipulators.CODEC.fieldOf("component").forGetter(var0 -> var0.component), (App)LootPoolEntries.CODEC.listOf().fieldOf("entries").forGetter(var0 -> var0.entries))).apply((Applicative)var02, SetContainerContents::new));
    private final ContainerComponentManipulator<?> component;
    private final List<LootPoolEntryContainer> entries;

    SetContainerContents(List<LootItemCondition> var0, ContainerComponentManipulator<?> var1, List<LootPoolEntryContainer> var2) {
        super(var0);
        this.component = var1;
        this.entries = List.copyOf(var2);
    }

    public LootItemFunctionType<SetContainerContents> getType() {
        return LootItemFunctions.SET_CONTENTS;
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        if (var0.isEmpty()) {
            return var0;
        }
        Stream.Builder var2 = Stream.builder();
        this.entries.forEach(var22 -> var22.expand(var1, var2 -> var2.createItemStack(LootTable.createStackSplitter(var1.getLevel(), var2::add), var1)));
        this.component.setContents(var0, var2.build());
        return var0;
    }

    @Override
    public void validate(ValidationContext var0) {
        super.validate(var0);
        for (int var1 = 0; var1 < this.entries.size(); ++var1) {
            this.entries.get(var1).validate(var0.forChild(new ProblemReporter.IndexedFieldPathElement("entries", var1)));
        }
    }

    public static Builder setContents(ContainerComponentManipulator<?> var0) {
        return new Builder(var0);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();
        private final ContainerComponentManipulator<?> component;

        public Builder(ContainerComponentManipulator<?> var0) {
            this.component = var0;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEntry(LootPoolEntryContainer.Builder<?> var0) {
            this.entries.add((Object)var0.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetContainerContents(this.getConditions(), this.component, (List<LootPoolEntryContainer>)this.entries.build());
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

