/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class SetNameFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SetNameFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetNameFunction.commonFields(var02).and(var02.group((App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(var0 -> var0.name), (App)LootContext.EntityTarget.CODEC.optionalFieldOf("entity").forGetter(var0 -> var0.resolutionContext), (App)Target.CODEC.optionalFieldOf("target", (Object)Target.CUSTOM_NAME).forGetter(var0 -> var0.target))).apply((Applicative)var02, SetNameFunction::new));
    private final Optional<Component> name;
    private final Optional<LootContext.EntityTarget> resolutionContext;
    private final Target target;

    private SetNameFunction(List<LootItemCondition> var0, Optional<Component> var1, Optional<LootContext.EntityTarget> var2, Target var3) {
        super(var0);
        this.name = var1;
        this.resolutionContext = var2;
        this.target = var3;
    }

    public LootItemFunctionType<SetNameFunction> getType() {
        return LootItemFunctions.SET_NAME;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.resolutionContext.map(var0 -> Set.of(var0.contextParam())).orElse(Set.of());
    }

    public static UnaryOperator<Component> createResolver(LootContext var02, @Nullable LootContext.EntityTarget var1) {
        Entity var22;
        if (var1 != null && (var22 = var02.getOptionalParameter(var1.contextParam())) != null) {
            CommandSourceStack var3 = var22.createCommandSourceStackForNameResolution(var02.getLevel()).withPermission(LevelBasedPermissionSet.GAMEMASTER);
            return var2 -> {
                try {
                    return ComponentUtils.updateForEntity(var3, var2, var22, 0);
                }
                catch (CommandSyntaxException var3) {
                    LOGGER.warn("Failed to resolve text component", (Throwable)var3);
                    return var2;
                }
            };
        }
        return var0 -> var0;
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        this.name.ifPresent(var2 -> var0.set(this.target.component(), (Component)SetNameFunction.createResolver(var1, this.resolutionContext.orElse(null)).apply((Component)var2)));
        return var0;
    }

    public static LootItemConditionalFunction.Builder<?> setName(Component var0, Target var1) {
        return SetNameFunction.simpleBuilder(var2 -> new SetNameFunction((List<LootItemCondition>)var2, Optional.of(var0), Optional.empty(), var1));
    }

    public static LootItemConditionalFunction.Builder<?> setName(Component var0, Target var1, LootContext.EntityTarget var2) {
        return SetNameFunction.simpleBuilder(var3 -> new SetNameFunction((List<LootItemCondition>)var3, Optional.of(var0), Optional.of(var2), var1));
    }

    public static enum Target implements StringRepresentable
    {
        CUSTOM_NAME("custom_name"),
        ITEM_NAME("item_name");

        public static final Codec<Target> CODEC;
        private final String name;

        private Target(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public DataComponentType<Component> component() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> DataComponents.ITEM_NAME;
                case 0 -> DataComponents.CUSTOM_NAME;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(Target::values);
        }
    }
}

