/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Util;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class SetStewEffectFunction
extends LootItemConditionalFunction {
    private static final Codec<List<EffectEntry>> EFFECTS_LIST = EffectEntry.CODEC.listOf().validate(var0 -> {
        ObjectOpenHashSet var1 = new ObjectOpenHashSet();
        for (EffectEntry var3 : var0) {
            if (var1.add(var3.effect())) continue;
            return DataResult.error(() -> "Encountered duplicate mob effect: '" + String.valueOf(var3.effect()) + "'");
        }
        return DataResult.success((Object)var0);
    });
    public static final MapCodec<SetStewEffectFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetStewEffectFunction.commonFields(var02).and((App)EFFECTS_LIST.optionalFieldOf("effects", List.of()).forGetter(var0 -> var0.effects)).apply((Applicative)var02, SetStewEffectFunction::new));
    private final List<EffectEntry> effects;

    SetStewEffectFunction(List<LootItemCondition> var0, List<EffectEntry> var1) {
        super(var0);
        this.effects = var1;
    }

    public LootItemFunctionType<SetStewEffectFunction> getType() {
        return LootItemFunctions.SET_STEW_EFFECT;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return (Set)this.effects.stream().flatMap(var0 -> var0.duration().getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        if (!var0.is(Items.SUSPICIOUS_STEW) || this.effects.isEmpty()) {
            return var0;
        }
        EffectEntry var2 = Util.getRandom(this.effects, var1.getRandom());
        Holder<MobEffect> var3 = var2.effect();
        int var4 = var2.duration().getInt(var1);
        if (!var3.value().isInstantenous()) {
            var4 *= 20;
        }
        SuspiciousStewEffects.Entry var5 = new SuspiciousStewEffects.Entry(var3, var4);
        var0.update(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY, var5, SuspiciousStewEffects::withEffectAdded);
        return var0;
    }

    public static Builder stewEffect() {
        return new Builder();
    }

    record EffectEntry(Holder<MobEffect> effect, NumberProvider duration) {
        public static final Codec<EffectEntry> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MobEffect.CODEC.fieldOf("type").forGetter(EffectEntry::effect), (App)NumberProviders.CODEC.fieldOf("duration").forGetter(EffectEntry::duration)).apply((Applicative)var0, EffectEntry::new));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final ImmutableList.Builder<EffectEntry> effects = ImmutableList.builder();

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEffect(Holder<MobEffect> var0, NumberProvider var1) {
            this.effects.add((Object)new EffectEntry(var0, var1));
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetStewEffectFunction(this.getConditions(), (List<EffectEntry>)this.effects.build());
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

