/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;

public class Vec2 {
    public static final Vec2 ZERO = new Vec2(0.0f, 0.0f);
    public static final Vec2 ONE = new Vec2(1.0f, 1.0f);
    public static final Vec2 UNIT_X = new Vec2(1.0f, 0.0f);
    public static final Vec2 NEG_UNIT_X = new Vec2(-1.0f, 0.0f);
    public static final Vec2 UNIT_Y = new Vec2(0.0f, 1.0f);
    public static final Vec2 NEG_UNIT_Y = new Vec2(0.0f, -1.0f);
    public static final Vec2 MAX = new Vec2(Float.MAX_VALUE, Float.MAX_VALUE);
    public static final Vec2 MIN = new Vec2(Float.MIN_VALUE, Float.MIN_VALUE);
    public static final Codec<Vec2> CODEC = Codec.FLOAT.listOf().comapFlatMap(var02 -> Util.fixedSize(var02, 2).map(var0 -> new Vec2(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue())), var0 -> List.of(Float.valueOf(var0.x), Float.valueOf(var0.y)));
    public final float x;
    public final float y;

    public Vec2(float var0, float var1) {
        this.x = var0;
        this.y = var1;
    }

    public Vec2 scale(float var0) {
        return new Vec2(this.x * var0, this.y * var0);
    }

    public float dot(Vec2 var0) {
        return this.x * var0.x + this.y * var0.y;
    }

    public Vec2 add(Vec2 var0) {
        return new Vec2(this.x + var0.x, this.y + var0.y);
    }

    public Vec2 add(float var0) {
        return new Vec2(this.x + var0, this.y + var0);
    }

    public boolean equals(Vec2 var0) {
        return this.x == var0.x && this.y == var0.y;
    }

    public Vec2 normalized() {
        float var0 = Mth.sqrt(this.x * this.x + this.y * this.y);
        return var0 < 1.0E-4f ? ZERO : new Vec2(this.x / var0, this.y / var0);
    }

    public float length() {
        return Mth.sqrt(this.x * this.x + this.y * this.y);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distanceToSqr(Vec2 var0) {
        float var1 = var0.x - this.x;
        float var2 = var0.y - this.y;
        return var1 * var1 + var2 * var2;
    }

    public Vec2 negated() {
        return new Vec2(-this.x, -this.y);
    }
}

