/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Vec3
implements Position {
    public static final Codec<Vec3> CODEC = Codec.DOUBLE.listOf().comapFlatMap(var02 -> Util.fixedSize(var02, 3).map(var0 -> new Vec3((Double)var0.get(0), (Double)var0.get(1), (Double)var0.get(2))), var0 -> List.of(Double.valueOf(var0.x()), Double.valueOf(var0.y()), Double.valueOf(var0.z())));
    public static final StreamCodec<ByteBuf, Vec3> STREAM_CODEC = new StreamCodec<ByteBuf, Vec3>(){

        @Override
        public Vec3 decode(ByteBuf var0) {
            return FriendlyByteBuf.readVec3(var0);
        }

        @Override
        public void encode(ByteBuf var0, Vec3 var1) {
            FriendlyByteBuf.writeVec3(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Vec3)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final Vec3 ZERO = new Vec3(0.0, 0.0, 0.0);
    public static final Vec3 X_AXIS = new Vec3(1.0, 0.0, 0.0);
    public static final Vec3 Y_AXIS = new Vec3(0.0, 1.0, 0.0);
    public static final Vec3 Z_AXIS = new Vec3(0.0, 0.0, 1.0);
    public final double x;
    public final double y;
    public final double z;

    public static Vec3 atLowerCornerOf(Vec3i var0) {
        return new Vec3(var0.getX(), var0.getY(), var0.getZ());
    }

    public static Vec3 atLowerCornerWithOffset(Vec3i var0, double var1, double var3, double var5) {
        return new Vec3((double)var0.getX() + var1, (double)var0.getY() + var3, (double)var0.getZ() + var5);
    }

    public static Vec3 atCenterOf(Vec3i var0) {
        return Vec3.atLowerCornerWithOffset(var0, 0.5, 0.5, 0.5);
    }

    public static Vec3 atBottomCenterOf(Vec3i var0) {
        return Vec3.atLowerCornerWithOffset(var0, 0.5, 0.0, 0.5);
    }

    public static Vec3 upFromBottomCenterOf(Vec3i var0, double var1) {
        return Vec3.atLowerCornerWithOffset(var0, 0.5, var1, 0.5);
    }

    public Vec3(double var0, double var2, double var4) {
        this.x = var0;
        this.y = var2;
        this.z = var4;
    }

    public Vec3(Vector3fc var0) {
        this(var0.x(), var0.y(), var0.z());
    }

    public Vec3(Vec3i var0) {
        this(var0.getX(), var0.getY(), var0.getZ());
    }

    public Vec3 vectorTo(Vec3 var0) {
        return new Vec3(var0.x - this.x, var0.y - this.y, var0.z - this.z);
    }

    public Vec3 normalize() {
        double var0 = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (var0 < (double)1.0E-5f) {
            return ZERO;
        }
        return new Vec3(this.x / var0, this.y / var0, this.z / var0);
    }

    public double dot(Vec3 var0) {
        return this.x * var0.x + this.y * var0.y + this.z * var0.z;
    }

    public Vec3 cross(Vec3 var0) {
        return new Vec3(this.y * var0.z - this.z * var0.y, this.z * var0.x - this.x * var0.z, this.x * var0.y - this.y * var0.x);
    }

    public Vec3 subtract(Vec3 var0) {
        return this.subtract(var0.x, var0.y, var0.z);
    }

    public Vec3 subtract(double var0) {
        return this.subtract(var0, var0, var0);
    }

    public Vec3 subtract(double var0, double var2, double var4) {
        return this.add(-var0, -var2, -var4);
    }

    public Vec3 add(double var0) {
        return this.add(var0, var0, var0);
    }

    public Vec3 add(Vec3 var0) {
        return this.add(var0.x, var0.y, var0.z);
    }

    public Vec3 add(double var0, double var2, double var4) {
        return new Vec3(this.x + var0, this.y + var2, this.z + var4);
    }

    public boolean closerThan(Position var0, double var1) {
        return this.distanceToSqr(var0.x(), var0.y(), var0.z()) < var1 * var1;
    }

    public double distanceTo(Vec3 var0) {
        double var1 = var0.x - this.x;
        double var3 = var0.y - this.y;
        double var5 = var0.z - this.z;
        return Math.sqrt(var1 * var1 + var3 * var3 + var5 * var5);
    }

    public double distanceToSqr(Vec3 var0) {
        double var1 = var0.x - this.x;
        double var3 = var0.y - this.y;
        double var5 = var0.z - this.z;
        return var1 * var1 + var3 * var3 + var5 * var5;
    }

    public double distanceToSqr(double var0, double var2, double var4) {
        double var6 = var0 - this.x;
        double var8 = var2 - this.y;
        double var10 = var4 - this.z;
        return var6 * var6 + var8 * var8 + var10 * var10;
    }

    public boolean closerThan(Vec3 var0, double var1, double var3) {
        double var5 = var0.x() - this.x;
        double var7 = var0.y() - this.y;
        double var9 = var0.z() - this.z;
        return Mth.lengthSquared(var5, var9) < Mth.square(var1) && Math.abs(var7) < var3;
    }

    public Vec3 scale(double var0) {
        return this.multiply(var0, var0, var0);
    }

    public Vec3 reverse() {
        return this.scale(-1.0);
    }

    public Vec3 multiply(Vec3 var0) {
        return this.multiply(var0.x, var0.y, var0.z);
    }

    public Vec3 multiply(double var0, double var2, double var4) {
        return new Vec3(this.x * var0, this.y * var2, this.z * var4);
    }

    public Vec3 horizontal() {
        return new Vec3(this.x, 0.0, this.z);
    }

    public Vec3 offsetRandom(RandomSource var0, float var1) {
        return this.add((var0.nextFloat() - 0.5f) * var1, (var0.nextFloat() - 0.5f) * var1, (var0.nextFloat() - 0.5f) * var1);
    }

    public Vec3 offsetRandomXZ(RandomSource var0, float var1) {
        return this.add((var0.nextFloat() - 0.5f) * var1, 0.0, (var0.nextFloat() - 0.5f) * var1);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double horizontalDistance() {
        return Math.sqrt(this.x * this.x + this.z * this.z);
    }

    public double horizontalDistanceSqr() {
        return this.x * this.x + this.z * this.z;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof Vec3)) {
            return false;
        }
        Vec3 var1 = (Vec3)var0;
        if (Double.compare(var1.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(var1.y, this.y) != 0) {
            return false;
        }
        return Double.compare(var1.z, this.z) == 0;
    }

    public int hashCode() {
        long var1 = Double.doubleToLongBits(this.x);
        int var0 = (int)(var1 ^ var1 >>> 32);
        var1 = Double.doubleToLongBits(this.y);
        var0 = 31 * var0 + (int)(var1 ^ var1 >>> 32);
        var1 = Double.doubleToLongBits(this.z);
        var0 = 31 * var0 + (int)(var1 ^ var1 >>> 32);
        return var0;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Vec3 lerp(Vec3 var0, double var1) {
        return new Vec3(Mth.lerp(var1, this.x, var0.x), Mth.lerp(var1, this.y, var0.y), Mth.lerp(var1, this.z, var0.z));
    }

    public Vec3 xRot(float var0) {
        float var1 = Mth.cos(var0);
        float var2 = Mth.sin(var0);
        double var3 = this.x;
        double var5 = this.y * (double)var1 + this.z * (double)var2;
        double var7 = this.z * (double)var1 - this.y * (double)var2;
        return new Vec3(var3, var5, var7);
    }

    public Vec3 yRot(float var0) {
        float var1 = Mth.cos(var0);
        float var2 = Mth.sin(var0);
        double var3 = this.x * (double)var1 + this.z * (double)var2;
        double var5 = this.y;
        double var7 = this.z * (double)var1 - this.x * (double)var2;
        return new Vec3(var3, var5, var7);
    }

    public Vec3 zRot(float var0) {
        float var1 = Mth.cos(var0);
        float var2 = Mth.sin(var0);
        double var3 = this.x * (double)var1 + this.y * (double)var2;
        double var5 = this.y * (double)var1 - this.x * (double)var2;
        double var7 = this.z;
        return new Vec3(var3, var5, var7);
    }

    public Vec3 rotateClockwise90() {
        return new Vec3(-this.z, this.y, this.x);
    }

    public static Vec3 directionFromRotation(Vec2 var0) {
        return Vec3.directionFromRotation(var0.x, var0.y);
    }

    public static Vec3 directionFromRotation(float var0, float var1) {
        float var2 = Mth.cos(-var1 * ((float)Math.PI / 180) - (float)Math.PI);
        float var3 = Mth.sin(-var1 * ((float)Math.PI / 180) - (float)Math.PI);
        float var4 = -Mth.cos(-var0 * ((float)Math.PI / 180));
        float var5 = Mth.sin(-var0 * ((float)Math.PI / 180));
        return new Vec3(var3 * var4, var5, var2 * var4);
    }

    public Vec2 rotation() {
        float var0 = (float)Math.atan2(-this.x, this.z) * 57.295776f;
        float var1 = (float)Math.asin(-this.y / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z)) * 57.295776f;
        return new Vec2(var1, var0);
    }

    public Vec3 align(EnumSet<Direction.Axis> var0) {
        double var1 = var0.contains(Direction.Axis.X) ? (double)Mth.floor(this.x) : this.x;
        double var3 = var0.contains(Direction.Axis.Y) ? (double)Mth.floor(this.y) : this.y;
        double var5 = var0.contains(Direction.Axis.Z) ? (double)Mth.floor(this.z) : this.z;
        return new Vec3(var1, var3, var5);
    }

    public double get(Direction.Axis var0) {
        return var0.choose(this.x, this.y, this.z);
    }

    public Vec3 with(Direction.Axis var0, double var1) {
        double var3 = var0 == Direction.Axis.X ? var1 : this.x;
        double var5 = var0 == Direction.Axis.Y ? var1 : this.y;
        double var7 = var0 == Direction.Axis.Z ? var1 : this.z;
        return new Vec3(var3, var5, var7);
    }

    public Vec3 relative(Direction var0, double var1) {
        Vec3i var3 = var0.getUnitVec3i();
        return new Vec3(this.x + var1 * (double)var3.getX(), this.y + var1 * (double)var3.getY(), this.z + var1 * (double)var3.getZ());
    }

    @Override
    public final double x() {
        return this.x;
    }

    @Override
    public final double y() {
        return this.y;
    }

    @Override
    public final double z() {
        return this.z;
    }

    public Vector3f toVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public Vec3 projectedOn(Vec3 var0) {
        if (var0.lengthSqr() == 0.0) {
            return var0;
        }
        return var0.scale(this.dot(var0)).scale(1.0 / var0.lengthSqr());
    }

    public static Vec3 applyLocalCoordinatesToRotation(Vec2 var0, Vec3 var1) {
        float var2 = Mth.cos((var0.y + 90.0f) * ((float)Math.PI / 180));
        float var3 = Mth.sin((var0.y + 90.0f) * ((float)Math.PI / 180));
        float var4 = Mth.cos(-var0.x * ((float)Math.PI / 180));
        float var5 = Mth.sin(-var0.x * ((float)Math.PI / 180));
        float var6 = Mth.cos((-var0.x + 90.0f) * ((float)Math.PI / 180));
        float var7 = Mth.sin((-var0.x + 90.0f) * ((float)Math.PI / 180));
        Vec3 var8 = new Vec3(var2 * var4, var5, var3 * var4);
        Vec3 var9 = new Vec3(var2 * var6, var7, var3 * var6);
        Vec3 var10 = var8.cross(var9).scale(-1.0);
        double var11 = var8.x * var1.z + var9.x * var1.y + var10.x * var1.x;
        double var13 = var8.y * var1.z + var9.y * var1.y + var10.y * var1.x;
        double var15 = var8.z * var1.z + var9.z * var1.y + var10.z * var1.x;
        return new Vec3(var11, var13, var15);
    }

    public Vec3 addLocalCoordinates(Vec3 var0) {
        return Vec3.applyLocalCoordinatesToRotation(this.rotation(), var0);
    }

    public boolean isFinite() {
        return Double.isFinite(this.x) && Double.isFinite(this.y) && Double.isFinite(this.z);
    }
}

