/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.util.Util;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ArrayVoxelShape
extends VoxelShape {
    private final DoubleList xs;
    private final DoubleList ys;
    private final DoubleList zs;

    protected ArrayVoxelShape(DiscreteVoxelShape var0, double[] var1, double[] var2, double[] var3) {
        this(var0, (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(var1, var0.getXSize() + 1)), (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(var2, var0.getYSize() + 1)), (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(var3, var0.getZSize() + 1)));
    }

    ArrayVoxelShape(DiscreteVoxelShape var0, DoubleList var1, DoubleList var2, DoubleList var3) {
        super(var0);
        int var4 = var0.getXSize() + 1;
        int var5 = var0.getYSize() + 1;
        int var6 = var0.getZSize() + 1;
        if (var4 != var1.size() || var5 != var2.size() || var6 != var3.size()) {
            throw Util.pauseInIde(new IllegalArgumentException("Lengths of point arrays must be consistent with the size of the VoxelShape."));
        }
        this.xs = var1;
        this.ys = var2;
        this.zs = var3;
    }

    @Override
    public DoubleList getCoords(Direction.Axis var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> this.xs;
            case Direction.Axis.Y -> this.ys;
            case Direction.Axis.Z -> this.zs;
        };
    }
}

