/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import net.minecraft.world.Container;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Jukebox;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryJukebox;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.JukeboxInventory;

public class CraftJukebox
extends CraftBlockEntityState<JukeboxBlockEntity>
implements Jukebox {
    public CraftJukebox(World world, JukeboxBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftJukebox(CraftJukebox state, Location location) {
        super(state, location);
    }

    public JukeboxInventory getSnapshotInventory() {
        return new CraftInventoryJukebox((Container)this.getSnapshot());
    }

    public JukeboxInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryJukebox((Container)this.getTileEntity());
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.getType() == Material.JUKEBOX) {
            this.getWorldHandle().setBlock(this.getPosition(), this.data, 3);
            BlockEntity tileEntity = this.getTileEntityFromWorld();
            if (tileEntity instanceof JukeboxBlockEntity) {
                JukeboxBlockEntity jukebox = (JukeboxBlockEntity)tileEntity;
                jukebox.setTheItem(jukebox.getTheItem());
            }
        }
        return result;
    }

    public Material getPlaying() {
        return this.getRecord().getType();
    }

    public void setPlaying(Material record) {
        if (record == null || CraftItemType.bukkitToMinecraft(record) == null) {
            record = Material.AIR;
        }
        this.setRecord(new ItemStack(record));
    }

    public boolean hasRecord() {
        return this.getHandle().getValue(JukeboxBlock.HAS_RECORD) != false && !this.getPlaying().isAir();
    }

    public ItemStack getRecord() {
        net.minecraft.world.item.ItemStack record = ((JukeboxBlockEntity)this.getSnapshot()).getTheItem();
        return CraftItemStack.asBukkitCopy(record);
    }

    public void setRecord(ItemStack record) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(record);
        JukeboxBlockEntity snapshot = (JukeboxBlockEntity)this.getSnapshot();
        snapshot.setSongItemWithoutPlaying(nms, snapshot.getSongPlayer().getTicksSinceSongStarted());
        this.data = (BlockState)this.data.setValue(JukeboxBlock.HAS_RECORD, !nms.isEmpty());
    }

    public boolean isPlaying() {
        JukeboxBlockEntity jukebox;
        this.requirePlaced();
        BlockEntity tileEntity = this.getTileEntityFromWorld();
        return tileEntity instanceof JukeboxBlockEntity && (jukebox = (JukeboxBlockEntity)tileEntity).getSongPlayer().isPlaying();
    }

    public boolean startPlaying() {
        this.requirePlaced();
        BlockEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof JukeboxBlockEntity)) {
            return false;
        }
        JukeboxBlockEntity jukebox = (JukeboxBlockEntity)tileEntity;
        net.minecraft.world.item.ItemStack record = jukebox.getTheItem();
        if (record.isEmpty() || this.isPlaying()) {
            return false;
        }
        jukebox.tryForcePlaySong();
        return true;
    }

    public void stopPlaying() {
        this.requirePlaced();
        BlockEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof JukeboxBlockEntity)) {
            return;
        }
        JukeboxBlockEntity jukebox = (JukeboxBlockEntity)tileEntity;
        jukebox.getSongPlayer().stop(tileEntity.getLevel(), tileEntity.getBlockState());
    }

    public boolean eject() {
        this.ensureNoWorldGeneration();
        BlockEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof JukeboxBlockEntity)) {
            return false;
        }
        JukeboxBlockEntity jukebox = (JukeboxBlockEntity)tileEntity;
        boolean result = !jukebox.getTheItem().isEmpty();
        jukebox.popOutTheItem();
        return result;
    }

    @Override
    public CraftJukebox copy() {
        return new CraftJukebox(this, null);
    }

    @Override
    public CraftJukebox copy(Location location) {
        return new CraftJukebox(this, location);
    }
}

