/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Bee;

public class CraftBee
extends CraftAnimals
implements Bee {
    public CraftBee(CraftServer server, net.minecraft.world.entity.animal.bee.Bee entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.animal.bee.Bee getHandle() {
        return (net.minecraft.world.entity.animal.bee.Bee)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBee";
    }

    public Location getHive() {
        BlockPos hive = this.getHandle().getHivePos();
        return hive == null ? null : CraftLocation.toBukkit(hive, this.getWorld());
    }

    public void setHive(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals((Object)location.getWorld()) ? 1 : 0) != 0, (Object)"Hive must be in same world");
        this.getHandle().hivePos = location == null ? null : CraftLocation.toBlockPosition(location);
    }

    public Location getFlower() {
        BlockPos flower = this.getHandle().getSavedFlowerPos();
        return flower == null ? null : CraftLocation.toBukkit(flower, this.getWorld());
    }

    public void setFlower(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals((Object)location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        this.getHandle().setSavedFlowerPos(location == null ? null : CraftLocation.toBlockPosition(location));
    }

    public boolean hasNectar() {
        return this.getHandle().hasNectar();
    }

    public void setHasNectar(boolean nectar) {
        this.getHandle().setHasNectar(nectar);
    }

    public boolean hasStung() {
        return this.getHandle().hasStung();
    }

    public void setHasStung(boolean stung) {
        this.getHandle().setHasStung(stung);
    }

    public int getAnger() {
        int remainingAnger = (int)(this.getHandle().getPersistentAngerEndTime() - this.getWorld().getGameTime());
        return remainingAnger > 0 ? remainingAnger : 0;
    }

    public void setAnger(int anger) {
        this.getHandle().setTimeToRemainAngry(anger);
    }

    public int getCannotEnterHiveTicks() {
        return this.getHandle().stayOutOfHiveCountdown;
    }

    public void setCannotEnterHiveTicks(int ticks) {
        this.getHandle().setStayOutOfHiveCountdown(ticks);
    }
}

