/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Items;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.EnderSignal;
import org.bukkit.inventory.ItemStack;

public class CraftEnderSignal
extends CraftEntity
implements EnderSignal {
    public CraftEnderSignal(CraftServer server, EyeOfEnder entity) {
        super(server, entity);
    }

    @Override
    public EyeOfEnder getHandle() {
        return (EyeOfEnder)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderSignal";
    }

    public Location getTargetLocation() {
        return CraftLocation.toBukkit(this.getHandle().target, this.getWorld(), this.getHandle().getYRot(), this.getHandle().getXRot());
    }

    public void setTargetLocation(Location location) {
        Preconditions.checkArgument((boolean)this.getWorld().equals((Object)location.getWorld()), (Object)"Cannot target EnderSignal across worlds");
        this.getHandle().signalTo(CraftLocation.toVec3D(location));
    }

    public boolean getDropItem() {
        return this.getHandle().surviveAfterDeath;
    }

    public void setDropItem(boolean shouldDropItem) {
        this.getHandle().surviveAfterDeath = shouldDropItem;
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().getItem());
    }

    public void setItem(ItemStack item) {
        this.getHandle().setItem(item != null ? CraftItemStack.asNMSCopy(item) : Items.ENDER_EYE.getDefaultInstance());
    }

    public int getDespawnTimer() {
        return this.getHandle().life;
    }

    public void setDespawnTimer(int time) {
        this.getHandle().life = time;
    }
}

