/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityProcessor;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private final CompoundTag data;
    private final EntityType type;

    private CraftEntitySnapshot(CompoundTag data, EntityType type) {
        this.data = data;
        this.type = type;
    }

    public EntityType getEntityType() {
        return this.type;
    }

    public Entity createEntity(World world) {
        net.minecraft.world.entity.Entity internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        net.minecraft.world.entity.Entity internal = this.createInternal(location.getWorld());
        internal.setPos(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)internal.getBukkitEntity());
    }

    public String getAsString() {
        return this.data.toString();
    }

    private net.minecraft.world.entity.Entity createInternal(World world) {
        ServerLevel nms = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity internal = net.minecraft.world.entity.EntityType.loadEntityRecursive(this.data, (Level)nms, EntitySpawnReason.LOAD, EntityProcessor.NOP);
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).create(nms, EntitySpawnReason.LOAD);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        ValueInput val = TagValueInput.create(ProblemReporter.DISCARDING, (HolderLookup.Provider)nms.registryAccess(), this.data);
        internal.load(val);
        return internal;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public TypedEntityData<net.minecraft.world.entity.EntityType<?>> getEntityTag() {
        return TypedEntityData.of(CraftEntityType.bukkitToMinecraft(this.type), this.data);
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        TagValueOutput tag = TagValueOutput.createWithContext(ProblemReporter.DISCARDING, entity.getHandle().registryAccess());
        if (!entity.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return new CraftEntitySnapshot(tag.buildResult(), entity.getType());
    }

    public static CraftEntitySnapshot create(CompoundTag tag, EntityType type) {
        if (tag == null || tag.isEmpty() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(CompoundTag tag) {
        EntityType type = tag.read("id", net.minecraft.world.entity.EntityType.CODEC).map(CraftEntityType::minecraftToBukkit).orElse(null);
        return CraftEntitySnapshot.create(tag, type);
    }

    public static CraftEntitySnapshot create(TypedEntityData<net.minecraft.world.entity.EntityType<?>> tag) {
        return CraftEntitySnapshot.create(tag.copyTagWithoutId(), CraftEntityType.minecraftToBukkit(tag.type()));
    }
}

