/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.camel.CamelHusk;
import net.minecraft.world.entity.animal.chicken.Chicken;
import net.minecraft.world.entity.animal.dolphin.Dolphin;
import net.minecraft.world.entity.animal.equine.Donkey;
import net.minecraft.world.entity.animal.equine.Mule;
import net.minecraft.world.entity.animal.equine.ZombieHorse;
import net.minecraft.world.entity.animal.feline.Cat;
import net.minecraft.world.entity.animal.feline.Ocelot;
import net.minecraft.world.entity.animal.fish.Pufferfish;
import net.minecraft.world.entity.animal.fox.Fox;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.golem.CopperGolem;
import net.minecraft.world.entity.animal.golem.SnowGolem;
import net.minecraft.world.entity.animal.happyghast.HappyGhast;
import net.minecraft.world.entity.animal.panda.Panda;
import net.minecraft.world.entity.animal.parrot.Parrot;
import net.minecraft.world.entity.animal.pig.Pig;
import net.minecraft.world.entity.animal.rabbit.Rabbit;
import net.minecraft.world.entity.animal.turtle.Turtle;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.entity.decoration.painting.Painting;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.illager.Illusioner;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.skeleton.Parched;
import net.minecraft.world.entity.monster.skeleton.Skeleton;
import net.minecraft.world.entity.monster.skeleton.Stray;
import net.minecraft.world.entity.monster.skeleton.WitherSkeleton;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.zombie.Husk;
import net.minecraft.world.entity.monster.zombie.ZombifiedPiglin;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.projectile.arrow.Arrow;
import net.minecraft.world.entity.projectile.arrow.SpectralArrow;
import net.minecraft.world.entity.projectile.arrow.ThrownTrident;
import net.minecraft.world.entity.projectile.hurtingprojectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.hurtingprojectile.DragonFireball;
import net.minecraft.world.entity.projectile.hurtingprojectile.WitherSkull;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.BreezeWindCharge;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.WindCharge;
import net.minecraft.world.entity.projectile.throwableitemprojectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownEgg;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownLingeringPotion;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrownSplashPotion;
import net.minecraft.world.entity.vehicle.boat.Boat;
import net.minecraft.world.entity.vehicle.boat.ChestBoat;
import net.minecraft.world.entity.vehicle.boat.ChestRaft;
import net.minecraft.world.entity.vehicle.boat.Raft;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.entity.vehicle.minecart.Minecart;
import net.minecraft.world.entity.vehicle.minecart.MinecartChest;
import net.minecraft.world.entity.vehicle.minecart.MinecartCommandBlock;
import net.minecraft.world.entity.vehicle.minecart.MinecartFurnace;
import net.minecraft.world.entity.vehicle.minecart.MinecartHopper;
import net.minecraft.world.entity.vehicle.minecart.MinecartSpawner;
import net.minecraft.world.entity.vehicle.minecart.MinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAllay;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAreaEffectCloud;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftArmadillo;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAxolotl;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftBat;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftBee;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftBlaze;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftBlockDisplay;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftBogged;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftBreeze;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftBreezeWindCharge;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCamel;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCamelHusk;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCaveSpider;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCod;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCopperGolem;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCreaking;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftDolphin;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftDonkey;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftDragonFireball;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftDrowned;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftElderGuardian;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderPearl;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEndermite;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEvoker;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEvokerFangs;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftFox;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftGiant;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftGlowItemFrame;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftGlowSquid;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftGoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftGuardian;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHappyGhast;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHoglin;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHorse;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHusk;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftIllusioner;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftInteraction;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftIronGolem;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftItemDisplay;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftItemFrame;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLargeFireball;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLeash;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLingeringPotion;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLlama;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLlamaSpit;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMagmaCube;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMannequin;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMarker;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMinecartChest;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMinecartFurnace;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMinecartHopper;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMinecartMobSpawner;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMinecartRideable;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMinecartTNT;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMule;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMushroomCow;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftNautilus;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftOcelot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftOminousItemSpawner;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPainting;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPanda;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftParched;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftParrot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPhantom;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPigZombie;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPiglinBrute;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPolarBear;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPufferFish;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftRabbit;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftRavager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSalmon;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSheep;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftShulkerBullet;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSilverfish;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSkeleton;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSkeletonHorse;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSlime;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSmallFireball;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSniffer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSnowball;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSnowman;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSpectralArrow;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSpider;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSplashPotion;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftSquid;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftStray;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftStrider;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTNTPrimed;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTadpole;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTextDisplay;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftThrownExpBottle;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTraderLlama;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTropicalFish;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTurtle;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVex;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVillagerZombie;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVindicator;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWanderingTrader;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWarden;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWindCharge;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWitch;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWither;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWitherSkeleton;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftZoglin;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftZombieHorse;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftZombieNautilus;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftAcaciaBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftAcaciaChestBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftBambooChestRaft;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftBambooRaft;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftBirchBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftBirchChestBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftCherryBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftCherryChestBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftDarkOakBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftDarkOakChestBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftJungleBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftJungleChestBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftMangroveBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftMangroveChestBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftOakBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftOakChestBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftPaleOakBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftPaleOakChestBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftSpruceBoat;
import org.bukkit.craftbukkit.v1_21_R7.entity.boat.CraftSpruceChestBoat;
import org.bukkit.entity.Allay;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Breeze;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creaking;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Nautilus;
import org.bukkit.entity.OminousItemSpawner;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spider;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieNautilus;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.boat.AcaciaBoat;
import org.bukkit.entity.boat.AcaciaChestBoat;
import org.bukkit.entity.boat.BambooChestRaft;
import org.bukkit.entity.boat.BambooRaft;
import org.bukkit.entity.boat.BirchBoat;
import org.bukkit.entity.boat.BirchChestBoat;
import org.bukkit.entity.boat.CherryBoat;
import org.bukkit.entity.boat.CherryChestBoat;
import org.bukkit.entity.boat.DarkOakBoat;
import org.bukkit.entity.boat.DarkOakChestBoat;
import org.bukkit.entity.boat.JungleBoat;
import org.bukkit.entity.boat.JungleChestBoat;
import org.bukkit.entity.boat.MangroveBoat;
import org.bukkit.entity.boat.MangroveChestBoat;
import org.bukkit.entity.boat.OakBoat;
import org.bukkit.entity.boat.OakChestBoat;
import org.bukkit.entity.boat.PaleOakBoat;
import org.bukkit.entity.boat.PaleOakChestBoat;
import org.bukkit.entity.boat.SpruceBoat;
import org.bukkit.entity.boat.SpruceChestBoat;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.util.Vector;

public final class CraftEntityTypes {
    private static final BiConsumer<SpawnData, net.minecraft.world.entity.Entity> POS = (spawnData, entity) -> entity.setPos(spawnData.x(), spawnData.y(), spawnData.z());
    private static final BiConsumer<SpawnData, net.minecraft.world.entity.Entity> ABS_MOVE = (spawnData, entity) -> {
        entity.absSnapTo(spawnData.x(), spawnData.y(), spawnData.z(), spawnData.yaw(), spawnData.pitch());
        entity.setYHeadRot(spawnData.yaw());
    };
    private static final BiConsumer<SpawnData, net.minecraft.world.entity.Entity> MOVE = (spawnData, entity) -> entity.snapTo(spawnData.x(), spawnData.y(), spawnData.z(), spawnData.yaw(), spawnData.pitch());
    private static final BiConsumer<SpawnData, net.minecraft.world.entity.Entity> MOVE_EMPTY_ROT = (spawnData, entity) -> entity.snapTo(spawnData.x(), spawnData.y(), spawnData.z(), 0.0f, 0.0f);
    private static final BiConsumer<SpawnData, AbstractHurtingProjectile> DIRECTION = (spawnData, entity) -> {
        Vector direction = spawnData.location().getDirection();
        entity.assignDirectionalMovement(new Vec3(direction.getX(), direction.getY(), direction.getZ()), 1.0);
    };
    private static final Map<Class<?>, EntityTypeData<?, ?>> CLASS_TYPE_DATA = new HashMap();
    private static final Map<EntityType, EntityTypeData<?, ?>> ENTITY_TYPE_DATA = new HashMap();

    private static void register(EntityTypeData<?, ?> typeData) {
        EntityTypeData<?, ?> other = CLASS_TYPE_DATA.put(typeData.entityClass(), typeData);
        if (other != null) {
            Bukkit.getLogger().warning(String.format("Found multiple entity type data for class %s, replacing '%s' with new value '%s'", typeData.entityClass().getName(), other, typeData));
        }
        if ((other = ENTITY_TYPE_DATA.put(typeData.entityType(), typeData)) != null) {
            Bukkit.getLogger().warning(String.format("Found multiple entity type data for entity type %s, replacing '%s' with new value '%s'", typeData.entityType().getKey(), other, typeData));
        }
    }

    private static <R extends net.minecraft.world.entity.Entity> Function<SpawnData, R> fromEntityType(net.minecraft.world.entity.EntityType<R> entityTypes) {
        return spawnData -> entityTypes.create(spawnData.minecraftWorld(), EntitySpawnReason.COMMAND);
    }

    private static <R extends LivingEntity> Function<SpawnData, R> createLiving(net.minecraft.world.entity.EntityType<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), ABS_MOVE);
    }

    private static <R extends AbstractHurtingProjectile> Function<SpawnData, R> createFireball(net.minecraft.world.entity.EntityType<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.createAndMove(entityTypes), DIRECTION);
    }

    private static <R extends AbstractMinecart> Function<SpawnData, R> createMinecart(net.minecraft.world.entity.EntityType<R> entityTypes) {
        return spawnData -> {
            if (spawnData.normalWorld()) {
                return AbstractMinecart.createMinecart(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), entityTypes, EntitySpawnReason.TRIGGERED, ItemStack.EMPTY, null);
            }
            return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), (spawnData2, entity) -> entity.setInitialPos(spawnData.x(), spawnData.y(), spawnData.z())).apply((SpawnData)spawnData);
        };
    }

    private static <R extends net.minecraft.world.entity.Entity> Function<SpawnData, R> createAndMove(net.minecraft.world.entity.EntityType<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), MOVE);
    }

    private static <R extends net.minecraft.world.entity.Entity> Function<SpawnData, R> createAndMoveEmptyRot(net.minecraft.world.entity.EntityType<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), MOVE_EMPTY_ROT);
    }

    private static <R extends net.minecraft.world.entity.Entity> Function<SpawnData, R> createAndSetPos(net.minecraft.world.entity.EntityType<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), POS);
    }

    private static <E extends Hanging, R extends HangingEntity> Function<SpawnData, R> createHanging(Class<E> clazz, BiFunction<SpawnData, HangingData, R> spawnFunction) {
        return spawnData -> {
            boolean randomizeData = spawnData.randomizeData();
            BlockFace face = BlockFace.SELF;
            BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
            int width = 16;
            int height = 16;
            if (ItemFrame.class.isAssignableFrom(clazz)) {
                width = 12;
                height = 12;
                faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH, BlockFace.UP, BlockFace.DOWN};
            }
            BlockPos pos = BlockPos.containing(spawnData.x(), spawnData.y(), spawnData.z());
            for (BlockFace dir : faces) {
                BlockState nmsBlock = spawnData.world().getBlockState(pos.relative(CraftBlock.blockFaceToNotch(dir)));
                if (!nmsBlock.isSolid() && !DiodeBlock.isDiode(nmsBlock)) continue;
                boolean taken = false;
                AABB bb = ItemFrame.class.isAssignableFrom(clazz) ? net.minecraft.world.entity.decoration.ItemFrame.createBoundingBox(pos, CraftBlock.blockFaceToNotch(dir).getOpposite(), false) : Painting.calculateBoundingBoxStatic(pos, CraftBlock.blockFaceToNotch(dir).getOpposite(), width, height);
                List<net.minecraft.world.entity.Entity> list = spawnData.world().getEntities(null, bb);
                Iterator<net.minecraft.world.entity.Entity> it = list.iterator();
                while (!taken && it.hasNext()) {
                    net.minecraft.world.entity.Entity e = it.next();
                    if (!(e instanceof HangingEntity)) continue;
                    taken = true;
                }
                if (taken) continue;
                face = dir;
                break;
            }
            if (face == BlockFace.SELF) {
                face = BlockFace.SOUTH;
                randomizeData = false;
            }
            Direction dir = CraftBlock.blockFaceToNotch(face).getOpposite();
            return (HangingEntity)spawnFunction.apply((SpawnData)spawnData, new HangingData(randomizeData, pos, dir));
        };
    }

    private static <T, R> Function<T, R> combine(Function<T, R> before, BiConsumer<T, ? super R> after) {
        return t -> {
            Object r = before.apply(t);
            after.accept((Object)t, (Object)r);
            return r;
        };
    }

    public static <E extends Entity, M extends net.minecraft.world.entity.Entity> EntityTypeData<E, M> getEntityTypeData(EntityType entityType) {
        return ENTITY_TYPE_DATA.get(entityType);
    }

    public static <E extends Entity, M extends net.minecraft.world.entity.Entity> EntityTypeData<E, M> getEntityTypeData(Class<E> entityClass) {
        return CLASS_TYPE_DATA.get(entityClass);
    }

    private CraftEntityTypes() {
    }

    static {
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.ElderGuardian, ElderGuardian>(EntityType.ELDER_GUARDIAN, org.bukkit.entity.ElderGuardian.class, CraftElderGuardian::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ELDER_GUARDIAN)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.WitherSkeleton, WitherSkeleton>(EntityType.WITHER_SKELETON, org.bukkit.entity.WitherSkeleton.class, CraftWitherSkeleton::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.WITHER_SKELETON)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Stray, Stray>(EntityType.STRAY, org.bukkit.entity.Stray.class, CraftStray::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.STRAY)));
        CraftEntityTypes.register(new EntityTypeData<Bogged, net.minecraft.world.entity.monster.skeleton.Bogged>(EntityType.BOGGED, Bogged.class, CraftBogged::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.BOGGED)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Husk, Husk>(EntityType.HUSK, org.bukkit.entity.Husk.class, CraftHusk::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.HUSK)));
        CraftEntityTypes.register(new EntityTypeData<ZombieVillager, net.minecraft.world.entity.monster.zombie.ZombieVillager>(EntityType.ZOMBIE_VILLAGER, ZombieVillager.class, CraftVillagerZombie::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ZOMBIE_VILLAGER)));
        CraftEntityTypes.register(new EntityTypeData<SkeletonHorse, net.minecraft.world.entity.animal.equine.SkeletonHorse>(EntityType.SKELETON_HORSE, SkeletonHorse.class, CraftSkeletonHorse::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SKELETON_HORSE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.ZombieHorse, ZombieHorse>(EntityType.ZOMBIE_HORSE, org.bukkit.entity.ZombieHorse.class, CraftZombieHorse::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ZOMBIE_HORSE)));
        CraftEntityTypes.register(new EntityTypeData<ArmorStand, net.minecraft.world.entity.decoration.ArmorStand>(EntityType.ARMOR_STAND, ArmorStand.class, CraftArmorStand::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ARMOR_STAND)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Mannequin, Mannequin>(EntityType.MANNEQUIN, org.bukkit.entity.Mannequin.class, CraftMannequin::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.MANNEQUIN)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Donkey, Donkey>(EntityType.DONKEY, org.bukkit.entity.Donkey.class, CraftDonkey::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.DONKEY)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Mule, Mule>(EntityType.MULE, org.bukkit.entity.Mule.class, CraftMule::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.MULE)));
        CraftEntityTypes.register(new EntityTypeData<Evoker, net.minecraft.world.entity.monster.illager.Evoker>(EntityType.EVOKER, Evoker.class, CraftEvoker::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.EVOKER)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Vex, Vex>(EntityType.VEX, org.bukkit.entity.Vex.class, CraftVex::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.VEX)));
        CraftEntityTypes.register(new EntityTypeData<Vindicator, net.minecraft.world.entity.monster.illager.Vindicator>(EntityType.VINDICATOR, Vindicator.class, CraftVindicator::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.VINDICATOR)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Illusioner, Illusioner>(EntityType.ILLUSIONER, org.bukkit.entity.Illusioner.class, CraftIllusioner::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ILLUSIONER)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Creeper, Creeper>(EntityType.CREEPER, org.bukkit.entity.Creeper.class, CraftCreeper::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.CREEPER)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Skeleton, Skeleton>(EntityType.SKELETON, org.bukkit.entity.Skeleton.class, CraftSkeleton::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SKELETON)));
        CraftEntityTypes.register(new EntityTypeData<Spider, net.minecraft.world.entity.monster.spider.Spider>(EntityType.SPIDER, Spider.class, CraftSpider::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SPIDER)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Giant, Giant>(EntityType.GIANT, org.bukkit.entity.Giant.class, CraftGiant::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.GIANT)));
        CraftEntityTypes.register(new EntityTypeData<Zombie, net.minecraft.world.entity.monster.zombie.Zombie>(EntityType.ZOMBIE, Zombie.class, CraftZombie::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ZOMBIE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Slime, Slime>(EntityType.SLIME, org.bukkit.entity.Slime.class, CraftSlime::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SLIME)));
        CraftEntityTypes.register(new EntityTypeData<Ghast, net.minecraft.world.entity.monster.Ghast>(EntityType.GHAST, Ghast.class, CraftGhast::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.GHAST)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.HappyGhast, HappyGhast>(EntityType.HAPPY_GHAST, org.bukkit.entity.HappyGhast.class, CraftHappyGhast::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.HAPPY_GHAST)));
        CraftEntityTypes.register(new EntityTypeData<PigZombie, ZombifiedPiglin>(EntityType.ZOMBIFIED_PIGLIN, PigZombie.class, CraftPigZombie::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ZOMBIFIED_PIGLIN)));
        CraftEntityTypes.register(new EntityTypeData<Enderman, EnderMan>(EntityType.ENDERMAN, Enderman.class, CraftEnderman::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ENDERMAN)));
        CraftEntityTypes.register(new EntityTypeData<CaveSpider, net.minecraft.world.entity.monster.spider.CaveSpider>(EntityType.CAVE_SPIDER, CaveSpider.class, CraftCaveSpider::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.CAVE_SPIDER)));
        CraftEntityTypes.register(new EntityTypeData<Silverfish, net.minecraft.world.entity.monster.Silverfish>(EntityType.SILVERFISH, Silverfish.class, CraftSilverfish::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SILVERFISH)));
        CraftEntityTypes.register(new EntityTypeData<Blaze, net.minecraft.world.entity.monster.Blaze>(EntityType.BLAZE, Blaze.class, CraftBlaze::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.BLAZE)));
        CraftEntityTypes.register(new EntityTypeData<MagmaCube, net.minecraft.world.entity.monster.MagmaCube>(EntityType.MAGMA_CUBE, MagmaCube.class, CraftMagmaCube::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.MAGMA_CUBE)));
        CraftEntityTypes.register(new EntityTypeData<Wither, WitherBoss>(EntityType.WITHER, Wither.class, CraftWither::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.WITHER)));
        CraftEntityTypes.register(new EntityTypeData<Bat, net.minecraft.world.entity.ambient.Bat>(EntityType.BAT, Bat.class, CraftBat::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.BAT)));
        CraftEntityTypes.register(new EntityTypeData<Witch, net.minecraft.world.entity.monster.Witch>(EntityType.WITCH, Witch.class, CraftWitch::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.WITCH)));
        CraftEntityTypes.register(new EntityTypeData<Endermite, net.minecraft.world.entity.monster.Endermite>(EntityType.ENDERMITE, Endermite.class, CraftEndermite::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ENDERMITE)));
        CraftEntityTypes.register(new EntityTypeData<Guardian, net.minecraft.world.entity.monster.Guardian>(EntityType.GUARDIAN, Guardian.class, CraftGuardian::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.GUARDIAN)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Shulker, Shulker>(EntityType.SHULKER, org.bukkit.entity.Shulker.class, CraftShulker::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SHULKER)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Pig, Pig>(EntityType.PIG, org.bukkit.entity.Pig.class, CraftPig::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.PIG)));
        CraftEntityTypes.register(new EntityTypeData<Sheep, net.minecraft.world.entity.animal.sheep.Sheep>(EntityType.SHEEP, Sheep.class, CraftSheep::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SHEEP)));
        CraftEntityTypes.register(new EntityTypeData<Cow, net.minecraft.world.entity.animal.cow.Cow>(EntityType.COW, Cow.class, CraftCow::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.COW)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Chicken, Chicken>(EntityType.CHICKEN, org.bukkit.entity.Chicken.class, CraftChicken::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.CHICKEN)));
        CraftEntityTypes.register(new EntityTypeData<Squid, net.minecraft.world.entity.animal.squid.Squid>(EntityType.SQUID, Squid.class, CraftSquid::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SQUID)));
        CraftEntityTypes.register(new EntityTypeData<Wolf, net.minecraft.world.entity.animal.wolf.Wolf>(EntityType.WOLF, Wolf.class, CraftWolf::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.WOLF)));
        CraftEntityTypes.register(new EntityTypeData<MushroomCow, net.minecraft.world.entity.animal.cow.MushroomCow>(EntityType.MOOSHROOM, MushroomCow.class, CraftMushroomCow::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.MOOSHROOM)));
        CraftEntityTypes.register(new EntityTypeData<Snowman, SnowGolem>(EntityType.SNOW_GOLEM, Snowman.class, CraftSnowman::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SNOW_GOLEM)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Ocelot, Ocelot>(EntityType.OCELOT, org.bukkit.entity.Ocelot.class, CraftOcelot::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.OCELOT)));
        CraftEntityTypes.register(new EntityTypeData<IronGolem, net.minecraft.world.entity.animal.golem.IronGolem>(EntityType.IRON_GOLEM, IronGolem.class, CraftIronGolem::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.IRON_GOLEM)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.CopperGolem, CopperGolem>(EntityType.COPPER_GOLEM, org.bukkit.entity.CopperGolem.class, CraftCopperGolem::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.COPPER_GOLEM)));
        CraftEntityTypes.register(new EntityTypeData<Horse, net.minecraft.world.entity.animal.equine.Horse>(EntityType.HORSE, Horse.class, CraftHorse::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.HORSE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Rabbit, Rabbit>(EntityType.RABBIT, org.bukkit.entity.Rabbit.class, CraftRabbit::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.RABBIT)));
        CraftEntityTypes.register(new EntityTypeData<PolarBear, net.minecraft.world.entity.animal.polarbear.PolarBear>(EntityType.POLAR_BEAR, PolarBear.class, CraftPolarBear::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.POLAR_BEAR)));
        CraftEntityTypes.register(new EntityTypeData<Llama, net.minecraft.world.entity.animal.equine.Llama>(EntityType.LLAMA, Llama.class, CraftLlama::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.LLAMA)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Parrot, Parrot>(EntityType.PARROT, org.bukkit.entity.Parrot.class, CraftParrot::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.PARROT)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Villager, Villager>(EntityType.VILLAGER, org.bukkit.entity.Villager.class, CraftVillager::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.VILLAGER)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Turtle, Turtle>(EntityType.TURTLE, org.bukkit.entity.Turtle.class, CraftTurtle::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.TURTLE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Phantom, Phantom>(EntityType.PHANTOM, org.bukkit.entity.Phantom.class, CraftPhantom::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.PHANTOM)));
        CraftEntityTypes.register(new EntityTypeData<Cod, net.minecraft.world.entity.animal.fish.Cod>(EntityType.COD, Cod.class, CraftCod::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.COD)));
        CraftEntityTypes.register(new EntityTypeData<Salmon, net.minecraft.world.entity.animal.fish.Salmon>(EntityType.SALMON, Salmon.class, CraftSalmon::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SALMON)));
        CraftEntityTypes.register(new EntityTypeData<PufferFish, Pufferfish>(EntityType.PUFFERFISH, PufferFish.class, CraftPufferFish::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.PUFFERFISH)));
        CraftEntityTypes.register(new EntityTypeData<TropicalFish, net.minecraft.world.entity.animal.fish.TropicalFish>(EntityType.TROPICAL_FISH, TropicalFish.class, CraftTropicalFish::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.TROPICAL_FISH)));
        CraftEntityTypes.register(new EntityTypeData<Drowned, net.minecraft.world.entity.monster.zombie.Drowned>(EntityType.DROWNED, Drowned.class, CraftDrowned::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.DROWNED)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Dolphin, Dolphin>(EntityType.DOLPHIN, org.bukkit.entity.Dolphin.class, CraftDolphin::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.DOLPHIN)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Cat, Cat>(EntityType.CAT, org.bukkit.entity.Cat.class, CraftCat::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.CAT)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Panda, Panda>(EntityType.PANDA, org.bukkit.entity.Panda.class, CraftPanda::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.PANDA)));
        CraftEntityTypes.register(new EntityTypeData<Pillager, net.minecraft.world.entity.monster.illager.Pillager>(EntityType.PILLAGER, Pillager.class, CraftPillager::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.PILLAGER)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Ravager, Ravager>(EntityType.RAVAGER, org.bukkit.entity.Ravager.class, CraftRavager::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.RAVAGER)));
        CraftEntityTypes.register(new EntityTypeData<TraderLlama, net.minecraft.world.entity.animal.equine.TraderLlama>(EntityType.TRADER_LLAMA, TraderLlama.class, CraftTraderLlama::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.TRADER_LLAMA)));
        CraftEntityTypes.register(new EntityTypeData<WanderingTrader, net.minecraft.world.entity.npc.wanderingtrader.WanderingTrader>(EntityType.WANDERING_TRADER, WanderingTrader.class, CraftWanderingTrader::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.WANDERING_TRADER)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Fox, Fox>(EntityType.FOX, org.bukkit.entity.Fox.class, CraftFox::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.FOX)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Bee, Bee>(EntityType.BEE, org.bukkit.entity.Bee.class, CraftBee::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.BEE)));
        CraftEntityTypes.register(new EntityTypeData<Hoglin, net.minecraft.world.entity.monster.hoglin.Hoglin>(EntityType.HOGLIN, Hoglin.class, CraftHoglin::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.HOGLIN)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Piglin, Piglin>(EntityType.PIGLIN, org.bukkit.entity.Piglin.class, CraftPiglin::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.PIGLIN)));
        CraftEntityTypes.register(new EntityTypeData<Strider, net.minecraft.world.entity.monster.Strider>(EntityType.STRIDER, Strider.class, CraftStrider::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.STRIDER)));
        CraftEntityTypes.register(new EntityTypeData<Zoglin, net.minecraft.world.entity.monster.Zoglin>(EntityType.ZOGLIN, Zoglin.class, CraftZoglin::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ZOGLIN)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.PiglinBrute, PiglinBrute>(EntityType.PIGLIN_BRUTE, org.bukkit.entity.PiglinBrute.class, CraftPiglinBrute::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.PIGLIN_BRUTE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Axolotl, Axolotl>(EntityType.AXOLOTL, org.bukkit.entity.Axolotl.class, CraftAxolotl::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.AXOLOTL)));
        CraftEntityTypes.register(new EntityTypeData<GlowSquid, net.minecraft.world.entity.animal.squid.GlowSquid>(EntityType.GLOW_SQUID, GlowSquid.class, CraftGlowSquid::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.GLOW_SQUID)));
        CraftEntityTypes.register(new EntityTypeData<Goat, net.minecraft.world.entity.animal.goat.Goat>(EntityType.GOAT, Goat.class, CraftGoat::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.GOAT)));
        CraftEntityTypes.register(new EntityTypeData<Allay, net.minecraft.world.entity.animal.allay.Allay>(EntityType.ALLAY, Allay.class, CraftAllay::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ALLAY)));
        CraftEntityTypes.register(new EntityTypeData<Frog, net.minecraft.world.entity.animal.frog.Frog>(EntityType.FROG, Frog.class, CraftFrog::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.FROG)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Tadpole, Tadpole>(EntityType.TADPOLE, org.bukkit.entity.Tadpole.class, CraftTadpole::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.TADPOLE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Warden, Warden>(EntityType.WARDEN, org.bukkit.entity.Warden.class, CraftWarden::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.WARDEN)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Camel, Camel>(EntityType.CAMEL, org.bukkit.entity.Camel.class, CraftCamel::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.CAMEL)));
        CraftEntityTypes.register(new EntityTypeData<Sniffer, net.minecraft.world.entity.animal.sniffer.Sniffer>(EntityType.SNIFFER, Sniffer.class, CraftSniffer::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.SNIFFER)));
        CraftEntityTypes.register(new EntityTypeData<Breeze, net.minecraft.world.entity.monster.breeze.Breeze>(EntityType.BREEZE, Breeze.class, CraftBreeze::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.BREEZE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Armadillo, Armadillo>(EntityType.ARMADILLO, org.bukkit.entity.Armadillo.class, CraftArmadillo::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ARMADILLO)));
        CraftEntityTypes.register(new EntityTypeData<Creaking, net.minecraft.world.entity.monster.creaking.Creaking>(EntityType.CREAKING, Creaking.class, CraftCreaking::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.CREAKING)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.CamelHusk, CamelHusk>(EntityType.CAMEL_HUSK, org.bukkit.entity.CamelHusk.class, CraftCamelHusk::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.CAMEL_HUSK)));
        CraftEntityTypes.register(new EntityTypeData<Nautilus, net.minecraft.world.entity.animal.nautilus.Nautilus>(EntityType.NAUTILUS, Nautilus.class, CraftNautilus::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.NAUTILUS)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Parched, Parched>(EntityType.PARCHED, org.bukkit.entity.Parched.class, CraftParched::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.PARCHED)));
        CraftEntityTypes.register(new EntityTypeData<ZombieNautilus, net.minecraft.world.entity.animal.nautilus.ZombieNautilus>(EntityType.ZOMBIE_NAUTILUS, ZombieNautilus.class, CraftZombieNautilus::new, CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ZOMBIE_NAUTILUS)));
        Function<SpawnData, EnderDragon> dragonFunction = CraftEntityTypes.createLiving(net.minecraft.world.entity.EntityType.ENDER_DRAGON);
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.EnderDragon, EnderDragon>(EntityType.ENDER_DRAGON, org.bukkit.entity.EnderDragon.class, CraftEnderDragon::new, spawnData -> {
            Preconditions.checkArgument((boolean)spawnData.normalWorld(), (String)"Cannot spawn entity %s during world generation", (Object)org.bukkit.entity.EnderDragon.class.getName());
            return (EnderDragon)dragonFunction.apply((SpawnData)spawnData);
        }));
        CraftEntityTypes.register(new EntityTypeData<LargeFireball, net.minecraft.world.entity.projectile.hurtingprojectile.LargeFireball>(EntityType.FIREBALL, LargeFireball.class, CraftLargeFireball::new, CraftEntityTypes.createFireball(net.minecraft.world.entity.EntityType.FIREBALL)));
        CraftEntityTypes.register(new EntityTypeData<SmallFireball, net.minecraft.world.entity.projectile.hurtingprojectile.SmallFireball>(EntityType.SMALL_FIREBALL, SmallFireball.class, CraftSmallFireball::new, CraftEntityTypes.createFireball(net.minecraft.world.entity.EntityType.SMALL_FIREBALL)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.WitherSkull, WitherSkull>(EntityType.WITHER_SKULL, org.bukkit.entity.WitherSkull.class, CraftWitherSkull::new, CraftEntityTypes.createFireball(net.minecraft.world.entity.EntityType.WITHER_SKULL)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.DragonFireball, DragonFireball>(EntityType.DRAGON_FIREBALL, org.bukkit.entity.DragonFireball.class, CraftDragonFireball::new, CraftEntityTypes.createFireball(net.minecraft.world.entity.EntityType.DRAGON_FIREBALL)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.WindCharge, WindCharge>(EntityType.WIND_CHARGE, org.bukkit.entity.WindCharge.class, CraftWindCharge::new, CraftEntityTypes.createFireball(net.minecraft.world.entity.EntityType.WIND_CHARGE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.BreezeWindCharge, BreezeWindCharge>(EntityType.BREEZE_WIND_CHARGE, org.bukkit.entity.BreezeWindCharge.class, CraftBreezeWindCharge::new, CraftEntityTypes.createFireball(net.minecraft.world.entity.EntityType.BREEZE_WIND_CHARGE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Painting, Painting>(EntityType.PAINTING, org.bukkit.entity.Painting.class, CraftPainting::new, CraftEntityTypes.createHanging(org.bukkit.entity.Painting.class, (spawnData, hangingData) -> {
            if (spawnData.normalWorld && hangingData.randomize()) {
                return Painting.create(spawnData.minecraftWorld(), hangingData.position(), hangingData.direction()).orElse(null);
            }
            Painting entity = new Painting((net.minecraft.world.entity.EntityType<? extends Painting>)net.minecraft.world.entity.EntityType.PAINTING, spawnData.minecraftWorld());
            entity.absSnapTo(spawnData.x(), spawnData.y(), spawnData.z(), spawnData.yaw(), spawnData.pitch());
            entity.setDirection(hangingData.direction());
            return entity;
        })));
        CraftEntityTypes.register(new EntityTypeData<ItemFrame, net.minecraft.world.entity.decoration.ItemFrame>(EntityType.ITEM_FRAME, ItemFrame.class, CraftItemFrame::new, CraftEntityTypes.createHanging(ItemFrame.class, (spawnData, hangingData) -> new net.minecraft.world.entity.decoration.ItemFrame(spawnData.minecraftWorld(), hangingData.position(), hangingData.direction()))));
        CraftEntityTypes.register(new EntityTypeData<GlowItemFrame, net.minecraft.world.entity.decoration.GlowItemFrame>(EntityType.GLOW_ITEM_FRAME, GlowItemFrame.class, CraftGlowItemFrame::new, CraftEntityTypes.createHanging(GlowItemFrame.class, (spawnData, hangingData) -> new net.minecraft.world.entity.decoration.GlowItemFrame(spawnData.minecraftWorld(), hangingData.position(), hangingData.direction()))));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Arrow, Arrow>(EntityType.ARROW, org.bukkit.entity.Arrow.class, CraftArrow::new, CraftEntityTypes.createAndMoveEmptyRot(net.minecraft.world.entity.EntityType.ARROW)));
        CraftEntityTypes.register(new EntityTypeData<EnderPearl, ThrownEnderpearl>(EntityType.ENDER_PEARL, EnderPearl.class, CraftEnderPearl::new, CraftEntityTypes.createAndMoveEmptyRot(net.minecraft.world.entity.EntityType.ENDER_PEARL)));
        CraftEntityTypes.register(new EntityTypeData<ThrownExpBottle, ThrownExperienceBottle>(EntityType.EXPERIENCE_BOTTLE, ThrownExpBottle.class, CraftThrownExpBottle::new, CraftEntityTypes.createAndMoveEmptyRot(net.minecraft.world.entity.EntityType.EXPERIENCE_BOTTLE)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.SpectralArrow, SpectralArrow>(EntityType.SPECTRAL_ARROW, org.bukkit.entity.SpectralArrow.class, CraftSpectralArrow::new, CraftEntityTypes.createAndMoveEmptyRot(net.minecraft.world.entity.EntityType.SPECTRAL_ARROW)));
        CraftEntityTypes.register(new EntityTypeData<EnderCrystal, EndCrystal>(EntityType.END_CRYSTAL, EnderCrystal.class, CraftEnderCrystal::new, CraftEntityTypes.createAndMoveEmptyRot(net.minecraft.world.entity.EntityType.END_CRYSTAL)));
        CraftEntityTypes.register(new EntityTypeData<Trident, ThrownTrident>(EntityType.TRIDENT, Trident.class, CraftTrident::new, CraftEntityTypes.createAndMoveEmptyRot(net.minecraft.world.entity.EntityType.TRIDENT)));
        CraftEntityTypes.register(new EntityTypeData<LightningStrike, LightningBolt>(EntityType.LIGHTNING_BOLT, LightningStrike.class, CraftLightningStrike::new, CraftEntityTypes.createAndMoveEmptyRot(net.minecraft.world.entity.EntityType.LIGHTNING_BOLT)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.ShulkerBullet, ShulkerBullet>(EntityType.SHULKER_BULLET, org.bukkit.entity.ShulkerBullet.class, CraftShulkerBullet::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.SHULKER_BULLET)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.LlamaSpit, LlamaSpit>(EntityType.LLAMA_SPIT, org.bukkit.entity.LlamaSpit.class, CraftLlamaSpit::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.LLAMA_SPIT)));
        CraftEntityTypes.register(new EntityTypeData<OminousItemSpawner, net.minecraft.world.entity.OminousItemSpawner>(EntityType.OMINOUS_ITEM_SPAWNER, OminousItemSpawner.class, CraftOminousItemSpawner::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.OMINOUS_ITEM_SPAWNER)));
        CraftEntityTypes.register(new EntityTypeData<AcaciaBoat, Boat>(EntityType.ACACIA_BOAT, AcaciaBoat.class, CraftAcaciaBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.ACACIA_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<AcaciaChestBoat, ChestBoat>(EntityType.ACACIA_CHEST_BOAT, AcaciaChestBoat.class, CraftAcaciaChestBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.ACACIA_CHEST_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<BambooRaft, Raft>(EntityType.BAMBOO_RAFT, BambooRaft.class, CraftBambooRaft::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.BAMBOO_RAFT)));
        CraftEntityTypes.register(new EntityTypeData<BambooChestRaft, ChestRaft>(EntityType.BAMBOO_CHEST_RAFT, BambooChestRaft.class, CraftBambooChestRaft::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.BAMBOO_CHEST_RAFT)));
        CraftEntityTypes.register(new EntityTypeData<BirchBoat, Boat>(EntityType.BIRCH_BOAT, BirchBoat.class, CraftBirchBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.BIRCH_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<BirchChestBoat, ChestBoat>(EntityType.BIRCH_CHEST_BOAT, BirchChestBoat.class, CraftBirchChestBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.BIRCH_CHEST_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<CherryBoat, Boat>(EntityType.CHERRY_BOAT, CherryBoat.class, CraftCherryBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.CHERRY_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<CherryChestBoat, ChestBoat>(EntityType.CHERRY_CHEST_BOAT, CherryChestBoat.class, CraftCherryChestBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.CHERRY_CHEST_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<DarkOakBoat, Boat>(EntityType.DARK_OAK_BOAT, DarkOakBoat.class, CraftDarkOakBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.DARK_OAK_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<DarkOakChestBoat, ChestBoat>(EntityType.DARK_OAK_CHEST_BOAT, DarkOakChestBoat.class, CraftDarkOakChestBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.DARK_OAK_CHEST_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<JungleBoat, Boat>(EntityType.JUNGLE_BOAT, JungleBoat.class, CraftJungleBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.JUNGLE_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<JungleChestBoat, ChestBoat>(EntityType.JUNGLE_CHEST_BOAT, JungleChestBoat.class, CraftJungleChestBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.JUNGLE_CHEST_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<MangroveBoat, Boat>(EntityType.MANGROVE_BOAT, MangroveBoat.class, CraftMangroveBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.MANGROVE_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<MangroveChestBoat, ChestBoat>(EntityType.MANGROVE_CHEST_BOAT, MangroveChestBoat.class, CraftMangroveChestBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.MANGROVE_CHEST_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<OakBoat, Boat>(EntityType.OAK_BOAT, OakBoat.class, CraftOakBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.OAK_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<OakChestBoat, ChestBoat>(EntityType.OAK_CHEST_BOAT, OakChestBoat.class, CraftOakChestBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.OAK_CHEST_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<PaleOakBoat, Boat>(EntityType.PALE_OAK_BOAT, PaleOakBoat.class, CraftPaleOakBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.PALE_OAK_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<PaleOakChestBoat, ChestBoat>(EntityType.PALE_OAK_CHEST_BOAT, PaleOakChestBoat.class, CraftPaleOakChestBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.PALE_OAK_CHEST_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<SpruceBoat, Boat>(EntityType.SPRUCE_BOAT, SpruceBoat.class, CraftSpruceBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.SPRUCE_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<SpruceChestBoat, ChestBoat>(EntityType.SPRUCE_CHEST_BOAT, SpruceChestBoat.class, CraftSpruceChestBoat::new, CraftEntityTypes.createAndMove(net.minecraft.world.entity.EntityType.SPRUCE_CHEST_BOAT)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Marker, Marker>(EntityType.MARKER, org.bukkit.entity.Marker.class, CraftMarker::new, CraftEntityTypes.createAndSetPos(net.minecraft.world.entity.EntityType.MARKER)));
        CraftEntityTypes.register(new EntityTypeData<BlockDisplay, Display.BlockDisplay>(EntityType.BLOCK_DISPLAY, BlockDisplay.class, CraftBlockDisplay::new, CraftEntityTypes.createAndSetPos(net.minecraft.world.entity.EntityType.BLOCK_DISPLAY)));
        CraftEntityTypes.register(new EntityTypeData<org.bukkit.entity.Interaction, Interaction>(EntityType.INTERACTION, org.bukkit.entity.Interaction.class, CraftInteraction::new, CraftEntityTypes.createAndSetPos(net.minecraft.world.entity.EntityType.INTERACTION)));
        CraftEntityTypes.register(new EntityTypeData<ItemDisplay, Display.ItemDisplay>(EntityType.ITEM_DISPLAY, ItemDisplay.class, CraftItemDisplay::new, CraftEntityTypes.createAndSetPos(net.minecraft.world.entity.EntityType.ITEM_DISPLAY)));
        CraftEntityTypes.register(new EntityTypeData<TextDisplay, Display.TextDisplay>(EntityType.TEXT_DISPLAY, TextDisplay.class, CraftTextDisplay::new, CraftEntityTypes.createAndSetPos(net.minecraft.world.entity.EntityType.TEXT_DISPLAY)));
        CraftEntityTypes.register(new EntityTypeData<Item, ItemEntity>(EntityType.ITEM, Item.class, CraftItem::new, spawnData -> {
            ItemStack itemStack = new ItemStack(Items.STONE);
            ItemEntity item = new ItemEntity(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), itemStack);
            item.setPickUpDelay(10);
            return item;
        }));
        CraftEntityTypes.register(new EntityTypeData<ExperienceOrb, net.minecraft.world.entity.ExperienceOrb>(EntityType.EXPERIENCE_ORB, ExperienceOrb.class, CraftExperienceOrb::new, spawnData -> new net.minecraft.world.entity.ExperienceOrb(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), 0)));
        CraftEntityTypes.register(new EntityTypeData<AreaEffectCloud, net.minecraft.world.entity.AreaEffectCloud>(EntityType.AREA_EFFECT_CLOUD, AreaEffectCloud.class, CraftAreaEffectCloud::new, spawnData -> new net.minecraft.world.entity.AreaEffectCloud(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z())));
        CraftEntityTypes.register(new EntityTypeData<Egg, ThrownEgg>(EntityType.EGG, Egg.class, CraftEgg::new, spawnData -> new ThrownEgg(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), new ItemStack(Items.EGG))));
        CraftEntityTypes.register(new EntityTypeData<LeashHitch, LeashFenceKnotEntity>(EntityType.LEASH_KNOT, LeashHitch.class, CraftLeash::new, spawnData -> new LeashFenceKnotEntity(spawnData.minecraftWorld(), BlockPos.containing(spawnData.x(), spawnData.y(), spawnData.z()))));
        CraftEntityTypes.register(new EntityTypeData<Snowball, net.minecraft.world.entity.projectile.throwableitemprojectile.Snowball>(EntityType.SNOWBALL, Snowball.class, CraftSnowball::new, spawnData -> new net.minecraft.world.entity.projectile.throwableitemprojectile.Snowball(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), new ItemStack(Items.SNOWBALL))));
        CraftEntityTypes.register(new EntityTypeData<EnderSignal, EyeOfEnder>(EntityType.EYE_OF_ENDER, EnderSignal.class, CraftEnderSignal::new, spawnData -> new EyeOfEnder(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z())));
        CraftEntityTypes.register(new EntityTypeData<SplashPotion, AbstractThrownPotion>(EntityType.SPLASH_POTION, SplashPotion.class, CraftSplashPotion::new, spawnData -> {
            ThrownSplashPotion entity = new ThrownSplashPotion(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), new ItemStack(Items.SPLASH_POTION));
            return entity;
        }));
        CraftEntityTypes.register(new EntityTypeData<LingeringPotion, AbstractThrownPotion>(EntityType.LINGERING_POTION, LingeringPotion.class, CraftLingeringPotion::new, spawnData -> {
            ThrownLingeringPotion entity = new ThrownLingeringPotion(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), new ItemStack(Items.LINGERING_POTION));
            return entity;
        }));
        CraftEntityTypes.register(new EntityTypeData<TNTPrimed, PrimedTnt>(EntityType.TNT, TNTPrimed.class, CraftTNTPrimed::new, spawnData -> new PrimedTnt(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), null)));
        CraftEntityTypes.register(new EntityTypeData<FallingBlock, FallingBlockEntity>(EntityType.FALLING_BLOCK, FallingBlock.class, CraftFallingBlock::new, spawnData -> {
            BlockPos pos = BlockPos.containing(spawnData.x(), spawnData.y(), spawnData.z());
            return FallingBlockEntity.fall(spawnData.minecraftWorld(), pos, spawnData.world().getBlockState(pos));
        }));
        CraftEntityTypes.register(new EntityTypeData<Firework, FireworkRocketEntity>(EntityType.FIREWORK_ROCKET, Firework.class, CraftFirework::new, spawnData -> new FireworkRocketEntity(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), ItemStack.EMPTY)));
        CraftEntityTypes.register(new EntityTypeData<EvokerFangs, net.minecraft.world.entity.projectile.EvokerFangs>(EntityType.EVOKER_FANGS, EvokerFangs.class, CraftEvokerFangs::new, spawnData -> new net.minecraft.world.entity.projectile.EvokerFangs(spawnData.minecraftWorld(), spawnData.x(), spawnData.y(), spawnData.z(), (float)Math.toRadians(spawnData.yaw()), 0, null)));
        CraftEntityTypes.register(new EntityTypeData<CommandMinecart, MinecartCommandBlock>(EntityType.COMMAND_BLOCK_MINECART, CommandMinecart.class, CraftMinecartCommand::new, CraftEntityTypes.createMinecart(net.minecraft.world.entity.EntityType.COMMAND_BLOCK_MINECART)));
        CraftEntityTypes.register(new EntityTypeData<RideableMinecart, Minecart>(EntityType.MINECART, RideableMinecart.class, CraftMinecartRideable::new, CraftEntityTypes.createMinecart(net.minecraft.world.entity.EntityType.MINECART)));
        CraftEntityTypes.register(new EntityTypeData<StorageMinecart, MinecartChest>(EntityType.CHEST_MINECART, StorageMinecart.class, CraftMinecartChest::new, CraftEntityTypes.createMinecart(net.minecraft.world.entity.EntityType.CHEST_MINECART)));
        CraftEntityTypes.register(new EntityTypeData<PoweredMinecart, MinecartFurnace>(EntityType.FURNACE_MINECART, PoweredMinecart.class, CraftMinecartFurnace::new, CraftEntityTypes.createMinecart(net.minecraft.world.entity.EntityType.FURNACE_MINECART)));
        CraftEntityTypes.register(new EntityTypeData<ExplosiveMinecart, MinecartTNT>(EntityType.TNT_MINECART, ExplosiveMinecart.class, CraftMinecartTNT::new, CraftEntityTypes.createMinecart(net.minecraft.world.entity.EntityType.TNT_MINECART)));
        CraftEntityTypes.register(new EntityTypeData<HopperMinecart, MinecartHopper>(EntityType.HOPPER_MINECART, HopperMinecart.class, CraftMinecartHopper::new, CraftEntityTypes.createMinecart(net.minecraft.world.entity.EntityType.HOPPER_MINECART)));
        CraftEntityTypes.register(new EntityTypeData<SpawnerMinecart, MinecartSpawner>(EntityType.SPAWNER_MINECART, SpawnerMinecart.class, CraftMinecartMobSpawner::new, CraftEntityTypes.createMinecart(net.minecraft.world.entity.EntityType.SPAWNER_MINECART)));
        CraftEntityTypes.register(new EntityTypeData<FishHook, FishingHook>(EntityType.FISHING_BOBBER, FishHook.class, CraftFishHook::new, null));
        CraftEntityTypes.register(new EntityTypeData<Player, ServerPlayer>(EntityType.PLAYER, Player.class, CraftPlayer::new, null));
    }

    public record EntityTypeData<E extends Entity, M extends net.minecraft.world.entity.Entity>(EntityType entityType, Class<E> entityClass, BiFunction<CraftServer, M, E> convertFunction, Function<SpawnData, M> spawnFunction) {
    }

    public record SpawnData(WorldGenLevel world, Location location, boolean randomizeData, boolean normalWorld) {
        double x() {
            return this.location().getX();
        }

        double y() {
            return this.location().getY();
        }

        double z() {
            return this.location().getZ();
        }

        float yaw() {
            return this.location().getYaw();
        }

        float pitch() {
            return this.location().getPitch();
        }

        Level minecraftWorld() {
            return this.world().getMinecraftWorld();
        }
    }

    private record HangingData(boolean randomize, BlockPos position, Direction direction) {
    }
}

