/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.item.ItemEntity;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class CraftItem
extends CraftEntity
implements Item {
    public CraftItem(CraftServer server, ItemEntity entity) {
        super(server, entity);
    }

    @Override
    public ItemEntity getHandle() {
        return (ItemEntity)this.entity;
    }

    public ItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.getHandle().getItem());
    }

    public void setItemStack(ItemStack stack) {
        this.getHandle().setItem(CraftItemStack.asNMSCopy(stack));
    }

    public int getPickupDelay() {
        return this.getHandle().pickupDelay;
    }

    public void setPickupDelay(int delay) {
        this.getHandle().pickupDelay = Math.min(delay, Short.MAX_VALUE);
    }

    public void setUnlimitedLifetime(boolean unlimited) {
        this.getHandle().age = unlimited ? Short.MIN_VALUE : this.getTicksLived();
    }

    public boolean isUnlimitedLifetime() {
        return this.getHandle().age == Short.MIN_VALUE;
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        if (!this.isUnlimitedLifetime()) {
            this.getHandle().age = value;
        }
    }

    public void setOwner(UUID uuid) {
        this.getHandle().setTarget(uuid);
    }

    public UUID getOwner() {
        return this.getHandle().target;
    }

    public void setThrower(UUID uuid) {
        this.getHandle().thrower = uuid != null ? EntityReference.of(uuid) : null;
    }

    public UUID getThrower() {
        EntityReference<Entity> thrower = this.getHandle().thrower;
        return thrower != null ? thrower.getUUID() : null;
    }

    @Override
    public String toString() {
        return "CraftItem";
    }
}

