/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class CraftItemFrame
extends CraftHanging
implements org.bukkit.entity.ItemFrame {
    public CraftItemFrame(CraftServer server, ItemFrame entity) {
        super(server, entity);
    }

    @Override
    public boolean setFacingDirection(BlockFace face, boolean force) {
        ItemFrame hanging = this.getHandle();
        Direction oldDir = hanging.getDirection();
        Direction newDir = CraftBlock.blockFaceToNotch(face);
        Preconditions.checkArgument((newDir != null ? 1 : 0) != 0, (String)"%s is not a valid facing direction", (Object)face);
        this.getHandle().setDirection(newDir);
        if (!(force || this.getHandle().generation || ((HangingEntity)hanging).survives())) {
            ((HangingEntity)hanging).setDirection(oldDir);
            return false;
        }
        this.update();
        return true;
    }

    @Override
    protected void update() {
        super.update();
        this.getHandle().getEntityData().markDirty(ItemFrame.DATA_ITEM);
        this.getHandle().getEntityData().markDirty(ItemFrame.DATA_ROTATION);
        if (!this.getHandle().generation) {
            this.getHandle().level().updateNeighbourForOutputSignal(this.getHandle().getPos(), Blocks.AIR);
        }
    }

    public void setItem(ItemStack item) {
        this.setItem(item, true);
    }

    public void setItem(ItemStack item, boolean playSound) {
        this.getHandle().setItem(CraftItemStack.asNMSCopy(item), !this.getHandle().generation, !this.getHandle().generation && playSound);
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().getItem());
    }

    public float getItemDropChance() {
        return this.getHandle().dropChance;
    }

    public void setItemDropChance(float chance) {
        Preconditions.checkArgument((0.0 <= (double)chance && (double)chance <= 1.0 ? 1 : 0) != 0, (String)"Chance (%s) outside range [0, 1]", (Object)Float.valueOf(chance));
        this.getHandle().dropChance = chance;
    }

    public Rotation getRotation() {
        return this.toBukkitRotation(this.getHandle().getRotation());
    }

    Rotation toBukkitRotation(int value) {
        switch (value) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_45;
            }
            case 2: {
                return Rotation.CLOCKWISE;
            }
            case 3: {
                return Rotation.CLOCKWISE_135;
            }
            case 4: {
                return Rotation.FLIPPED;
            }
            case 5: {
                return Rotation.FLIPPED_45;
            }
            case 6: {
                return Rotation.COUNTER_CLOCKWISE;
            }
            case 7: {
                return Rotation.COUNTER_CLOCKWISE_45;
            }
        }
        throw new AssertionError((Object)("Unknown rotation " + value + " for " + String.valueOf(this.getHandle())));
    }

    public void setRotation(Rotation rotation) {
        Preconditions.checkArgument((rotation != null ? 1 : 0) != 0, (Object)"Rotation cannot be null");
        this.getHandle().setRotation(CraftItemFrame.toInteger(rotation));
    }

    static int toInteger(Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_45: {
                return 1;
            }
            case CLOCKWISE: {
                return 2;
            }
            case CLOCKWISE_135: {
                return 3;
            }
            case FLIPPED: {
                return 4;
            }
            case FLIPPED_45: {
                return 5;
            }
            case COUNTER_CLOCKWISE: {
                return 6;
            }
            case COUNTER_CLOCKWISE_45: {
                return 7;
            }
        }
        throw new IllegalArgumentException(String.valueOf(rotation) + " is not applicable to an ItemFrame");
    }

    public boolean isVisible() {
        return !this.getHandle().isInvisible();
    }

    public void setVisible(boolean visible) {
        this.getHandle().setInvisible(!visible);
    }

    public boolean isFixed() {
        return this.getHandle().fixed;
    }

    public void setFixed(boolean fixed) {
        this.getHandle().fixed = fixed;
    }

    @Override
    public ItemFrame getHandle() {
        return (ItemFrame)this.entity;
    }

    @Override
    public String toString() {
        return "CraftItemFrame{item=" + String.valueOf(this.getItem()) + ", rotation=" + String.valueOf(this.getRotation()) + "}";
    }
}

