/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.JukeboxSongs;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.item.component.SwingAnimation;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseEffects;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.Overridden;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R7.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemFlag;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaArmor;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaOminousBottle;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaShield;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.v1_21_R7.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftAttackRangeComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftBlocksAttacksComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftCustomModelDataComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftEquippableComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftFoodComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftJukeboxComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftKineticWeaponComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftPiercingWeaponComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftSwingAnimationComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftUseCooldownComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftUseEffectsComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftWeaponComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.consumable.CraftConsumableComponent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.tags.DeprecatedCustomTagContainer;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R7.tag.CraftDamageTag;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNBTTagConfigSerializer;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.components.AttackRangeComponent;
import org.bukkit.inventory.meta.components.BlocksAttacksComponent;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.KineticWeaponComponent;
import org.bukkit.inventory.meta.components.PiercingWeaponComponent;
import org.bukkit.inventory.meta.components.SwingAnimationComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.bukkit.inventory.meta.components.UseEffectsComponent;
import org.bukkit.inventory.meta.components.WeaponComponent;
import org.bukkit.inventory.meta.components.consumable.ConsumableComponent;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.tag.DamageTypeTags;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaItem
implements ItemMeta,
Damageable,
Repairable,
BlockDataMeta {
    static final ItemMetaKeyType<Component> NAME = new ItemMetaKeyType<Component>(DataComponents.CUSTOM_NAME, "display-name");
    static final ItemMetaKeyType<Component> ITEM_NAME = new ItemMetaKeyType<Component>(DataComponents.ITEM_NAME, "item-name");
    static final ItemMetaKeyType<ItemLore> LORE = new ItemMetaKeyType<ItemLore>(DataComponents.LORE, "lore");
    static final ItemMetaKeyType<CustomModelData> CUSTOM_MODEL_DATA = new ItemMetaKeyType<CustomModelData>(DataComponents.CUSTOM_MODEL_DATA, "custom-model-data");
    static final ItemMetaKeyType<Enchantable> ENCHANTABLE = new ItemMetaKeyType<Enchantable>(DataComponents.ENCHANTABLE, "enchantable");
    static final ItemMetaKeyType<ItemEnchantments> ENCHANTMENTS = new ItemMetaKeyType<ItemEnchantments>(DataComponents.ENCHANTMENTS, "enchants");
    static final ItemMetaKeyType<Integer> REPAIR = new ItemMetaKeyType<Integer>(DataComponents.REPAIR_COST, "repair-cost");
    static final ItemMetaKeyType<ItemAttributeModifiers> ATTRIBUTES = new ItemMetaKeyType<ItemAttributeModifiers>(DataComponents.ATTRIBUTE_MODIFIERS, "attribute-modifiers");
    static final ItemMetaKey ATTRIBUTES_IDENTIFIER = new ItemMetaKey("AttributeName");
    static final ItemMetaKey ATTRIBUTES_SLOT = new ItemMetaKey("Slot");
    static final ItemMetaKeyType<TooltipDisplay> HIDEFLAGS = new ItemMetaKeyType<TooltipDisplay>(DataComponents.TOOLTIP_DISPLAY, "ItemFlags");
    static final ItemMetaKey HIDE_TOOLTIP = new ItemMetaKey("hide-tool-tip");
    static final ItemMetaKeyType<Identifier> TOOLTIP_STYLE = new ItemMetaKeyType<Identifier>(DataComponents.TOOLTIP_STYLE, "tool-tip-style");
    static final ItemMetaKeyType<Identifier> ITEM_MODEL = new ItemMetaKeyType<Identifier>(DataComponents.ITEM_MODEL, "item-model");
    static final ItemMetaKeyType<Unit> UNBREAKABLE = new ItemMetaKeyType<Unit>(DataComponents.UNBREAKABLE, "Unbreakable");
    static final ItemMetaKeyType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = new ItemMetaKeyType<Boolean>(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, "enchantment-glint-override");
    static final ItemMetaKeyType<Unit> GLIDER = new ItemMetaKeyType<Unit>(DataComponents.GLIDER, "glider");
    static final ItemMetaKeyType<DamageResistant> DAMAGE_RESISTANT = new ItemMetaKeyType<DamageResistant>(DataComponents.DAMAGE_RESISTANT, "damage-resistant");
    static final ItemMetaKeyType<EitherHolder<DamageType>> DAMAGE_TYPE = new ItemMetaKeyType<EitherHolder<DamageType>>(DataComponents.DAMAGE_TYPE, "damage-type");
    static final ItemMetaKeyType<Integer> MAX_STACK_SIZE = new ItemMetaKeyType<Integer>(DataComponents.MAX_STACK_SIZE, "max-stack-size");
    static final ItemMetaKeyType<Rarity> RARITY = new ItemMetaKeyType<Rarity>(DataComponents.RARITY, "rarity");
    static final ItemMetaKeyType<UseRemainder> USE_REMAINDER = new ItemMetaKeyType<UseRemainder>(DataComponents.USE_REMAINDER, "use-remainder");
    static final ItemMetaKeyType<UseCooldown> USE_COOLDOWN = new ItemMetaKeyType<UseCooldown>(DataComponents.USE_COOLDOWN, "use-cooldown");
    static final ItemMetaKeyType<UseEffects> USE_EFFECTS = new ItemMetaKeyType<UseEffects>(DataComponents.USE_EFFECTS, "use-effects");
    static final ItemMetaKeyType<SwingAnimation> SWING_ANIMATION = new ItemMetaKeyType<SwingAnimation>(DataComponents.SWING_ANIMATION, "swing-animation");
    static final ItemMetaKeyType<AttackRange> ATTACK_RANGE = new ItemMetaKeyType<AttackRange>(DataComponents.ATTACK_RANGE, "attack-range");
    static final ItemMetaKeyType<PiercingWeapon> PIERCING_WEAPON = new ItemMetaKeyType<PiercingWeapon>(DataComponents.PIERCING_WEAPON, "piercing-weapon");
    static final ItemMetaKeyType<KineticWeapon> KINETIC_WEAPON = new ItemMetaKeyType<KineticWeapon>(DataComponents.KINETIC_WEAPON, "kinetic-weapon");
    static final ItemMetaKeyType<FoodProperties> FOOD = new ItemMetaKeyType<FoodProperties>(DataComponents.FOOD, "food");
    static final ItemMetaKeyType<Consumable> CONSUMABLE = new ItemMetaKeyType<Consumable>(DataComponents.CONSUMABLE, "consumable");
    static final ItemMetaKeyType<Tool> TOOL = new ItemMetaKeyType<Tool>(DataComponents.TOOL, "tool");
    static final ItemMetaKeyType<BlocksAttacks> BLOCKS_ATTACKS = new ItemMetaKeyType<BlocksAttacks>(DataComponents.BLOCKS_ATTACKS, "blocks-attacks");
    static final ItemMetaKeyType<Weapon> WEAPON = new ItemMetaKeyType<Weapon>(DataComponents.WEAPON, "weapon");
    static final ItemMetaKeyType<Equippable> EQUIPPABLE = new ItemMetaKeyType<Equippable>(DataComponents.EQUIPPABLE, "equippable");
    static final ItemMetaKeyType<JukeboxPlayable> JUKEBOX_PLAYABLE = new ItemMetaKeyType<JukeboxPlayable>(DataComponents.JUKEBOX_PLAYABLE, "jukebox-playable");
    static final ItemMetaKeyType<Holder<SoundEvent>> BREAK_SOUND = new ItemMetaKeyType<Holder<SoundEvent>>(DataComponents.BREAK_SOUND, "break-sound");
    static final ItemMetaKeyType<Integer> DAMAGE = new ItemMetaKeyType<Integer>(DataComponents.DAMAGE, "Damage");
    static final ItemMetaKeyType<Integer> MAX_DAMAGE = new ItemMetaKeyType<Integer>(DataComponents.MAX_DAMAGE, "max-damage");
    static final ItemMetaKeyType<Float> MINIMUM_ATTACK_CHARGE = new ItemMetaKeyType<Float>(DataComponents.MINIMUM_ATTACK_CHARGE, "minimum-attack-charge");
    static final ItemMetaKeyType<BlockItemStateProperties> BLOCK_DATA = new ItemMetaKeyType<BlockItemStateProperties>(DataComponents.BLOCK_STATE, "BlockStateTag");
    static final ItemMetaKey BUKKIT_CUSTOM_TAG = new ItemMetaKey("PublicBukkitValues");
    static final ItemMetaKeyType<CustomData> CUSTOM_DATA = new ItemMetaKeyType<CustomData>(DataComponents.CUSTOM_DATA);
    private Component displayName;
    private Component itemName;
    private List<Component> lore;
    private CraftCustomModelDataComponent customModelData;
    private Integer enchantableValue;
    private Map<String, String> blockData;
    private Map<Enchantment, Integer> enchantments;
    private Multimap<Attribute, org.bukkit.attribute.AttributeModifier> attributeModifiers;
    private int repairCost;
    private SequencedSet<DataComponentType<?>> hiddenComponents;
    private boolean hideTooltip;
    private NamespacedKey tooltipStyle;
    private NamespacedKey itemModel;
    private boolean unbreakable;
    private Boolean enchantmentGlintOverride;
    private boolean glider;
    private TagKey<DamageType> damageResistant;
    private EitherHolder<DamageType> damageType;
    private Integer maxStackSize;
    private ItemRarity rarity;
    private ItemStack useRemainder;
    private CraftUseCooldownComponent useCooldown;
    private CraftUseEffectsComponent useEffects;
    private CraftSwingAnimationComponent swingAnimation;
    private CraftAttackRangeComponent attackRange;
    private CraftPiercingWeaponComponent piercingWeapon;
    private CraftKineticWeaponComponent kineticWeapon;
    private CraftFoodComponent food;
    private CraftConsumableComponent consumable;
    private CraftToolComponent tool;
    private CraftBlocksAttacksComponent blocksAttacks;
    private CraftWeaponComponent weapon;
    private CraftEquippableComponent equippable;
    private CraftJukeboxComponent jukebox;
    private Holder<SoundEvent> breakSound;
    private int damage;
    private Integer maxDamage;
    private Float minimumAttackCharge;
    private static final Set<DataComponentType> HANDLED_TAGS = Sets.newHashSet();
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private CompoundTag customTag;
    protected DataComponentPatch.Builder unhandledTags = DataComponentPatch.builder();
    private Set<DataComponentType<?>> removedTags = Sets.newHashSet();
    private CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private int version = CraftMagicNumbers.INSTANCE.getDataVersion();

    CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            return;
        }
        this.displayName = meta.displayName;
        this.itemName = meta.itemName;
        if (meta.lore != null) {
            this.lore = new ArrayList<Component>(meta.lore);
        }
        if (meta.hasCustomModelDataComponent()) {
            this.customModelData = new CraftCustomModelDataComponent(meta.customModelData);
        }
        this.enchantableValue = meta.enchantableValue;
        this.blockData = meta.blockData;
        if (meta.enchantments != null) {
            this.enchantments = new LinkedHashMap<Enchantment, Integer>(meta.enchantments);
        }
        if (meta.hasAttributeModifiers()) {
            this.attributeModifiers = LinkedHashMultimap.create(meta.attributeModifiers);
        }
        this.repairCost = meta.repairCost;
        if (meta.hasItemFlags()) {
            this.hiddenComponents = new LinkedHashSet(meta.hiddenComponents);
        }
        this.hideTooltip = meta.hideTooltip;
        this.tooltipStyle = meta.tooltipStyle;
        this.itemModel = meta.itemModel;
        this.unbreakable = meta.unbreakable;
        this.enchantmentGlintOverride = meta.enchantmentGlintOverride;
        this.glider = meta.glider;
        this.damageResistant = meta.damageResistant;
        this.damageType = meta.damageType;
        this.maxStackSize = meta.maxStackSize;
        this.rarity = meta.rarity;
        if (meta.hasUseRemainder()) {
            this.useRemainder = meta.useRemainder.clone();
        }
        if (meta.hasUseCooldown()) {
            this.useCooldown = new CraftUseCooldownComponent(meta.useCooldown);
        }
        if (meta.hasUseEffects()) {
            this.useEffects = new CraftUseEffectsComponent(meta.useEffects);
        }
        if (meta.hasSwingAnimation()) {
            this.swingAnimation = new CraftSwingAnimationComponent(meta.swingAnimation);
        }
        if (meta.hasAttackRange()) {
            this.attackRange = new CraftAttackRangeComponent(meta.attackRange);
        }
        if (meta.hasPiercingWeapon()) {
            this.piercingWeapon = new CraftPiercingWeaponComponent(meta.piercingWeapon);
        }
        if (meta.hasKineticWeapon()) {
            this.kineticWeapon = new CraftKineticWeaponComponent(meta.kineticWeapon);
        }
        if (meta.hasFood()) {
            this.food = new CraftFoodComponent(meta.food);
        }
        if (meta.hasConsumable()) {
            this.consumable = new CraftConsumableComponent(meta.consumable);
        }
        if (meta.hasTool()) {
            this.tool = new CraftToolComponent(meta.tool);
        }
        if (meta.hasBlocksAttacks()) {
            this.blocksAttacks = new CraftBlocksAttacksComponent(meta.blocksAttacks);
        }
        if (meta.hasWeapon()) {
            this.weapon = new CraftWeaponComponent(meta.weapon);
        }
        if (meta.hasEquippable()) {
            this.equippable = new CraftEquippableComponent(meta.equippable);
        }
        if (meta.hasJukeboxPlayable()) {
            this.jukebox = new CraftJukeboxComponent(meta.jukebox);
        }
        this.breakSound = meta.breakSound;
        this.damage = meta.damage;
        this.maxDamage = meta.maxDamage;
        this.minimumAttackCharge = meta.minimumAttackCharge;
        this.unhandledTags.copy(meta.unhandledTags.build());
        this.removedTags.addAll(meta.removedTags);
        this.persistentDataContainer.putAll(meta.persistentDataContainer.getRaw());
        this.customTag = meta.customTag;
        this.version = meta.version;
    }

    CraftMetaItem(DataComponentPatch tag) {
        CraftMetaItem.getOrEmpty(tag, NAME).ifPresent(component -> {
            this.displayName = component;
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_NAME).ifPresent(component -> {
            this.itemName = component;
        });
        CraftMetaItem.getOrEmpty(tag, LORE).ifPresent(l -> {
            List<Component> list = l.lines();
            this.lore = new ArrayList<Component>(list.size());
            for (int index = 0; index < list.size(); ++index) {
                Component line = list.get(index);
                this.lore.add(line);
            }
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_MODEL_DATA).ifPresent(i -> {
            this.customModelData = new CraftCustomModelDataComponent((CustomModelData)i);
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTABLE).ifPresent(i -> {
            this.enchantableValue = i.value();
        });
        CraftMetaItem.getOrEmpty(tag, BLOCK_DATA).ifPresent(t -> {
            this.blockData = t.properties();
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENTS).ifPresent(en -> {
            this.enchantments = CraftMetaItem.buildEnchantments(en);
        });
        CraftMetaItem.getOrEmpty(tag, ATTRIBUTES).ifPresent(en -> {
            this.attributeModifiers = CraftMetaItem.buildModifiers(en);
        });
        CraftMetaItem.getOrEmpty(tag, REPAIR).ifPresent(i -> {
            this.repairCost = i;
        });
        CraftMetaItem.getOrEmpty(tag, HIDEFLAGS).ifPresent(h -> {
            for (DataComponentType dataComponentType : h.hiddenComponents()) {
                ItemFlag flag = CraftItemFlag.nmsToBukkit(dataComponentType);
                if (flag == null) continue;
                this.addItemFlags(flag);
            }
            this.hideTooltip = h.hideTooltip();
        });
        CraftMetaItem.getOrEmpty(tag, TOOLTIP_STYLE).ifPresent(key -> {
            this.tooltipStyle = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_MODEL).ifPresent(key -> {
            this.itemModel = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, UNBREAKABLE).ifPresent(u -> {
            this.unbreakable = true;
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENT_GLINT_OVERRIDE).ifPresent(override -> {
            this.enchantmentGlintOverride = override;
        });
        CraftMetaItem.getOrEmpty(tag, GLIDER).ifPresent(u -> {
            this.glider = true;
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE_RESISTANT).ifPresent(tags -> {
            this.damageResistant = tags.types();
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE_TYPE).ifPresent(tags -> {
            this.damageType = tags;
        });
        CraftMetaItem.getOrEmpty(tag, MAX_STACK_SIZE).ifPresent(i -> {
            this.maxStackSize = i;
        });
        CraftMetaItem.getOrEmpty(tag, RARITY).ifPresent(enumItemRarity -> {
            this.rarity = ItemRarity.valueOf((String)enumItemRarity.name());
        });
        CraftMetaItem.getOrEmpty(tag, USE_REMAINDER).ifPresent(remainder -> {
            this.useRemainder = CraftItemStack.asCraftMirror(remainder.convertInto());
        });
        CraftMetaItem.getOrEmpty(tag, USE_COOLDOWN).ifPresent(cooldown -> {
            this.useCooldown = new CraftUseCooldownComponent((UseCooldown)cooldown);
        });
        CraftMetaItem.getOrEmpty(tag, USE_EFFECTS).ifPresent(effects -> {
            this.useEffects = new CraftUseEffectsComponent((UseEffects)effects);
        });
        CraftMetaItem.getOrEmpty(tag, SWING_ANIMATION).ifPresent(animation -> {
            this.swingAnimation = new CraftSwingAnimationComponent((SwingAnimation)animation);
        });
        CraftMetaItem.getOrEmpty(tag, ATTACK_RANGE).ifPresent(range -> {
            this.attackRange = new CraftAttackRangeComponent((AttackRange)range);
        });
        CraftMetaItem.getOrEmpty(tag, PIERCING_WEAPON).ifPresent(piercing -> {
            this.piercingWeapon = new CraftPiercingWeaponComponent((PiercingWeapon)piercing);
        });
        CraftMetaItem.getOrEmpty(tag, KINETIC_WEAPON).ifPresent(kinetic -> {
            this.kineticWeapon = new CraftKineticWeaponComponent((KineticWeapon)kinetic);
        });
        CraftMetaItem.getOrEmpty(tag, FOOD).ifPresent(foodInfo -> {
            this.food = new CraftFoodComponent((FoodProperties)foodInfo);
        });
        CraftMetaItem.getOrEmpty(tag, CONSUMABLE).ifPresent(consumableInfo -> {
            this.consumable = new CraftConsumableComponent((Consumable)consumableInfo);
        });
        CraftMetaItem.getOrEmpty(tag, TOOL).ifPresent(toolInfo -> {
            this.tool = new CraftToolComponent((Tool)toolInfo);
        });
        CraftMetaItem.getOrEmpty(tag, BLOCKS_ATTACKS).ifPresent(blocksInfo -> {
            this.blocksAttacks = new CraftBlocksAttacksComponent((BlocksAttacks)blocksInfo);
        });
        CraftMetaItem.getOrEmpty(tag, WEAPON).ifPresent(weaponInfo -> {
            this.weapon = new CraftWeaponComponent((Weapon)weaponInfo);
        });
        CraftMetaItem.getOrEmpty(tag, EQUIPPABLE).ifPresent(equippableInfo -> {
            this.equippable = new CraftEquippableComponent((Equippable)equippableInfo);
        });
        CraftMetaItem.getOrEmpty(tag, JUKEBOX_PLAYABLE).ifPresent(jukeboxPlayable -> {
            this.jukebox = new CraftJukeboxComponent((JukeboxPlayable)jukeboxPlayable);
        });
        CraftMetaItem.getOrEmpty(tag, BREAK_SOUND).ifPresent(sound -> {
            this.breakSound = sound;
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE).ifPresent(i -> {
            this.damage = i;
        });
        CraftMetaItem.getOrEmpty(tag, MAX_DAMAGE).ifPresent(i -> {
            this.maxDamage = i;
        });
        CraftMetaItem.getOrEmpty(tag, MINIMUM_ATTACK_CHARGE).ifPresent(f -> {
            this.minimumAttackCharge = f;
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_DATA).ifPresent(customData -> {
            this.customTag = customData.copyTag();
            this.customTag.getCompound(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT).ifPresent(compound -> {
                Set<String> keys = compound.keySet();
                for (String key : keys) {
                    this.persistentDataContainer.put(key, compound.get(key).copy());
                }
                this.customTag.remove(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
            });
            if (this.customTag.isEmpty()) {
                this.customTag = null;
            }
        });
        Set<Map.Entry<DataComponentType<?>, Optional<?>>> keys = tag.entrySet();
        for (Map.Entry<DataComponentType<?>, Optional<?>> key2 : keys) {
            if (!CraftMetaItem.getHandledTags().contains(key2.getKey())) {
                key2.getValue().ifPresent(value -> this.unhandledTags.set((DataComponentType)key2.getKey(), value));
            }
            if (!key2.getValue().isEmpty()) continue;
            this.removedTags.add(key2.getKey());
        }
    }

    static Map<Enchantment, Integer> buildEnchantments(ItemEnchantments tag) {
        LinkedHashMap<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>(tag.size());
        tag.entrySet().forEach(entry -> {
            Holder id = (Holder)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CraftEnchantment.minecraftHolderToBukkit(id);
            if (enchant != null) {
                enchantments.put(enchant, level);
            }
        });
        return enchantments;
    }

    static Multimap<Attribute, org.bukkit.attribute.AttributeModifier> buildModifiers(ItemAttributeModifiers tag) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        List<ItemAttributeModifiers.Entry> mods = tag.modifiers();
        int size = mods.size();
        for (int i = 0; i < size; ++i) {
            ItemAttributeModifiers.Entry entry = mods.get(i);
            AttributeModifier nmsModifier = entry.modifier();
            if (nmsModifier == null) continue;
            org.bukkit.attribute.AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            Attribute attribute = CraftAttribute.minecraftHolderToBukkit(entry.attribute());
            if (attribute == null) continue;
            if (entry.slot() != null) {
                EquipmentSlotGroup slotName = entry.slot();
                if (slotName == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                org.bukkit.inventory.EquipmentSlotGroup slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlot(slotName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new org.bukkit.attribute.AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot);
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    CraftMetaItem(Map<String, Object> map) {
        String custom;
        Object nbtMap;
        Iterable removed;
        String unhandled;
        String internal;
        Float minimumAttackCharge;
        Integer maxDamage;
        Integer damage;
        String snd;
        CraftJukeboxComponent jukeboxPlayable;
        CraftEquippableComponent equippable;
        CraftWeaponComponent weapon;
        CraftBlocksAttacksComponent blocksAttacks;
        CraftToolComponent tool;
        CraftConsumableComponent consumable;
        CraftFoodComponent food;
        CraftKineticWeaponComponent kineticWeapon;
        CraftPiercingWeaponComponent piercingWeapon;
        CraftAttackRangeComponent attackRange;
        CraftSwingAnimationComponent swingAnimation;
        CraftUseEffectsComponent useEffects;
        CraftUseCooldownComponent cooldown;
        ItemStack remainder;
        String rarity;
        Integer maxStackSize;
        String damageType;
        Tag tag;
        String damageResistant;
        Boolean glider;
        Boolean enchantmentGlintOverride;
        Boolean unbreakable;
        String itemModel;
        String tooltipStyle;
        Boolean bl;
        Iterable hideFlags;
        Object blockData;
        Object customModelData;
        this.displayName = CraftChatMessage.fromJSONOrString(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true), true, false);
        this.itemName = CraftChatMessage.fromJSONOrNull(SerializableMeta.getString(map, CraftMetaItem.ITEM_NAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<Component>();
            CraftMetaItem.safelyAdd(lore, this.lore, true);
        }
        if ((customModelData = SerializableMeta.getObject(Object.class, map, CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, true)) instanceof CustomModelDataComponent) {
            CustomModelDataComponent component = (CustomModelDataComponent)customModelData;
            this.setCustomModelDataComponent(component);
        } else {
            this.setCustomModelData((Integer)customModelData);
        }
        Integer enchantmentValue = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.ENCHANTABLE.BUKKIT, true);
        if (enchantmentValue != null) {
            this.setEnchantable(enchantmentValue);
        }
        if ((blockData = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BLOCK_DATA.BUKKIT, true)) != null) {
            HashMap<String, String> mapBlockData = new HashMap<String, String>();
            if (blockData instanceof Map) {
                for (Map.Entry entry : ((Map)blockData).entrySet()) {
                    mapBlockData.put(entry.getKey().toString(), entry.getValue().toString());
                }
            } else {
                CompoundTag nbtBlockData = (CompoundTag)CraftNBTTagConfigSerializer.deserialize(blockData);
                for (String key : nbtBlockData.keySet()) {
                    mapBlockData.put(key, nbtBlockData.getStringOr(key, ""));
                }
            }
            this.blockData = mapBlockData;
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        this.attributeModifiers = CraftMetaItem.buildModifiers(map, ATTRIBUTES);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
        if ((hideFlags = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.HIDEFLAGS.BUKKIT, true)) != null) {
            for (Object hideFlagObject : hideFlags) {
                String hideFlagString = (String)hideFlagObject;
                try {
                    ItemFlag hideFlatEnum = CraftItemFlag.stringToBukkit(hideFlagString);
                    this.addItemFlags(hideFlatEnum);
                }
                catch (IllegalArgumentException hideFlatEnum) {}
            }
        }
        if ((bl = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.HIDE_TOOLTIP.BUKKIT, true)) != null) {
            this.setHideTooltip(bl);
        }
        if ((tooltipStyle = SerializableMeta.getString(map, CraftMetaItem.TOOLTIP_STYLE.BUKKIT, true)) != null) {
            this.setTooltipStyle(NamespacedKey.fromString((String)tooltipStyle));
        }
        if ((itemModel = SerializableMeta.getString(map, CraftMetaItem.ITEM_MODEL.BUKKIT, true)) != null) {
            this.setItemModel(NamespacedKey.fromString((String)itemModel));
        }
        if ((unbreakable = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.UNBREAKABLE.BUKKIT, true)) != null) {
            this.setUnbreakable(unbreakable);
        }
        if ((enchantmentGlintOverride = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, true)) != null) {
            this.setEnchantmentGlintOverride(enchantmentGlintOverride);
        }
        if ((glider = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.GLIDER.BUKKIT, true)) != null) {
            this.setGlider(glider);
        }
        if ((damageResistant = SerializableMeta.getString(map, CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, true)) != null && (tag = Bukkit.getTag((String)"damage_types", (NamespacedKey)NamespacedKey.fromString((String)damageResistant), org.bukkit.damage.DamageType.class)) != null) {
            this.setDamageResistant((Tag<org.bukkit.damage.DamageType>)tag);
        }
        if ((damageType = SerializableMeta.getString(map, CraftMetaItem.DAMAGE_TYPE.BUKKIT, true)) != null) {
            this.setDamageTypeKey(NamespacedKey.fromString((String)damageType));
        }
        if ((maxStackSize = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_STACK_SIZE.BUKKIT, true)) != null) {
            this.setMaxStackSize(maxStackSize);
        }
        if ((rarity = SerializableMeta.getString(map, CraftMetaItem.RARITY.BUKKIT, true)) != null) {
            this.setRarity(ItemRarity.valueOf((String)rarity));
        }
        if ((remainder = SerializableMeta.getObject(ItemStack.class, map, CraftMetaItem.USE_REMAINDER.BUKKIT, true)) != null) {
            this.setUseRemainder(remainder);
        }
        if ((cooldown = SerializableMeta.getObject(CraftUseCooldownComponent.class, map, CraftMetaItem.USE_COOLDOWN.BUKKIT, true)) != null) {
            this.setUseCooldown(cooldown);
        }
        if ((useEffects = SerializableMeta.getObject(CraftUseEffectsComponent.class, map, CraftMetaItem.USE_EFFECTS.BUKKIT, true)) != null) {
            this.setUseEffects(useEffects);
        }
        if ((swingAnimation = SerializableMeta.getObject(CraftSwingAnimationComponent.class, map, CraftMetaItem.SWING_ANIMATION.BUKKIT, true)) != null) {
            this.setSwingAnimation(swingAnimation);
        }
        if ((attackRange = SerializableMeta.getObject(CraftAttackRangeComponent.class, map, CraftMetaItem.ATTACK_RANGE.BUKKIT, true)) != null) {
            this.setAttackRange(attackRange);
        }
        if ((piercingWeapon = SerializableMeta.getObject(CraftPiercingWeaponComponent.class, map, CraftMetaItem.PIERCING_WEAPON.BUKKIT, true)) != null) {
            this.setPiercingWeapon(piercingWeapon);
        }
        if ((kineticWeapon = SerializableMeta.getObject(CraftKineticWeaponComponent.class, map, CraftMetaItem.KINETIC_WEAPON.BUKKIT, true)) != null) {
            this.setKineticWeapon(kineticWeapon);
        }
        if ((food = SerializableMeta.getObject(CraftFoodComponent.class, map, CraftMetaItem.FOOD.BUKKIT, true)) != null) {
            this.setFood(food);
        }
        if ((consumable = SerializableMeta.getObject(CraftConsumableComponent.class, map, CraftMetaItem.CONSUMABLE.BUKKIT, true)) != null) {
            this.setConsumable(consumable);
        }
        if ((tool = SerializableMeta.getObject(CraftToolComponent.class, map, CraftMetaItem.TOOL.BUKKIT, true)) != null) {
            this.setTool(tool);
        }
        if ((blocksAttacks = SerializableMeta.getObject(CraftBlocksAttacksComponent.class, map, CraftMetaItem.BLOCKS_ATTACKS.BUKKIT, true)) != null) {
            this.setBlocksAttacks(blocksAttacks);
        }
        if ((weapon = SerializableMeta.getObject(CraftWeaponComponent.class, map, CraftMetaItem.WEAPON.BUKKIT, true)) != null) {
            this.setWeapon(weapon);
        }
        if ((equippable = SerializableMeta.getObject(CraftEquippableComponent.class, map, CraftMetaItem.EQUIPPABLE.BUKKIT, true)) != null) {
            this.setEquippable(equippable);
        }
        if ((jukeboxPlayable = SerializableMeta.getObject(CraftJukeboxComponent.class, map, CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, true)) != null) {
            this.setJukeboxPlayable(jukeboxPlayable);
        }
        if ((snd = SerializableMeta.getString(map, "break-sound", true)) != null) {
            this.setBreakSound((Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)snd)));
        }
        if ((damage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.DAMAGE.BUKKIT, true)) != null) {
            this.setDamage(damage);
        }
        if ((maxDamage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_DAMAGE.BUKKIT, true)) != null) {
            this.setMaxDamage(maxDamage);
        }
        if ((minimumAttackCharge = SerializableMeta.getObject(Float.class, map, CraftMetaItem.MINIMUM_ATTACK_CHARGE.BUKKIT, true)) != null) {
            this.setMinimumAttackCharge(minimumAttackCharge);
        }
        if ((internal = SerializableMeta.getString(map, "internal", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(internal));
            try {
                CompoundTag internalTag = NbtIo.readCompressed(buf, NbtAccounter.unlimitedHeap());
                this.deserializeInternal(internalTag, map);
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((unhandled = SerializableMeta.getString(map, "unhandled", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(unhandled));
            try {
                CompoundTag unhandledTag = NbtIo.readCompressed(buf, NbtAccounter.unlimitedHeap());
                DataComponentPatch unhandledPatch = (DataComponentPatch)DataComponentPatch.CODEC.parse(MinecraftServer.getDefaultRegistryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)unhandledTag).result().get();
                this.unhandledTags.copy(unhandledPatch);
                for (Map.Entry entry : unhandledPatch.entrySet()) {
                    if (((Optional)entry.getValue()).isPresent()) continue;
                    DataComponentType key = (DataComponentType)entry.getKey();
                    this.unhandledTags.clear(key);
                    this.removedTags.add(key);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((removed = SerializableMeta.getObject(Iterable.class, map, "removed", true)) != null) {
            RegistryAccess registryAccess = CraftRegistry.getMinecraftRegistry();
            HolderLookup.RegistryLookup componentTypeRegistry = registryAccess.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
            for (Object t : removed) {
                String removedString = (String)t;
                DataComponentType component = (DataComponentType)componentTypeRegistry.getValue(Identifier.parse(removedString));
                if (component == null) continue;
                this.removedTags.add(component);
            }
        }
        if ((nbtMap = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, true)) != null) {
            this.persistentDataContainer.putAll((CompoundTag)CraftNBTTagConfigSerializer.deserialize(nbtMap));
        }
        if ((custom = SerializableMeta.getString(map, "custom", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(custom));
            try {
                this.customTag = NbtIo.readCompressed(buf, NbtAccounter.unlimitedHeap());
            }
            catch (IOException iOException) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    void deserializeInternal(CompoundTag tag, Object context) {
        tag.getList(CraftMetaItem.ATTRIBUTES.NBT).ifPresent(ignore -> {
            this.attributeModifiers = CraftMetaItem.buildModifiersLegacy(tag, ATTRIBUTES);
        });
    }

    private static Multimap<Attribute, org.bukkit.attribute.AttributeModifier> buildModifiersLegacy(CompoundTag tag, ItemMetaKey key) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        ListTag mods = tag.getListOrEmpty(key.NBT);
        int size = mods.size();
        for (int i = 0; i < size; ++i) {
            Attribute attribute;
            AttributeModifier nmsModifier;
            CompoundTag entry = mods.getCompoundOrEmpty(i);
            if (entry.isEmpty() || (nmsModifier = (AttributeModifier)entry.read(AttributeModifier.MAP_CODEC).orElse(null)) == null) continue;
            org.bukkit.attribute.AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            String attributeName = entry.getStringOr(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT, null);
            if (attributeName == null || attributeName.isEmpty() || (attribute = CraftAttribute.stringToBukkit(attributeName)) == null) continue;
            String slotName = entry.getStringOr(CraftMetaItem.ATTRIBUTES_SLOT.NBT, null);
            if (slotName == null || slotName.isEmpty()) {
                modifiers.put((Object)attribute, (Object)attribMod);
                continue;
            }
            EquipmentSlot slot = null;
            try {
                slot = CraftEquipmentSlot.getSlot(net.minecraft.world.entity.EquipmentSlot.byName(slotName.toLowerCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (slot == null) {
                modifiers.put((Object)attribute, (Object)attribMod);
                continue;
            }
            attribMod = new org.bukkit.attribute.AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot.getGroup());
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    static Map<Enchantment, Integer> buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        LinkedHashMap<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>(ench.size());
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment = CraftEnchantment.stringToBukkit(entry.getKey().toString());
            if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    static Multimap<Attribute, org.bukkit.attribute.AttributeModifier> buildModifiers(Map<String, Object> map, ItemMetaKey key) {
        Map mods = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        if (mods == null) {
            return result;
        }
        for (Object obj : mods.keySet()) {
            String attributeName;
            if (!(obj instanceof String) || Strings.isNullOrEmpty((String)(attributeName = (String)obj))) continue;
            List list = SerializableMeta.getObject(List.class, mods, attributeName, true);
            if (list == null || list.isEmpty()) {
                return result;
            }
            for (Object o : list) {
                if (!(o instanceof org.bukkit.attribute.AttributeModifier)) continue;
                org.bukkit.attribute.AttributeModifier modifier = (org.bukkit.attribute.AttributeModifier)o;
                Attribute attribute = CraftAttribute.stringToBukkit(attributeName);
                if (attribute == null) continue;
                result.put((Object)attribute, (Object)modifier);
            }
        }
        return result;
    }

    @Overridden
    void applyToItem(Applicator itemTag) {
        CompoundTag customTag;
        if (this.hasDisplayName()) {
            itemTag.put(NAME, this.displayName);
        }
        if (this.hasItemName()) {
            itemTag.put(ITEM_NAME, this.itemName);
        }
        if (this.lore != null) {
            itemTag.put(LORE, new ItemLore(this.lore));
        }
        if (this.hasCustomModelDataComponent()) {
            itemTag.put(CUSTOM_MODEL_DATA, this.customModelData.getHandle());
        }
        if (this.hasEnchantable()) {
            itemTag.put(ENCHANTABLE, new Enchantable(this.enchantableValue));
        }
        if (this.hasBlockData()) {
            itemTag.put(BLOCK_DATA, new BlockItemStateProperties(this.blockData));
        }
        if (this.hiddenComponents != null || this.hideTooltip) {
            Iterator<DataComponentType<?>> hidden = this.hiddenComponents != null ? this.hiddenComponents : new LinkedHashSet();
            itemTag.put(HIDEFLAGS, new TooltipDisplay(this.hideTooltip, (SequencedSet<DataComponentType<?>>)((Object)hidden)));
        }
        this.applyEnchantments(this.enchantments, itemTag, ENCHANTMENTS, ItemFlag.HIDE_ENCHANTS);
        this.applyModifiers(this.attributeModifiers, itemTag);
        if (this.hasRepairCost()) {
            itemTag.put(REPAIR, this.repairCost);
        }
        if (this.hasTooltipStyle()) {
            itemTag.put(TOOLTIP_STYLE, CraftNamespacedKey.toMinecraft(this.getTooltipStyle()));
        }
        if (this.hasItemModel()) {
            itemTag.put(ITEM_MODEL, CraftNamespacedKey.toMinecraft(this.getItemModel()));
        }
        if (this.isUnbreakable()) {
            itemTag.put(UNBREAKABLE, Unit.INSTANCE);
        }
        if (this.hasEnchantmentGlintOverride()) {
            itemTag.put(ENCHANTMENT_GLINT_OVERRIDE, this.getEnchantmentGlintOverride());
        }
        if (this.isGlider()) {
            itemTag.put(GLIDER, Unit.INSTANCE);
        }
        if (this.hasDamageResistant()) {
            itemTag.put(DAMAGE_RESISTANT, new DamageResistant(this.damageResistant));
        }
        if (this.hasDamageType()) {
            itemTag.put(DAMAGE_TYPE, this.damageType);
        }
        if (this.hasMaxStackSize()) {
            itemTag.put(MAX_STACK_SIZE, this.maxStackSize);
        }
        if (this.hasRarity()) {
            itemTag.put(RARITY, Rarity.valueOf(this.rarity.name()));
        }
        if (this.hasUseRemainder()) {
            itemTag.put(USE_REMAINDER, new UseRemainder(CraftItemStack.asNMSCopy(this.useRemainder)));
        }
        if (this.hasUseCooldown()) {
            itemTag.put(USE_COOLDOWN, this.useCooldown.getHandle());
        }
        if (this.hasUseEffects()) {
            itemTag.put(USE_EFFECTS, this.useEffects.getHandle());
        }
        if (this.hasSwingAnimation()) {
            itemTag.put(SWING_ANIMATION, this.swingAnimation.getHandle());
        }
        if (this.hasAttackRange()) {
            itemTag.put(ATTACK_RANGE, this.attackRange.getHandle());
        }
        if (this.hasPiercingWeapon()) {
            itemTag.put(PIERCING_WEAPON, this.piercingWeapon.getHandle());
        }
        if (this.hasKineticWeapon()) {
            itemTag.put(KINETIC_WEAPON, this.kineticWeapon.getHandle());
        }
        if (this.hasFood()) {
            itemTag.put(FOOD, this.food.getHandle());
        }
        if (this.hasConsumable()) {
            itemTag.put(CONSUMABLE, this.consumable.getHandle());
        }
        if (this.hasTool()) {
            itemTag.put(TOOL, this.tool.getHandle());
        }
        if (this.hasBlocksAttacks()) {
            itemTag.put(BLOCKS_ATTACKS, this.blocksAttacks.getHandle());
        }
        if (this.hasWeapon()) {
            itemTag.put(WEAPON, this.weapon.getHandle());
        }
        if (this.hasEquippable()) {
            itemTag.put(EQUIPPABLE, this.equippable.getHandle());
        }
        if (this.hasJukeboxPlayable()) {
            itemTag.put(JUKEBOX_PLAYABLE, this.jukebox.getHandle());
        }
        if (this.hasBreakSound()) {
            itemTag.put(BREAK_SOUND, this.breakSound);
        }
        if (this.hasDamage()) {
            itemTag.put(DAMAGE, this.damage);
        }
        if (this.hasMaxDamage()) {
            itemTag.put(MAX_DAMAGE, this.maxDamage);
        }
        if (this.hasMinimumAttackCharge()) {
            itemTag.put(MINIMUM_ATTACK_CHARGE, this.minimumAttackCharge);
        }
        for (Map.Entry entry : this.unhandledTags.build().entrySet()) {
            ((Optional)entry.getValue()).ifPresent(value -> itemTag.builder.set((DataComponentType)e.getKey(), value));
        }
        for (DataComponentType<?> dataComponentType : this.removedTags) {
            if (itemTag.builder.isSet(dataComponentType)) continue;
            itemTag.builder.remove(dataComponentType);
        }
        CompoundTag compoundTag = customTag = this.customTag != null ? this.customTag.copy() : null;
        if (!this.persistentDataContainer.isEmpty()) {
            CompoundTag compoundTag2 = new CompoundTag();
            Map<String, net.minecraft.nbt.Tag> rawPublicMap = this.persistentDataContainer.getRaw();
            for (Map.Entry<String, net.minecraft.nbt.Tag> nbtBaseEntry : rawPublicMap.entrySet()) {
                compoundTag2.put(nbtBaseEntry.getKey(), nbtBaseEntry.getValue());
            }
            if (customTag == null) {
                customTag = new CompoundTag();
            }
            customTag.put(CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, compoundTag2);
        }
        if (customTag != null) {
            itemTag.put(CUSTOM_DATA, CustomData.of(customTag));
        }
    }

    void applyEnchantments(Map<Enchantment, Integer> enchantments, Applicator tag, ItemMetaKeyType<ItemEnchantments> key, ItemFlag itemFlag) {
        if (enchantments == null && !this.hasItemFlag(itemFlag)) {
            return;
        }
        ItemEnchantments.Mutable list = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        if (enchantments != null) {
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                list.set(CraftEnchantment.bukkitToMinecraftHolder(entry.getKey()), entry.getValue());
            }
        }
        tag.put(key, list.toImmutable());
    }

    void applyModifiers(Multimap<Attribute, org.bukkit.attribute.AttributeModifier> modifiers, Applicator tag) {
        if (modifiers == null || modifiers.isEmpty()) {
            return;
        }
        ItemAttributeModifiers.Builder list = ItemAttributeModifiers.builder();
        for (Map.Entry entry : modifiers.entries()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            AttributeModifier nmsModifier = CraftAttributeInstance.convert((org.bukkit.attribute.AttributeModifier)entry.getValue());
            Holder<net.minecraft.world.entity.ai.attributes.Attribute> name = CraftAttribute.bukkitToMinecraftHolder((Attribute)entry.getKey());
            if (name == null) continue;
            EquipmentSlotGroup group = CraftEquipmentSlot.getNMSGroup(((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlotGroup());
            list.add(name, nmsModifier, group);
        }
        tag.put(ATTRIBUTES, list.build());
    }

    boolean applicableTo(Material type) {
        if (type == Material.AIR || !type.isItem()) {
            return false;
        }
        if (this.getClass() == CraftMetaItem.class) {
            return true;
        }
        return type.asItemType().getItemMetaClass() == this.getClass().getInterfaces()[0];
    }

    @Overridden
    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasItemName() && !this.hasLocalizedName() && !this.hasEnchants() && this.lore == null && !this.hasCustomModelDataComponent() && !this.hasEnchantable() && !this.hasBlockData() && !this.hasRepairCost() && this.unhandledTags.build().isEmpty() && this.removedTags.isEmpty() && this.persistentDataContainer.isEmpty() && !this.hasItemFlags() && !this.isHideTooltip() && !this.hasTooltipStyle() && !this.hasItemModel() && !this.isUnbreakable() && !this.hasEnchantmentGlintOverride() && !this.isGlider() && !this.hasDamageResistant() && !this.hasDamageType() && !this.hasMaxStackSize() && !this.hasRarity() && !this.hasUseRemainder() && !this.hasUseCooldown() && !this.hasUseEffects() && !this.hasSwingAnimation() && !this.hasAttackRange() && !this.hasPiercingWeapon() && !this.hasKineticWeapon() && !this.hasFood() && !this.hasConsumable() && !this.hasTool() && !this.hasBlocksAttacks() && !this.hasWeapon() && !this.hasJukeboxPlayable() && !this.hasBreakSound() && !this.hasEquippable() && !this.hasDamage() && !this.hasMaxDamage() && !this.hasMinimumAttackCharge() && !this.hasAttributeModifiers() && this.customTag == null;
    }

    public String getDisplayName() {
        return CraftChatMessage.fromComponent(this.displayName);
    }

    public final void setDisplayName(String name) {
        this.displayName = CraftChatMessage.fromStringOrNull(name);
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public String getItemName() {
        return CraftChatMessage.fromComponent(this.itemName);
    }

    public final void setItemName(String name) {
        this.itemName = CraftChatMessage.fromStringOrNull(name);
    }

    public boolean hasItemName() {
        return this.itemName != null;
    }

    public String getLocalizedName() {
        return this.getDisplayName();
    }

    public void setLocalizedName(String name) {
    }

    public boolean hasLocalizedName() {
        return false;
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    public boolean hasEnchant(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        return this.hasEnchants() && this.enchantments.containsKey(ench);
    }

    public int getEnchantLevel(Enchantment ench) {
        Integer level;
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        Integer n = level = this.hasEnchants() ? this.enchantments.get(ench) : null;
        if (level == null) {
            return 0;
        }
        return level;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableMap.copyOf(this.enchantments) : ImmutableMap.of();
    }

    public boolean addEnchant(Enchantment ench, int level, boolean ignoreRestrictions) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.enchantments == null) {
            this.enchantments = new LinkedHashMap<Enchantment, Integer>(4);
        }
        if (ignoreRestrictions || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            Integer old = this.enchantments.put(ench, level);
            return old == null || old != level;
        }
        return false;
    }

    public boolean removeEnchant(Enchantment ench) {
        boolean enchantmentRemoved;
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        boolean bl = enchantmentRemoved = this.hasEnchants() && this.enchantments.remove(ench) != null;
        if (enchantmentRemoved && this.enchantments.isEmpty()) {
            this.enchantments = null;
        }
        return enchantmentRemoved;
    }

    public void removeEnchantments() {
        if (this.hasEnchants()) {
            this.enchantments.clear();
        }
    }

    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    public boolean hasConflictingEnchant(Enchantment ench) {
        return CraftMetaItem.checkConflictingEnchants(this.enchantments, ench);
    }

    public void addItemFlags(ItemFlag ... hideFlags) {
        for (ItemFlag f : hideFlags) {
            Collection<DataComponentType<?>> nms = CraftItemFlag.bukkitToNMS(f);
            if (nms == null) continue;
            if (this.hiddenComponents == null) {
                this.hiddenComponents = new LinkedHashSet();
            }
            this.hiddenComponents.addAll(nms);
        }
    }

    public void removeItemFlags(ItemFlag ... hideFlags) {
        if (this.hiddenComponents == null) {
            return;
        }
        for (ItemFlag f : hideFlags) {
            Collection<DataComponentType<?>> nms = CraftItemFlag.bukkitToNMS(f);
            if (nms == null) continue;
            this.hiddenComponents.removeAll(nms);
        }
    }

    public Set<ItemFlag> getItemFlags() {
        EnumSet<ItemFlag> currentFlags = EnumSet.noneOf(ItemFlag.class);
        for (ItemFlag f : ItemFlag.values()) {
            if (!this.hasItemFlag(f)) continue;
            currentFlags.add(f);
        }
        return currentFlags;
    }

    public boolean hasItemFlag(ItemFlag flag) {
        Collection<DataComponentType<?>> nms = CraftItemFlag.bukkitToNMS(flag);
        return nms != null && this.hiddenComponents != null && this.hiddenComponents.containsAll(nms);
    }

    public boolean hasItemFlags() {
        return this.hiddenComponents != null && !this.hiddenComponents.isEmpty();
    }

    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList(Lists.transform(this.lore, CraftChatMessage::fromComponent));
    }

    public void setLore(List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            this.lore = null;
        } else {
            if (this.lore == null) {
                this.lore = new ArrayList<Component>(lore.size());
            } else {
                this.lore.clear();
            }
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        }
    }

    public boolean hasCustomModelData() {
        if (this.customModelData != null) {
            List<Float> floats = this.customModelData.getFloats();
            return !floats.isEmpty();
        }
        return false;
    }

    public int getCustomModelData() {
        Preconditions.checkState((boolean)this.hasCustomModelData(), (Object)"We don't have CustomModelData! Check hasCustomModelData first!");
        return this.customModelData.getFloats().get(0).intValue();
    }

    public boolean hasCustomModelDataComponent() {
        return this.customModelData != null;
    }

    public CustomModelDataComponent getCustomModelDataComponent() {
        return this.hasCustomModelDataComponent() ? new CraftCustomModelDataComponent(this.customModelData) : new CraftCustomModelDataComponent(new CustomModelData(List.of(), List.of(), List.of(), List.of()));
    }

    public void setCustomModelData(Integer data) {
        this.customModelData = data == null ? null : new CraftCustomModelDataComponent(new CustomModelData(List.of(Float.valueOf(data.floatValue())), List.of(), List.of(), List.of()));
    }

    public void setCustomModelDataComponent(CustomModelDataComponent customModelData) {
        this.customModelData = customModelData == null ? null : new CraftCustomModelDataComponent((CraftCustomModelDataComponent)customModelData);
    }

    public boolean hasEnchantable() {
        return this.enchantableValue != null;
    }

    public int getEnchantable() {
        Preconditions.checkState((boolean)this.hasEnchantable(), (Object)"We don't have Enchantable! Check hasEnchantable first!");
        return this.enchantableValue;
    }

    public void setEnchantable(Integer data) {
        this.enchantableValue = data;
    }

    public boolean hasBlockData() {
        return this.blockData != null;
    }

    public BlockData getBlockData(Material material) {
        BlockState defaultData = CraftBlockType.bukkitToMinecraft(material).defaultBlockState();
        return CraftBlockData.fromData(this.hasBlockData() ? new BlockItemStateProperties(this.blockData).apply(defaultData) : defaultData);
    }

    public void setBlockData(BlockData blockData) {
        this.blockData = blockData == null ? null : ((CraftBlockData)blockData).toStates(true);
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    public boolean isHideTooltip() {
        return this.hideTooltip;
    }

    public void setHideTooltip(boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
    }

    public boolean hasTooltipStyle() {
        return this.tooltipStyle != null;
    }

    public NamespacedKey getTooltipStyle() {
        return this.tooltipStyle;
    }

    public void setTooltipStyle(NamespacedKey tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
    }

    public boolean hasItemModel() {
        return this.itemModel != null;
    }

    public NamespacedKey getItemModel() {
        return this.itemModel;
    }

    public void setItemModel(NamespacedKey itemModel) {
        this.itemModel = itemModel;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean hasEnchantmentGlintOverride() {
        return this.enchantmentGlintOverride != null;
    }

    public Boolean getEnchantmentGlintOverride() {
        Preconditions.checkState((boolean)this.hasEnchantmentGlintOverride(), (Object)"We don't have enchantment_glint_override! Check hasEnchantmentGlintOverride first!");
        return this.enchantmentGlintOverride;
    }

    public void setEnchantmentGlintOverride(Boolean override) {
        this.enchantmentGlintOverride = override;
    }

    public boolean isGlider() {
        return this.glider;
    }

    public void setGlider(boolean glider) {
        this.glider = glider;
    }

    public boolean isFireResistant() {
        return this.hasDamageResistant() && DamageTypeTags.IS_FIRE.equals(this.getDamageResistant());
    }

    public void setFireResistant(boolean fireResistant) {
        this.setDamageResistant((Tag<org.bukkit.damage.DamageType>)DamageTypeTags.IS_FIRE);
    }

    public boolean hasDamageResistant() {
        return this.damageResistant != null;
    }

    public Tag<org.bukkit.damage.DamageType> getDamageResistant() {
        return this.hasDamageResistant() ? Bukkit.getTag((String)"damage_types", (NamespacedKey)CraftNamespacedKey.fromMinecraft(this.damageResistant.location()), org.bukkit.damage.DamageType.class) : null;
    }

    public void setDamageResistant(Tag<org.bukkit.damage.DamageType> tag) {
        this.damageResistant = tag != null ? ((CraftDamageTag)tag).getHandle().key() : null;
    }

    public boolean hasDamageType() {
        return this.damageType != null;
    }

    public org.bukkit.damage.DamageType getDamageType() {
        Preconditions.checkState((boolean)this.hasDamageType(), (Object)"We don't have damage_type! Check hasDamageType first!");
        Optional<Holder<DamageType>> type = this.damageType.unwrap(CraftRegistry.getMinecraftRegistry());
        return type.isPresent() ? CraftDamageType.minecraftHolderToBukkit(type.get()) : null;
    }

    public NamespacedKey getDamageTypeKey() {
        Preconditions.checkState((boolean)this.hasDamageType(), (Object)"We don't have damage_type! Check hasDamageType first!");
        return this.damageType.key().map(ResourceKey::identifier).map(CraftNamespacedKey::fromMinecraft).orElse(null);
    }

    public void setDamageType(org.bukkit.damage.DamageType type) {
        this.damageType = type != null ? new EitherHolder<DamageType>(CraftDamageType.bukkitToMinecraftHolder(type)) : null;
    }

    public void setDamageTypeKey(NamespacedKey type) {
        this.damageType = type != null ? new EitherHolder<DamageType>(ResourceKey.create(Registries.DAMAGE_TYPE, CraftNamespacedKey.toMinecraft(type))) : null;
    }

    public boolean hasMaxStackSize() {
        return this.maxStackSize != null;
    }

    public int getMaxStackSize() {
        Preconditions.checkState((boolean)this.hasMaxStackSize(), (Object)"We don't have max_stack_size! Check hasMaxStackSize first!");
        return this.maxStackSize;
    }

    public void setMaxStackSize(Integer max) {
        Preconditions.checkArgument((max == null || max > 0 ? 1 : 0) != 0, (Object)"max_stack_size must be > 0");
        Preconditions.checkArgument((max == null || max <= 99 ? 1 : 0) != 0, (Object)"max_stack_size must be <= 99");
        this.maxStackSize = max;
    }

    public boolean hasRarity() {
        return this.rarity != null;
    }

    public ItemRarity getRarity() {
        Preconditions.checkState((boolean)this.hasRarity(), (Object)"We don't have rarity! Check hasRarity first!");
        return this.rarity;
    }

    public void setRarity(ItemRarity rarity) {
        this.rarity = rarity;
    }

    public boolean hasUseRemainder() {
        return this.useRemainder != null;
    }

    public ItemStack getUseRemainder() {
        return this.useRemainder;
    }

    public void setUseRemainder(ItemStack useRemainder) {
        this.useRemainder = useRemainder;
    }

    public boolean hasUseCooldown() {
        return this.useCooldown != null;
    }

    public UseCooldownComponent getUseCooldown() {
        return this.hasUseCooldown() ? new CraftUseCooldownComponent(this.useCooldown) : new CraftUseCooldownComponent(new UseCooldown(1.0f));
    }

    public void setUseCooldown(UseCooldownComponent cooldown) {
        this.useCooldown = cooldown == null ? null : new CraftUseCooldownComponent((CraftUseCooldownComponent)cooldown);
    }

    public boolean hasUseEffects() {
        return this.useEffects != null;
    }

    public UseEffectsComponent getUseEffects() {
        return this.hasUseEffects() ? new CraftUseEffectsComponent(this.useEffects) : new CraftUseEffectsComponent(UseEffects.DEFAULT);
    }

    public void setUseEffects(UseEffectsComponent effects) {
        this.useEffects = effects == null ? null : new CraftUseEffectsComponent((CraftUseEffectsComponent)effects);
    }

    public boolean hasSwingAnimation() {
        return this.swingAnimation != null;
    }

    public SwingAnimationComponent getSwingAnimation() {
        return this.hasSwingAnimation() ? new CraftSwingAnimationComponent(this.swingAnimation) : new CraftSwingAnimationComponent(SwingAnimation.DEFAULT);
    }

    public void setSwingAnimation(SwingAnimationComponent animation) {
        this.swingAnimation = animation == null ? null : new CraftSwingAnimationComponent((CraftSwingAnimationComponent)animation);
    }

    public boolean hasAttackRange() {
        return this.attackRange != null;
    }

    public AttackRangeComponent getAttackRange() {
        return this.hasAttackRange() ? new CraftAttackRangeComponent(this.attackRange) : new CraftAttackRangeComponent(new AttackRange(0.0f, 3.0f, 0.0f, 3.0f, 0.0f, 1.0f));
    }

    public void setAttackRange(AttackRangeComponent animation) {
        this.attackRange = animation == null ? null : new CraftAttackRangeComponent((CraftAttackRangeComponent)animation);
    }

    public boolean hasPiercingWeapon() {
        return this.piercingWeapon != null;
    }

    public PiercingWeaponComponent getPiercingWeapon() {
        return this.hasPiercingWeapon() ? new CraftPiercingWeaponComponent(this.piercingWeapon) : new CraftPiercingWeaponComponent(new PiercingWeapon(true, false, Optional.empty(), Optional.empty()));
    }

    public void setPiercingWeapon(PiercingWeaponComponent animation) {
        this.piercingWeapon = animation == null ? null : new CraftPiercingWeaponComponent((CraftPiercingWeaponComponent)animation);
    }

    public boolean hasKineticWeapon() {
        return this.kineticWeapon != null;
    }

    public KineticWeaponComponent getKineticWeapon() {
        return this.hasKineticWeapon() ? new CraftKineticWeaponComponent(this.kineticWeapon) : new CraftKineticWeaponComponent(new KineticWeapon(10, 0, Optional.empty(), Optional.empty(), Optional.empty(), 0.0f, 1.0f, Optional.empty(), Optional.empty()));
    }

    public void setKineticWeapon(KineticWeaponComponent animation) {
        this.kineticWeapon = animation == null ? null : new CraftKineticWeaponComponent((CraftKineticWeaponComponent)animation);
    }

    public boolean hasFood() {
        return this.food != null;
    }

    public FoodComponent getFood() {
        return this.hasFood() ? new CraftFoodComponent(this.food) : new CraftFoodComponent(new FoodProperties(0, 0.0f, false));
    }

    public void setFood(FoodComponent food) {
        this.food = food == null ? null : new CraftFoodComponent((CraftFoodComponent)food);
    }

    public boolean hasConsumable() {
        return this.consumable != null;
    }

    public ConsumableComponent getConsumable() {
        return this.hasConsumable() ? new CraftConsumableComponent(this.consumable) : new CraftConsumableComponent(new Consumable(1.6f, ItemUseAnimation.EAT, SoundEvents.GENERIC_EAT, true, List.of()));
    }

    public void setConsumable(ConsumableComponent consumable) {
        this.consumable = consumable == null ? null : new CraftConsumableComponent((CraftConsumableComponent)consumable);
    }

    public boolean hasTool() {
        return this.tool != null;
    }

    public ToolComponent getTool() {
        return this.hasTool() ? new CraftToolComponent(this.tool) : new CraftToolComponent(new Tool(Collections.emptyList(), 1.0f, 1, true));
    }

    public void setTool(ToolComponent tool) {
        this.tool = tool == null ? null : new CraftToolComponent((CraftToolComponent)tool);
    }

    public boolean hasBlocksAttacks() {
        return this.blocksAttacks != null;
    }

    public BlocksAttacksComponent getBlocksAttacks() {
        return this.hasBlocksAttacks() ? new CraftBlocksAttacksComponent(this.blocksAttacks) : new CraftBlocksAttacksComponent(new BlocksAttacks(0.0f, 1.0f, Collections.emptyList(), new BlocksAttacks.ItemDamageFunction(0.0f, 0.0f, 0.0f), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    public void setBlocksAttacks(BlocksAttacksComponent blocksAttacks) {
        this.blocksAttacks = blocksAttacks == null ? null : new CraftBlocksAttacksComponent((CraftBlocksAttacksComponent)blocksAttacks);
    }

    public boolean hasWeapon() {
        return this.weapon != null;
    }

    public WeaponComponent getWeapon() {
        return this.hasWeapon() ? new CraftWeaponComponent(this.weapon) : new CraftWeaponComponent(new Weapon(0));
    }

    public void setWeapon(WeaponComponent weapon) {
        this.weapon = weapon == null ? null : new CraftWeaponComponent((CraftWeaponComponent)weapon);
    }

    public boolean hasEquippable() {
        return this.equippable != null;
    }

    public EquippableComponent getEquippable() {
        return this.hasEquippable() ? new CraftEquippableComponent(this.equippable) : new CraftEquippableComponent(Equippable.builder(net.minecraft.world.entity.EquipmentSlot.HEAD).build());
    }

    public void setEquippable(EquippableComponent equippable) {
        this.equippable = equippable == null ? null : new CraftEquippableComponent((CraftEquippableComponent)equippable);
    }

    public boolean hasJukeboxPlayable() {
        return this.jukebox != null;
    }

    public JukeboxPlayableComponent getJukeboxPlayable() {
        return this.hasJukeboxPlayable() ? new CraftJukeboxComponent(this.jukebox) : new CraftJukeboxComponent(new JukeboxPlayable(new EitherHolder<JukeboxSong>(JukeboxSongs.THIRTEEN)));
    }

    public void setJukeboxPlayable(JukeboxPlayableComponent jukeboxPlayable) {
        this.jukebox = jukeboxPlayable == null ? null : new CraftJukeboxComponent((CraftJukeboxComponent)jukeboxPlayable);
    }

    public boolean hasBreakSound() {
        return this.breakSound != null;
    }

    public Sound getBreakSound() {
        return this.breakSound != null ? CraftSound.minecraftHolderToBukkit(this.breakSound) : null;
    }

    public void setBreakSound(Sound sound) {
        this.breakSound = sound != null ? CraftSound.bukkitToMinecraftHolder(sound) : null;
    }

    public boolean hasAttributeModifiers() {
        return this.attributeModifiers != null && !this.attributeModifiers.isEmpty();
    }

    public Multimap<Attribute, org.bukkit.attribute.AttributeModifier> getAttributeModifiers() {
        return this.hasAttributeModifiers() ? ImmutableMultimap.copyOf(this.attributeModifiers) : null;
    }

    private void checkAttributeList() {
        if (this.attributeModifiers == null) {
            this.attributeModifiers = LinkedHashMultimap.create();
        }
    }

    public Multimap<Attribute, org.bukkit.attribute.AttributeModifier> getAttributeModifiers(@Nullable EquipmentSlot slot) {
        this.checkAttributeList();
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            if (((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlot() != null && ((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            result.put((Object)((Attribute)entry.getKey()), (Object)((org.bukkit.attribute.AttributeModifier)entry.getValue()));
        }
        return result;
    }

    public Collection<org.bukkit.attribute.AttributeModifier> getAttributeModifiers(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        return this.attributeModifiers.containsKey((Object)attribute) ? ImmutableList.copyOf((Collection)this.attributeModifiers.get((Object)attribute)) : null;
    }

    public boolean addAttributeModifier(@Nonnull Attribute attribute, @Nonnull org.bukkit.attribute.AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            Preconditions.checkArgument((!((org.bukkit.attribute.AttributeModifier)entry.getValue()).getKey().equals((Object)modifier.getKey()) ? 1 : 0) != 0, (String)"Cannot register AttributeModifier. Modifier is already applied! %s", (Object)modifier);
        }
        return this.attributeModifiers.put((Object)attribute, (Object)modifier);
    }

    public void setAttributeModifiers(@Nullable Multimap<Attribute, org.bukkit.attribute.AttributeModifier> attributeModifiers) {
        if (attributeModifiers == null || attributeModifiers.isEmpty()) {
            this.attributeModifiers = LinkedHashMultimap.create();
            return;
        }
        this.checkAttributeList();
        this.attributeModifiers.clear();
        Iterator iterator = attributeModifiers.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (next.getKey() == null || next.getValue() == null) {
                iterator.remove();
                continue;
            }
            this.attributeModifiers.put((Object)((Attribute)next.getKey()), (Object)((org.bukkit.attribute.AttributeModifier)next.getValue()));
        }
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        this.checkAttributeList();
        return !this.attributeModifiers.removeAll((Object)attribute).isEmpty();
    }

    public boolean removeAttributeModifier(@Nullable EquipmentSlot slot) {
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlot() != null && ((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute, @Nonnull org.bukkit.attribute.AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (entry.getKey() == null || entry.getValue() == null) {
                iter.remove();
                ++removed;
                continue;
            }
            if (entry.getKey() != attribute || !((org.bukkit.attribute.AttributeModifier)entry.getValue()).getKey().equals((Object)modifier.getKey())) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public String getAsString() {
        Applicator tag = new Applicator();
        this.applyToItem(tag);
        DataComponentPatch patch = tag.build();
        net.minecraft.nbt.Tag nbt = (net.minecraft.nbt.Tag)DataComponentPatch.CODEC.encodeStart(MinecraftServer.getDefaultRegistryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)patch).getOrThrow();
        return nbt.toString();
    }

    public String getAsComponentString() {
        Applicator tag = new Applicator();
        this.applyToItem(tag);
        DataComponentPatch patch = tag.build();
        RegistryAccess registryAccess = CraftRegistry.getMinecraftRegistry();
        RegistryOps<net.minecraft.nbt.Tag> ops = registryAccess.createSerializationContext(NbtOps.INSTANCE);
        HolderLookup.RegistryLookup componentTypeRegistry = registryAccess.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
        StringJoiner componentString = new StringJoiner(",", "[", "]");
        for (Map.Entry<DataComponentType<?>, Optional<?>> entry : patch.entrySet()) {
            DataComponentType<?> componentType = entry.getKey();
            Optional<?> componentValue = entry.getValue();
            String componentKey = componentTypeRegistry.getResourceKey(componentType).orElseThrow().identifier().toString();
            if (componentValue.isPresent()) {
                net.minecraft.nbt.Tag componentValueAsNBT = (net.minecraft.nbt.Tag)componentType.codecOrThrow().encodeStart(ops, componentValue.get()).getOrThrow();
                String componentValueAsNBTString = new SnbtPrinterTagVisitor("", 0, new ArrayList<String>()).visit(componentValueAsNBT);
                componentString.add(componentKey + "=" + componentValueAsNBTString);
                continue;
            }
            componentString.add("!" + componentKey);
        }
        return componentString.toString();
    }

    public CustomItemTagContainer getCustomTagContainer() {
        return new DeprecatedCustomTagContainer(this.getPersistentDataContainer());
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    private static boolean compareModifiers(Multimap<Attribute, org.bukkit.attribute.AttributeModifier> first, Multimap<Attribute, org.bukkit.attribute.AttributeModifier> second) {
        if (first == null || second == null) {
            return false;
        }
        for (Map.Entry entry : first.entries()) {
            if (second.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : second.entries()) {
            if (first.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean hasDamage() {
        return this.damage > 0;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public boolean hasMaxDamage() {
        return this.maxDamage != null;
    }

    public int getMaxDamage() {
        Preconditions.checkState((boolean)this.hasMaxDamage(), (Object)"We don't have max_damage! Check hasMaxDamage first!");
        return this.maxDamage;
    }

    public void setMaxDamage(Integer maxDamage) {
        this.maxDamage = maxDamage;
    }

    public boolean hasMinimumAttackCharge() {
        return this.minimumAttackCharge != null;
    }

    public float getMinimumAttackCharge() {
        Preconditions.checkState((boolean)this.hasMinimumAttackCharge(), (Object)"We don't have minimum_attack_charge! Check hasMinimumAttackCharge first!");
        return this.minimumAttackCharge.floatValue();
    }

    public void setMinimumAttackCharge(Float minimumAttackCharge) {
        Preconditions.checkArgument((minimumAttackCharge == null || 0.0f <= minimumAttackCharge.floatValue() && minimumAttackCharge.floatValue() <= 1.0f ? 1 : 0) != 0, (Object)"minimumAttackCharge outside of range [0,1]");
        this.minimumAttackCharge = minimumAttackCharge;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    @Overridden
    boolean equalsCommon(CraftMetaItem that) {
        return (this.hasDisplayName() ? that.hasDisplayName() && this.displayName.equals(that.displayName) : !that.hasDisplayName()) && (this.hasItemName() ? that.hasItemName() && this.itemName.equals(that.itemName) : !that.hasItemName()) && (this.hasEnchants() ? that.hasEnchants() && this.enchantments.equals(that.enchantments) : !that.hasEnchants()) && Objects.equals(this.lore, that.lore) && (this.hasCustomModelDataComponent() ? that.hasCustomModelDataComponent() && this.customModelData.equals(that.customModelData) : !that.hasCustomModelDataComponent()) && (this.hasEnchantable() ? that.hasEnchantable() && this.enchantableValue.equals(that.enchantableValue) : !that.hasEnchantable()) && (this.hasBlockData() ? that.hasBlockData() && this.blockData.equals(that.blockData) : !that.hasBlockData()) && (this.hasRepairCost() ? that.hasRepairCost() && this.repairCost == that.repairCost : !that.hasRepairCost()) && (this.hasAttributeModifiers() ? that.hasAttributeModifiers() && CraftMetaItem.compareModifiers(this.attributeModifiers, that.attributeModifiers) : !that.hasAttributeModifiers()) && this.unhandledTags.equals(that.unhandledTags) && this.removedTags.equals(that.removedTags) && Objects.equals(this.customTag, that.customTag) && this.persistentDataContainer.equals(that.persistentDataContainer) && (this.hasItemFlags() ? that.hasItemFlags() && this.hiddenComponents.equals(that.hiddenComponents) : !that.hasItemFlags()) && this.isHideTooltip() == that.isHideTooltip() && (this.hasTooltipStyle() ? that.hasTooltipStyle() && this.tooltipStyle.equals((Object)that.tooltipStyle) : !that.hasTooltipStyle()) && (this.hasItemModel() ? that.hasItemModel() && this.itemModel.equals((Object)that.itemModel) : !that.hasItemModel()) && this.isUnbreakable() == that.isUnbreakable() && (this.hasEnchantmentGlintOverride() ? that.hasEnchantmentGlintOverride() && this.enchantmentGlintOverride.equals(that.enchantmentGlintOverride) : !that.hasEnchantmentGlintOverride()) && this.glider == that.glider && (this.hasDamageResistant() ? that.hasDamageResistant() && this.damageResistant.equals(that.damageResistant) : !that.hasDamageResistant()) && (this.hasDamageType() ? that.hasDamageType() && this.damageType.equals(that.damageType) : !that.hasDamageType()) && (this.hasMaxStackSize() ? that.hasMaxStackSize() && this.maxStackSize.equals(that.maxStackSize) : !that.hasMaxStackSize()) && this.rarity == that.rarity && (this.hasUseRemainder() ? that.hasUseRemainder() && this.useRemainder.equals((Object)that.useRemainder) : !that.hasUseRemainder()) && (this.hasUseCooldown() ? that.hasUseCooldown() && this.useCooldown.equals(that.useCooldown) : !that.hasUseCooldown()) && (this.hasUseEffects() ? that.hasUseEffects() && this.useEffects.equals(that.useEffects) : !that.hasUseEffects()) && (this.hasSwingAnimation() ? that.hasSwingAnimation() && this.swingAnimation.equals(that.swingAnimation) : !that.hasSwingAnimation()) && (this.hasAttackRange() ? that.hasAttackRange() && this.attackRange.equals(that.attackRange) : !that.hasAttackRange()) && (this.hasPiercingWeapon() ? that.hasPiercingWeapon() && this.piercingWeapon.equals(that.piercingWeapon) : !that.hasPiercingWeapon()) && (this.hasKineticWeapon() ? that.hasKineticWeapon() && this.kineticWeapon.equals(that.kineticWeapon) : !that.hasKineticWeapon()) && (this.hasFood() ? that.hasFood() && this.food.equals(that.food) : !that.hasFood()) && (this.hasConsumable() ? that.hasConsumable() && this.consumable.equals(that.consumable) : !that.hasConsumable()) && (this.hasTool() ? that.hasTool() && this.tool.equals(that.tool) : !that.hasTool()) && (this.hasBlocksAttacks() ? that.hasBlocksAttacks() && this.blocksAttacks.equals(that.blocksAttacks) : !that.hasBlocksAttacks()) && (this.hasWeapon() ? that.hasWeapon() && this.weapon.equals(that.weapon) : !that.hasWeapon()) && (this.hasEquippable() ? that.hasEquippable() && this.equippable.equals(that.equippable) : !that.hasEquippable()) && (this.hasJukeboxPlayable() ? that.hasJukeboxPlayable() && this.jukebox.equals(that.jukebox) : !that.hasJukeboxPlayable()) && (this.hasBreakSound() ? that.hasBreakSound() && this.breakSound.equals(that.breakSound) : !that.hasBreakSound()) && (this.hasDamage() ? that.hasDamage() && this.damage == that.damage : !that.hasDamage()) && (this.hasMaxDamage() ? that.hasMaxDamage() && this.maxDamage.equals(that.maxDamage) : !that.hasMaxDamage()) && (this.hasMinimumAttackCharge() ? that.hasMinimumAttackCharge() && this.minimumAttackCharge.equals(that.minimumAttackCharge) : !that.hasMinimumAttackCharge()) && this.version == that.version;
    }

    @Overridden
    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    @Overridden
    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasItemName() ? this.itemName.hashCode() : 0);
        hash = 61 * hash + (this.lore != null ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasCustomModelDataComponent() ? this.customModelData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchantable() ? this.enchantableValue.hashCode() : 0);
        hash = 61 * hash + (this.hasBlockData() ? this.blockData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        hash = 61 * hash + this.unhandledTags.hashCode();
        hash = 61 * hash + this.removedTags.hashCode();
        hash = 61 * hash + (this.customTag != null ? this.customTag.hashCode() : 0);
        hash = 61 * hash + (!this.persistentDataContainer.isEmpty() ? this.persistentDataContainer.hashCode() : 0);
        hash = 61 * hash + (this.hasItemFlags() ? this.hiddenComponents.hashCode() : 0);
        hash = 61 * hash + (this.isHideTooltip() ? 1231 : 1237);
        hash = 61 * hash + (this.hasTooltipStyle() ? this.tooltipStyle.hashCode() : 0);
        hash = 61 * hash + (this.hasItemModel() ? this.itemModel.hashCode() : 0);
        hash = 61 * hash + (this.isUnbreakable() ? 1231 : 1237);
        hash = 61 * hash + (this.hasEnchantmentGlintOverride() ? this.enchantmentGlintOverride.hashCode() : 0);
        hash = 61 * hash + (this.isGlider() ? 1231 : 1237);
        hash = 61 * hash + (this.hasDamageResistant() ? this.damageResistant.hashCode() : 0);
        hash = 61 * hash + (this.hasDamageType() ? this.damageType.hashCode() : 0);
        hash = 61 * hash + (this.hasMaxStackSize() ? this.maxStackSize.hashCode() : 0);
        hash = 61 * hash + (this.hasRarity() ? this.rarity.hashCode() : 0);
        hash = 61 * hash + (this.hasUseRemainder() ? this.useRemainder.hashCode() : 0);
        hash = 61 * hash + (this.hasUseCooldown() ? this.useCooldown.hashCode() : 0);
        hash = 61 * hash + (this.hasUseEffects() ? this.useEffects.hashCode() : 0);
        hash = 61 * hash + (this.hasSwingAnimation() ? this.swingAnimation.hashCode() : 0);
        hash = 61 * hash + (this.hasAttackRange() ? this.attackRange.hashCode() : 0);
        hash = 61 * hash + (this.hasPiercingWeapon() ? this.piercingWeapon.hashCode() : 0);
        hash = 61 * hash + (this.hasKineticWeapon() ? this.kineticWeapon.hashCode() : 0);
        hash = 61 * hash + (this.hasFood() ? this.food.hashCode() : 0);
        hash = 61 * hash + (this.hasConsumable() ? this.consumable.hashCode() : 0);
        hash = 61 * hash + (this.hasTool() ? this.tool.hashCode() : 0);
        hash = 61 * hash + (this.hasBlocksAttacks() ? this.blocksAttacks.hashCode() : 0);
        hash = 61 * hash + (this.hasWeapon() ? this.weapon.hashCode() : 0);
        hash = 61 * hash + (this.hasJukeboxPlayable() ? this.jukebox.hashCode() : 0);
        hash = 61 * hash + (this.hasBreakSound() ? this.breakSound.hashCode() : 0);
        hash = 61 * hash + (this.hasEquippable() ? this.equippable.hashCode() : 0);
        hash = 61 * hash + (this.hasDamage() ? this.damage : 0);
        hash = 61 * hash + (this.hasMaxDamage() ? this.maxDamage.hashCode() : 0);
        hash = 61 * hash + (this.hasMinimumAttackCharge() ? this.minimumAttackCharge.hashCode() : 0);
        hash = 61 * hash + (this.hasAttributeModifiers() ? this.attributeModifiers.hashCode() : 0);
        hash = 61 * hash + this.version;
        return hash;
    }

    @Overridden
    public CraftMetaItem clone() {
        try {
            CraftMetaItem clone = (CraftMetaItem)super.clone();
            if (this.lore != null) {
                clone.lore = new ArrayList<Component>(this.lore);
            }
            if (this.hasCustomModelDataComponent()) {
                clone.customModelData = new CraftCustomModelDataComponent(this.customModelData);
            }
            clone.enchantableValue = this.enchantableValue;
            clone.blockData = this.blockData;
            if (this.enchantments != null) {
                clone.enchantments = new LinkedHashMap<Enchantment, Integer>(this.enchantments);
            }
            if (this.hasAttributeModifiers()) {
                clone.attributeModifiers = LinkedHashMultimap.create(this.attributeModifiers);
            }
            if (this.customTag != null) {
                clone.customTag = this.customTag.copy();
            }
            clone.removedTags = Sets.newHashSet(this.removedTags);
            clone.persistentDataContainer = new CraftPersistentDataContainer(this.persistentDataContainer.getRaw(), DATA_TYPE_REGISTRY);
            if (this.hasItemFlags()) {
                clone.hiddenComponents = new LinkedHashSet(this.hiddenComponents);
            }
            clone.hideTooltip = this.hideTooltip;
            clone.tooltipStyle = this.tooltipStyle;
            clone.itemModel = this.itemModel;
            clone.unbreakable = this.unbreakable;
            clone.enchantmentGlintOverride = this.enchantmentGlintOverride;
            clone.glider = this.glider;
            clone.damageResistant = this.damageResistant;
            clone.damageType = this.damageType;
            clone.maxStackSize = this.maxStackSize;
            clone.rarity = this.rarity;
            if (this.hasUseRemainder()) {
                clone.useRemainder = this.useRemainder.clone();
            }
            if (this.hasUseCooldown()) {
                clone.useCooldown = new CraftUseCooldownComponent(this.useCooldown);
            }
            if (this.hasUseEffects()) {
                clone.useEffects = new CraftUseEffectsComponent(this.useEffects);
            }
            if (this.hasSwingAnimation()) {
                clone.swingAnimation = new CraftSwingAnimationComponent(this.swingAnimation);
            }
            if (this.hasAttackRange()) {
                clone.attackRange = new CraftAttackRangeComponent(this.attackRange);
            }
            if (this.hasPiercingWeapon()) {
                clone.piercingWeapon = new CraftPiercingWeaponComponent(this.piercingWeapon);
            }
            if (this.hasKineticWeapon()) {
                clone.kineticWeapon = new CraftKineticWeaponComponent(this.kineticWeapon);
            }
            if (this.hasFood()) {
                clone.food = new CraftFoodComponent(this.food);
            }
            if (this.hasConsumable()) {
                clone.consumable = new CraftConsumableComponent(this.consumable);
            }
            if (this.hasTool()) {
                clone.tool = new CraftToolComponent(this.tool);
            }
            if (this.hasBlocksAttacks()) {
                clone.blocksAttacks = new CraftBlocksAttacksComponent(this.blocksAttacks);
            }
            if (this.hasWeapon()) {
                clone.weapon = new CraftWeaponComponent(this.weapon);
            }
            if (this.hasEquippable()) {
                clone.equippable = new CraftEquippableComponent(this.equippable);
            }
            if (this.hasJukeboxPlayable()) {
                clone.jukebox = new CraftJukeboxComponent(this.jukebox);
            }
            clone.breakSound = this.breakSound;
            clone.damage = this.damage;
            clone.maxDamage = this.maxDamage;
            clone.minimumAttackCharge = this.minimumAttackCharge;
            clone.version = this.version;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    @Overridden
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        ByteArrayOutputStream buf;
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.displayName));
        }
        if (this.hasItemName()) {
            builder.put((Object)CraftMetaItem.ITEM_NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.itemName));
        }
        if (this.hasLore()) {
            ArrayList<String> jsonLore = new ArrayList<String>();
            for (Component component : this.lore) {
                jsonLore.add(CraftChatMessage.toJSON(component));
            }
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, jsonLore);
        }
        if (this.hasCustomModelDataComponent()) {
            builder.put((Object)CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, (Object)this.customModelData);
        }
        if (this.hasEnchantable()) {
            builder.put((Object)CraftMetaItem.ENCHANTABLE.BUKKIT, (Object)this.enchantableValue);
        }
        if (this.hasBlockData()) {
            builder.put((Object)CraftMetaItem.BLOCK_DATA.BUKKIT, this.blockData);
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        CraftMetaItem.serializeModifiers(this.attributeModifiers, builder, ATTRIBUTES);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        ArrayList<String> hideFlags = new ArrayList<String>();
        for (ItemFlag hideFlagEnum : this.getItemFlags()) {
            hideFlags.add(CraftItemFlag.bukkitToString(hideFlagEnum));
        }
        if (!hideFlags.isEmpty()) {
            builder.put((Object)CraftMetaItem.HIDEFLAGS.BUKKIT, hideFlags);
        }
        if (this.isHideTooltip()) {
            builder.put((Object)CraftMetaItem.HIDE_TOOLTIP.BUKKIT, (Object)this.hideTooltip);
        }
        if (this.hasTooltipStyle()) {
            builder.put((Object)CraftMetaItem.TOOLTIP_STYLE.BUKKIT, (Object)this.tooltipStyle.toString());
        }
        if (this.hasItemModel()) {
            builder.put((Object)CraftMetaItem.ITEM_MODEL.BUKKIT, (Object)this.itemModel.toString());
        }
        if (this.isUnbreakable()) {
            builder.put((Object)CraftMetaItem.UNBREAKABLE.BUKKIT, (Object)this.unbreakable);
        }
        if (this.hasEnchantmentGlintOverride()) {
            builder.put((Object)CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, (Object)this.enchantmentGlintOverride);
        }
        if (this.isGlider()) {
            builder.put((Object)CraftMetaItem.GLIDER.BUKKIT, (Object)this.glider);
        }
        if (this.hasDamageResistant()) {
            builder.put((Object)CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, (Object)this.damageResistant.location().toString());
        }
        if (this.hasDamageType()) {
            builder.put((Object)CraftMetaItem.DAMAGE_TYPE.BUKKIT, (Object)this.getDamageTypeKey().toString());
        }
        if (this.hasMaxStackSize()) {
            builder.put((Object)CraftMetaItem.MAX_STACK_SIZE.BUKKIT, (Object)this.maxStackSize);
        }
        if (this.hasRarity()) {
            builder.put((Object)CraftMetaItem.RARITY.BUKKIT, (Object)this.rarity.name());
        }
        if (this.hasUseRemainder()) {
            builder.put((Object)CraftMetaItem.USE_REMAINDER.BUKKIT, (Object)this.useRemainder);
        }
        if (this.hasUseCooldown()) {
            builder.put((Object)CraftMetaItem.USE_COOLDOWN.BUKKIT, (Object)this.useCooldown);
        }
        if (this.hasUseEffects()) {
            builder.put((Object)CraftMetaItem.USE_EFFECTS.BUKKIT, (Object)this.useEffects);
        }
        if (this.hasSwingAnimation()) {
            builder.put((Object)CraftMetaItem.SWING_ANIMATION.BUKKIT, (Object)this.swingAnimation);
        }
        if (this.hasAttackRange()) {
            builder.put((Object)CraftMetaItem.ATTACK_RANGE.BUKKIT, (Object)this.attackRange);
        }
        if (this.hasPiercingWeapon()) {
            builder.put((Object)CraftMetaItem.PIERCING_WEAPON.BUKKIT, (Object)this.piercingWeapon);
        }
        if (this.hasKineticWeapon()) {
            builder.put((Object)CraftMetaItem.KINETIC_WEAPON.BUKKIT, (Object)this.kineticWeapon);
        }
        if (this.hasFood()) {
            builder.put((Object)CraftMetaItem.FOOD.BUKKIT, (Object)this.food);
        }
        if (this.hasConsumable()) {
            builder.put((Object)CraftMetaItem.CONSUMABLE.BUKKIT, (Object)this.consumable);
        }
        if (this.hasTool()) {
            builder.put((Object)CraftMetaItem.TOOL.BUKKIT, (Object)this.tool);
        }
        if (this.hasBlocksAttacks()) {
            builder.put((Object)CraftMetaItem.BLOCKS_ATTACKS.BUKKIT, (Object)this.blocksAttacks);
        }
        if (this.hasWeapon()) {
            builder.put((Object)CraftMetaItem.WEAPON.BUKKIT, (Object)this.weapon);
        }
        if (this.hasEquippable()) {
            builder.put((Object)CraftMetaItem.EQUIPPABLE.BUKKIT, (Object)this.equippable);
        }
        if (this.hasJukeboxPlayable()) {
            builder.put((Object)CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, (Object)this.jukebox);
        }
        if (this.hasBreakSound()) {
            builder.put((Object)CraftMetaItem.BREAK_SOUND.BUKKIT, (Object)this.getBreakSound().getKey().toString());
        }
        if (this.hasDamage()) {
            builder.put((Object)CraftMetaItem.DAMAGE.BUKKIT, (Object)this.damage);
        }
        if (this.hasMaxDamage()) {
            builder.put((Object)CraftMetaItem.MAX_DAMAGE.BUKKIT, (Object)this.maxDamage);
        }
        if (this.hasMinimumAttackCharge()) {
            builder.put((Object)CraftMetaItem.MINIMUM_ATTACK_CHARGE.BUKKIT, (Object)this.minimumAttackCharge);
        }
        HashMap<String, net.minecraft.nbt.Tag> internalTags = new HashMap<String, net.minecraft.nbt.Tag>();
        this.serializeInternal(internalTags);
        if (!internalTags.isEmpty()) {
            CompoundTag internal = new CompoundTag();
            for (Map.Entry e : internalTags.entrySet()) {
                internal.put((String)e.getKey(), (net.minecraft.nbt.Tag)e.getValue());
            }
            try {
                buf = new ByteArrayOutputStream();
                NbtIo.writeCompressed(internal, buf);
                builder.put((Object)"internal", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!this.unhandledTags.isEmpty()) {
            net.minecraft.nbt.Tag unhandled = (net.minecraft.nbt.Tag)DataComponentPatch.CODEC.encodeStart(MinecraftServer.getDefaultRegistryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)this.unhandledTags.build()).getOrThrow(IllegalStateException::new);
            try {
                buf = new ByteArrayOutputStream();
                NbtIo.writeCompressed((CompoundTag)unhandled, buf);
                builder.put((Object)"unhandled", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!this.removedTags.isEmpty()) {
            RegistryAccess registryAccess = CraftRegistry.getMinecraftRegistry();
            HolderLookup.RegistryLookup componentTypeRegistry = registryAccess.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
            ArrayList<String> removedTags = new ArrayList<String>();
            for (DataComponentType<?> removed : this.removedTags) {
                String componentKey = componentTypeRegistry.getResourceKey(removed).orElseThrow().identifier().toString();
                removedTags.add(componentKey);
            }
            builder.put((Object)"removed", removedTags);
        }
        if (!this.persistentDataContainer.isEmpty()) {
            builder.put((Object)CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, (Object)this.persistentDataContainer.serialize());
        }
        if (this.customTag != null) {
            try {
                ByteArrayOutputStream buf2 = new ByteArrayOutputStream();
                NbtIo.writeCompressed(this.customTag, buf2);
                builder.put((Object)"custom", (Object)Base64.getEncoder().encodeToString(buf2.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return builder;
    }

    void serializeInternal(Map<String, net.minecraft.nbt.Tag> unhandledTags) {
    }

    static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)CraftEnchantment.bukkitToString(enchant.getKey()), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    static void serializeModifiers(Multimap<Attribute, org.bukkit.attribute.AttributeModifier> modifiers, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (modifiers == null || modifiers.isEmpty()) {
            return;
        }
        LinkedHashMap mods = new LinkedHashMap();
        for (Map.Entry entry : modifiers.entries()) {
            Collection modCollection;
            if (entry.getKey() == null || (modCollection = modifiers.get((Object)((Attribute)entry.getKey()))) == null || modCollection.isEmpty()) continue;
            mods.put(CraftAttribute.bukkitToString((Attribute)entry.getKey()), new ArrayList(modCollection));
        }
        builder.put((Object)key.BUKKIT, mods);
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<Component> addTo, boolean possiblyJsonInput) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            Component component;
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(String.valueOf(addFrom) + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add(Component.empty());
                continue;
            }
            String entry = object.toString();
            Component component2 = component = possiblyJsonInput ? CraftChatMessage.fromJSONOrString(entry) : CraftChatMessage.fromStringOrNull(entry);
            if (component != null) {
                addTo.add(component);
                continue;
            }
            addTo.add(Component.empty());
        }
    }

    static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        for (Enchantment enchant : enchantments.keySet()) {
            if (!enchant.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return (String)SerializableMeta.classMap.get(this.getClass()) + "_META:" + String.valueOf(this.serialize());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<DataComponentType> getHandledTags() {
        Set<DataComponentType> set = HANDLED_TAGS;
        synchronized (set) {
            if (HANDLED_TAGS.isEmpty()) {
                HANDLED_TAGS.addAll(Arrays.asList(CraftMetaItem.NAME.TYPE, CraftMetaItem.ITEM_NAME.TYPE, CraftMetaItem.LORE.TYPE, CraftMetaItem.CUSTOM_MODEL_DATA.TYPE, CraftMetaItem.ENCHANTABLE.TYPE, CraftMetaItem.BLOCK_DATA.TYPE, CraftMetaItem.REPAIR.TYPE, CraftMetaItem.ENCHANTMENTS.TYPE, CraftMetaItem.HIDEFLAGS.TYPE, CraftMetaItem.TOOLTIP_STYLE.TYPE, CraftMetaItem.ITEM_MODEL.TYPE, CraftMetaItem.UNBREAKABLE.TYPE, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.TYPE, CraftMetaItem.GLIDER.TYPE, CraftMetaItem.DAMAGE_RESISTANT.TYPE, CraftMetaItem.MAX_STACK_SIZE.TYPE, CraftMetaItem.RARITY.TYPE, CraftMetaItem.USE_REMAINDER.TYPE, CraftMetaItem.USE_COOLDOWN.TYPE, CraftMetaItem.FOOD.TYPE, CraftMetaItem.CONSUMABLE.TYPE, CraftMetaItem.TOOL.TYPE, CraftMetaItem.BLOCKS_ATTACKS.TYPE, CraftMetaItem.WEAPON.TYPE, CraftMetaItem.EQUIPPABLE.TYPE, CraftMetaItem.JUKEBOX_PLAYABLE.TYPE, CraftMetaItem.BREAK_SOUND.TYPE, CraftMetaItem.DAMAGE.TYPE, CraftMetaItem.MAX_DAMAGE.TYPE, CraftMetaItem.CUSTOM_DATA.TYPE, CraftMetaItem.ATTRIBUTES.TYPE, CraftMetaItem.MINIMUM_ATTACK_CHARGE.TYPE, CraftMetaItem.DAMAGE_TYPE.TYPE, CraftMetaItem.USE_EFFECTS.TYPE, CraftMetaItem.SWING_ANIMATION.TYPE, CraftMetaItem.PIERCING_WEAPON.TYPE, CraftMetaItem.KINETIC_WEAPON.TYPE, CraftMetaArmor.TRIM.TYPE, CraftMetaArmorStand.ENTITY_TAG.TYPE, CraftMetaBanner.PATTERNS.TYPE, CraftMetaEntityTag.ENTITY_TAG.TYPE, CraftMetaLeatherArmor.COLOR.TYPE, CraftMetaMap.MAP_POST_PROCESSING.TYPE, CraftMetaMap.MAP_COLOR.TYPE, CraftMetaMap.MAP_ID.TYPE, CraftMetaPotion.POTION_CONTENTS.TYPE, CraftMetaShield.BASE_COLOR.TYPE, CraftMetaSkull.SKULL_PROFILE.TYPE, CraftMetaSkull.NOTE_BLOCK_SOUND.TYPE, CraftMetaSpawnEgg.ENTITY_TAG.TYPE, CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, CraftMetaBook.BOOK_CONTENT.TYPE, CraftMetaBookSigned.BOOK_CONTENT.TYPE, CraftMetaFirework.FIREWORKS.TYPE, CraftMetaEnchantedBook.STORED_ENCHANTMENTS.TYPE, CraftMetaCharge.EXPLOSION.TYPE, CraftMetaKnowledgeBook.BOOK_RECIPES.TYPE, CraftMetaTropicalFishBucket.ENTITY_TAG.TYPE, CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.TYPE, CraftMetaAxolotlBucket.ENTITY_TAG.TYPE, CraftMetaAxolotlBucket.BUCKET_ENTITY_TAG.TYPE, CraftMetaCrossbow.CHARGED_PROJECTILES.TYPE, CraftMetaSuspiciousStew.EFFECTS.TYPE, CraftMetaCompass.LODESTONE_TARGET.TYPE, CraftMetaBundle.ITEMS.TYPE, CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.TYPE, CraftMetaOminousBottle.OMINOUS_BOTTLE_AMPLIFIER.TYPE));
            }
            return HANDLED_TAGS;
        }
    }

    protected static <T> Optional<? extends T> getOrEmpty(DataComponentPatch tag, ItemMetaKeyType<T> type) {
        Optional result = tag.get(type.TYPE);
        return result != null ? result : Optional.empty();
    }

    static final class ItemMetaKeyType<T>
    extends ItemMetaKey {
        final DataComponentType<T> TYPE;

        ItemMetaKeyType(DataComponentType<T> type) {
            this(type, null, null);
        }

        ItemMetaKeyType(DataComponentType<T> type, String both) {
            this(type, both, both);
        }

        ItemMetaKeyType(DataComponentType<T> type, String nbt, String bukkit) {
            super(nbt, bukkit);
            this.TYPE = type;
        }
    }

    static final class Applicator {
        private final DataComponentPatch.Builder builder = DataComponentPatch.builder();

        Applicator() {
        }

        <T> Applicator put(ItemMetaKeyType<T> key, T value) {
            this.builder.set(key.TYPE, value);
            return this;
        }

        <T> Applicator putIfAbsent(TypedDataComponent<?> component) {
            if (!this.builder.isSet(component.type())) {
                this.builder.set(component);
            }
            return this;
        }

        DataComponentPatch build() {
            return this.builder.build();
        }
    }
}

